/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class ConnectivityUtil {
    private final int defaultBatchSize;
    private final int maximumBatchSize;
    private final Context context;

    public ConnectivityUtil(int defaultBatchSize, int maximumBatchSize, Context context) {
        this.defaultBatchSize = defaultBatchSize;
        this.maximumBatchSize = maximumBatchSize;
        this.context = context;
    }

    public int getBatchSize() {
        int returnBatchSize = this.defaultBatchSize;
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            block0 : switch (networkInfo.getType()) {
                case 1: {
                    returnBatchSize = this.maximumBatchSize;
                    break;
                }
                case 0: {
                    switch (telephonyManager.getNetworkType()) {
                        case 13: 
                        case 15: {
                            returnBatchSize = this.defaultBatchSize * 4;
                            break block0;
                        }
                        case 1: 
                        case 2: {
                            returnBatchSize = this.defaultBatchSize / 2;
                        }
                    }
                }
            }
        }
        return returnBatchSize;
    }
}

