/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.os.Environment;
import com.helpshift.util.HelpshiftContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;

public class DBUtil {
    private static String sdPath;

    private static synchronized String getSdPath() {
        if (sdPath == null) {
            sdPath = ".backups/" + HelpshiftContext.getApplicationContext().getPackageName() + "/helpshift/databases/";
        }
        return sdPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File dstFilePath, HashMap<String, Serializable> data) {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(dstFilePath));
            outputStream.writeObject(data);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File dstDBPath, String srcDBPathName) {
        String currentDBPath = HelpshiftContext.getApplicationContext().getDatabasePath(srcDBPathName).getPath();
        AbstractInterruptibleChannel dst = null;
        AbstractInterruptibleChannel src = null;
        try {
            File srcDBPath = new File(currentDBPath);
            src = new FileInputStream(srcDBPath).getChannel();
            dst = new FileOutputStream(dstDBPath).getChannel();
            ((FileChannel)dst).transferFrom((ReadableByteChannel)((Object)src), 0L, ((FileChannel)src).size());
            src.close();
            dst.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (src != null) {
                    src.close();
                }
                if (dst != null) {
                    dst.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void backupData(String fileName, HashMap<String, Serializable> data) {
        if (data == null && !DBUtil.doesDatabaseExist(fileName)) {
            return;
        }
        try {
            File sd = Environment.getExternalStoragePublicDirectory((String)DBUtil.getSdPath());
            if (!sd.exists()) {
                sd.mkdirs();
            }
            if (sd.canWrite()) {
                File dstDBPath = new File(sd, fileName);
                if (data != null) {
                    DBUtil.copy(dstDBPath, data);
                } else {
                    DBUtil.copy(dstDBPath, fileName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void backupDatabase(String dbName) {
        DBUtil.backupData(dbName, null);
    }

    public static void backupHashMap(String fileName, HashMap<String, Serializable> data) {
        DBUtil.backupData(fileName, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreDatabaseBackup(String dbName) {
        if (DBUtil.doesDatabaseExist(dbName)) {
            return;
        }
        AbstractInterruptibleChannel dst = null;
        AbstractInterruptibleChannel src = null;
        try {
            File sd = Environment.getExternalStoragePublicDirectory((String)DBUtil.getSdPath());
            if (sd.canRead()) {
                String currentDBPath = HelpshiftContext.getApplicationContext().getDatabasePath(dbName).getPath();
                File srcDBPath = new File(sd, dbName);
                File dstDBPath = new File(currentDBPath);
                src = new FileInputStream(srcDBPath).getChannel();
                dst = new FileOutputStream(dstDBPath).getChannel();
                ((FileChannel)dst).transferFrom((ReadableByteChannel)((Object)src), 0L, ((FileChannel)src).size());
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (src != null) {
                    src.close();
                }
                if (dst != null) {
                    dst.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean doesDatabaseExist(String fileName) {
        File dbFile = HelpshiftContext.getApplicationContext().getDatabasePath(fileName);
        return dbFile.exists();
    }

    public static boolean doesExternalFileExist(String fileName) {
        File sd = Environment.getExternalStoragePublicDirectory((String)DBUtil.getSdPath());
        File srcPath = new File(sd, fileName);
        return srcPath.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Serializable> restoreHashMap(String fileName) {
        if (!DBUtil.doesExternalFileExist(fileName)) {
            return null;
        }
        HashMap data = null;
        ObjectInputStream inputStream = null;
        try {
            File sd = Environment.getExternalStoragePublicDirectory((String)DBUtil.getSdPath());
            if (sd.canRead()) {
                File srcDBPath = new File(sd, fileName);
                inputStream = new ObjectInputStream(new FileInputStream(srcDBPath));
                data = (HashMap)inputStream.readObject();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return data;
    }
}

