/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.List;

public class DatabaseUtils {
    public static final int MAX_WILDCARD_COUNT = 900;

    public static boolean exists(SQLiteDatabase database, String table, String query, String[] selectionArgs) {
        return android.database.DatabaseUtils.longForQuery((SQLiteDatabase)database, (String)("SELECT COUNT(*) FROM " + table + " WHERE " + query + " LIMIT 1"), (String[])selectionArgs) > 0L;
    }

    public static String makePlaceholders(int len) {
        if (len >= 1) {
            StringBuilder sb = new StringBuilder(len * 2 - 1);
            sb.append("?");
            for (int i = 1; i < len; ++i) {
                sb.append(",?");
            }
            return sb.toString();
        }
        return null;
    }

    public static <T> List<List<T>> createBatches(int batchSize, List<T> data) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        if (batchSize > data.size()) {
            batches.add(data);
        } else {
            int end = batchSize;
            for (int start = 0; end <= data.size() && start <= end; start += batchSize) {
                List<T> batch = data.subList(start, end);
                end = Math.min(batch.size() + end, data.size());
                if (batch.size() <= 0) continue;
                batches.add(batch);
            }
        }
        return batches;
    }
}

