/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.providers.CrossModuleDataProvider;
import com.helpshift.providers.ISupportDataProvider;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class ErrorReportProvider {
    public static final String KEY_FUNNEL = "funnel";
    public static final String KEY_ACTIVE_CONVERSATION_ID = "actconvid";
    public static final String KEY_THREAD_INFO = "thread";
    public static final String KEY_NETWORK_TYPE = "nt";
    public static final String KEY_APP_ID = "appId";
    public static final long BATCH_TIME = 86400000L;
    private static String TAG = "HS_ErrorReport";

    public static List<ILogExtrasModel> getErrorReportExtras(Context context, Thread thread) {
        ArrayList<ILogExtrasModel> errorReportExtras = new ArrayList<ILogExtrasModel>();
        try {
            String activeConversationId;
            String jsonArrayFunnel;
            errorReportExtras.add(LogExtrasModelProvider.fromString(KEY_APP_ID, context.getPackageName()));
            errorReportExtras.add(LogExtrasModelProvider.fromString(KEY_NETWORK_TYPE, HelpshiftConnectionUtil.getNetworkType(context)));
            ISupportDataProvider supportDataProvider = CrossModuleDataProvider.getSupportDataProvider();
            String string2 = jsonArrayFunnel = supportDataProvider == null ? "" : supportDataProvider.getActionEvents();
            if (jsonArrayFunnel != null) {
                errorReportExtras.add(LogExtrasModelProvider.fromString(KEY_FUNNEL, jsonArrayFunnel));
            }
            String string3 = activeConversationId = supportDataProvider == null ? "" : supportDataProvider.getActiveConversationId();
            if (!TextUtils.isEmpty(activeConversationId)) {
                errorReportExtras.add(LogExtrasModelProvider.fromString(KEY_ACTIVE_CONVERSATION_ID, activeConversationId));
            }
            String threadInfo = "Unknown";
            if (thread != null) {
                threadInfo = thread.toString();
            }
            errorReportExtras.add(LogExtrasModelProvider.fromString(KEY_THREAD_INFO, threadInfo));
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error creating error report", e);
        }
        return errorReportExtras;
    }
}

