/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.util.Patterns;
import android.view.View;
import android.webkit.WebView;
import android.widget.TextView;
import com.helpshift.util.LinkSpec;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HSLinkify {
    private static final int WEB_URLS = 1;
    private static final int EMAIL_ADDRESSES = 2;
    private static final int PHONE_NUMBERS = 4;
    private static final int MAP_ADDRESSES = 8;
    public static final int ALL = 15;
    private static final MatchFilter sUrlMatchFilter = new MatchFilter(){

        @Override
        public final boolean acceptMatch(CharSequence s, int start, int end) {
            if (start == 0) {
                return true;
            }
            return s.charAt(start - 1) != '@';
        }
    };

    private static boolean addLinks(Spannable text, int mask, final LinkClickListener linkClickListener) {
        int i;
        boolean hasPrefix;
        String[] prefixes;
        String url;
        LinkSpec spec;
        int end;
        int start;
        Matcher m;
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i2 = old.length - 1; i2 >= 0; --i2) {
            text.removeSpan((Object)old[i2]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            m = Patterns.WEB_URL.matcher((CharSequence)text);
            while (m.find()) {
                start = m.start();
                end = m.end();
                if (sUrlMatchFilter != null && !sUrlMatchFilter.acceptMatch((CharSequence)text, start, end)) continue;
                spec = new LinkSpec();
                url = m.group(0);
                prefixes = new String[]{"http://", "https://", "rtsp://"};
                hasPrefix = false;
                for (i = 0; i < prefixes.length; ++i) {
                    if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
                    hasPrefix = true;
                    if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
                    url = prefixes[i] + url.substring(prefixes[i].length());
                    break;
                }
                if (!hasPrefix) {
                    url = prefixes[0] + url;
                }
                spec.url = url;
                spec.start = start;
                spec.end = end;
                links.add(spec);
            }
        }
        if ((mask & 2) != 0) {
            m = Patterns.EMAIL_ADDRESS.matcher((CharSequence)text);
            while (m.find()) {
                start = m.start();
                end = m.end();
                spec = new LinkSpec();
                url = m.group(0);
                prefixes = new String[]{"mailto:"};
                hasPrefix = false;
                for (i = 0; i < prefixes.length; ++i) {
                    if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
                    hasPrefix = true;
                    if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
                    url = prefixes[i] + url.substring(prefixes[i].length());
                    break;
                }
                if (!hasPrefix) {
                    url = prefixes[0] + url;
                }
                spec.url = url;
                spec.start = start;
                spec.end = end;
                links.add(spec);
            }
        }
        if ((mask & 8) != 0) {
            String string2 = text.toString();
            int base = 0;
            try {
                int start2;
                String address;
                while ((address = WebView.findAddress((String)string2)) != null && (start2 = string2.indexOf(address)) >= 0) {
                    String encodedAddress;
                    LinkSpec spec2 = new LinkSpec();
                    int length = address.length();
                    int end2 = start2 + length;
                    spec2.start = base + start2;
                    spec2.end = base + end2;
                    string2 = string2.substring(end2);
                    base += end2;
                    try {
                        encodedAddress = URLEncoder.encode(address, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        continue;
                    }
                    spec2.url = "geo:0,0?q=" + encodedAddress;
                    links.add(spec2);
                }
            }
            catch (UnsupportedOperationException start2) {
                // empty catch block
            }
        }
        if ((mask & 4) != 0) {
            Pattern telephonePattern = Patterns.PHONE;
            Matcher matcher = telephonePattern.matcher((CharSequence)text);
            while (matcher.find()) {
                String matchedString = matcher.group();
                if (matchedString.length() < 6) continue;
                LinkSpec spec3 = new LinkSpec();
                spec3.url = "tel:" + matchedString;
                spec3.start = matcher.start();
                spec3.end = matcher.end();
                links.add(spec3);
            }
        }
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){

            @Override
            public final int compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }

            @Override
            public final boolean equals(Object o) {
                return false;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i3 = 0;
        while (i3 < len - 1) {
            LinkSpec a = (LinkSpec)links.get(i3);
            LinkSpec b = (LinkSpec)links.get(i3 + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i3 + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i3 + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i3;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i3;
        }
        if (links.size() == 0) {
            return false;
        }
        for (final LinkSpec link : links) {
            URLSpan span = new URLSpan(link.url){

                public void onClick(View widget) {
                    super.onClick(widget);
                    if (linkClickListener != null) {
                        linkClickListener.onLinkClicked(link.url);
                    }
                }
            };
            text.setSpan((Object)span, link.start, link.end, 33);
        }
        return true;
    }

    public static boolean addLinks(TextView text, int mask, LinkClickListener listener) {
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (HSLinkify.addLinks((Spannable)t, mask, listener)) {
                MovementMethod m = text.getMovementMethod();
                if ((m == null || !(m instanceof LinkMovementMethod)) && text.getLinksClickable()) {
                    text.setMovementMethod(LinkMovementMethod.getInstance());
                }
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf((CharSequence)t);
        if (HSLinkify.addLinks((Spannable)s, mask, listener)) {
            MovementMethod m = text.getMovementMethod();
            if ((m == null || !(m instanceof LinkMovementMethod)) && text.getLinksClickable()) {
                text.setMovementMethod(LinkMovementMethod.getInstance());
            }
            text.setText((CharSequence)s);
            return true;
        }
        return false;
    }

    public static void addLinks(TextView text, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter, LinkClickListener listener) {
        SpannableString s = SpannableString.valueOf((CharSequence)text.getText());
        if (HSLinkify.addLinks((Spannable)s, p, scheme, matchFilter, transformFilter, listener)) {
            text.setText((CharSequence)s);
            MovementMethod m = text.getMovementMethod();
            if ((m == null || !(m instanceof LinkMovementMethod)) && text.getLinksClickable()) {
                text.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
    }

    private static boolean addLinks(Spannable s, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter, final LinkClickListener linkClickListener) {
        boolean hasMatches = false;
        String prefix = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        Matcher m = p.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch((CharSequence)s, start, end);
            }
            if (!allowed) continue;
            String url1 = m.group(0);
            String[] prefixes = new String[]{prefix};
            if (transformFilter != null) {
                url1 = transformFilter.transformUrl(m, url1);
            }
            boolean hasPrefix = false;
            for (int i = 0; i < prefixes.length; ++i) {
                if (!url1.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
                hasPrefix = true;
                if (url1.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
                url1 = prefixes[i] + url1.substring(prefixes[i].length());
                break;
            }
            if (!hasPrefix) {
                url1 = prefixes[0] + url1;
            }
            final String url = url1;
            URLSpan span = new URLSpan(url){

                public void onClick(View widget) {
                    super.onClick(widget);
                    if (linkClickListener != null) {
                        linkClickListener.onLinkClicked(url);
                    }
                }
            };
            s.setSpan((Object)span, start, end, 33);
            hasMatches = true;
        }
        return hasMatches;
    }

    public static interface LinkClickListener {
        public void onLinkClicked(String var1);
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }
}

