/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import com.helpshift.logger.ILogger;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.logger.model.LogModel;
import java.util.List;

public class HSLogger {
    public static final String LOG_STORE_DB_NAME = "__hs_log_store";
    public static final String OLD_ERROR_REPORTING_DATABASE_NAME = "__hs__db_error_reports";
    private static ILogger logger;

    public static void initialize(ILogger logger) {
        HSLogger.logger = logger;
    }

    public static void updateTimeStampDelta(float serverTimestampDelta) {
        logger.setTimestampDelta((long)serverTimestampDelta * 1000L);
    }

    public static void enableLogging(boolean enableConsoleLogging, boolean enableLogCaching) {
        if (logger != null) {
            logger.enableLogging(enableConsoleLogging, enableLogCaching);
        }
    }

    public static void d(String tag, String message) {
        HSLogger.d(tag, message, null, null);
    }

    public static void w(String tag, String message) {
        HSLogger.w(tag, message, null, null);
    }

    public static void e(String tag, String message) {
        HSLogger.e(tag, message, (Throwable[])null, null);
    }

    public static void d(String tag, String message, Throwable tr) {
        HSLogger.d(tag, message, tr, null);
    }

    public static void w(String tag, String message, Throwable tr) {
        HSLogger.w(tag, message, tr, null);
    }

    public static void e(String tag, String message, Throwable tr) {
        HSLogger.e(tag, message, new Throwable[]{tr}, null);
    }

    public static void d(String tag, String message, ILogExtrasModel ... extras) {
        HSLogger.d(tag, message, null, extras);
    }

    public static void d(String tag, String message, Throwable tr, ILogExtrasModel ... extras) {
        HSLogger.logMessage(2, tag, message, new Throwable[]{tr}, extras);
    }

    public static void w(String tag, String message, Throwable tr, ILogExtrasModel ... extras) {
        HSLogger.logMessage(4, tag, message, new Throwable[]{tr}, extras);
    }

    public static void e(String tag, String message, Throwable tr, ILogExtrasModel ... extras) {
        HSLogger.logMessage(8, tag, message, new Throwable[]{tr}, extras);
    }

    public static void e(String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        HSLogger.logMessage(8, tag, message, tr, extras);
    }

    public static void f(String tag, String message, Throwable tr, ILogExtrasModel ... extras) {
        HSLogger.logMessage(16, tag, message, new Throwable[]{tr}, extras);
    }

    public static void f(String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        HSLogger.logMessage(16, tag, message, tr, extras);
    }

    private static void logMessage(int level, String tag, String message, Throwable[] tr, ILogExtrasModel ... extras) {
        if (logger == null) {
            return;
        }
        switch (level) {
            case 8: {
                logger.e(tag, message, tr, extras);
                break;
            }
            case 4: {
                logger.w(tag, message, tr, extras);
                break;
            }
            case 2: {
                logger.d(tag, message, tr, extras);
                break;
            }
            case 16: {
                logger.f(tag, message, tr, extras);
            }
        }
    }

    public static List<LogModel> getAll() {
        if (logger == null) {
            return null;
        }
        return logger.getAll();
    }

    public static void deleteAll() {
        if (logger == null) {
            return;
        }
        logger.deleteAllCachedLogs();
    }

    public static int getFatalLogsCount() {
        if (logger == null) {
            return 0;
        }
        return logger.getCount(16);
    }
}

