/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HSPattern {
    private static Pattern specialCharPattern;
    private static Pattern namePattern;
    private static Pattern emailPattern;
    private static Pattern ipPattern;
    private static Pattern timeStampPattern;
    private static Pattern domainNamePattern;
    private static Pattern customPropertyPattern;
    private static Pattern propertyKeyPattern;
    private static Pattern urlPattern;

    public static boolean isValidEmail(String email) {
        if (null == emailPattern) {
            emailPattern = Pattern.compile("[a-zA-Z0-9\\+\\.\\_\\%\\-\\+]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{1,62})+");
        }
        Matcher m = emailPattern.matcher(email.trim());
        return m.matches();
    }

    public static boolean isValidName(String name) {
        if (null == namePattern) {
            namePattern = Pattern.compile("^[\\p{L}\\p{M}\\p{N}].*");
        }
        Matcher m = namePattern.matcher(name.trim());
        return m.matches();
    }

    public static boolean hasOnlySpecialCharacters(String issueText) {
        if (null == specialCharPattern) {
            specialCharPattern = Pattern.compile("\\W+");
        }
        Matcher m = specialCharPattern.matcher(issueText.trim());
        return m.matches();
    }

    public static String sanitiseCustomPropertyKey(String key) {
        if (null == customPropertyPattern) {
            customPropertyPattern = Pattern.compile("^[A-Za-z0-9_]+$");
        }
        String sanitisedKey = key.trim();
        Matcher m = customPropertyPattern.matcher(sanitisedKey = sanitisedKey.replace("-", "_").replace(" ", "_"));
        if (!m.matches()) {
            sanitisedKey = null;
        }
        return sanitisedKey;
    }

    public static boolean checkIpv4Address(String ipAddress) {
        if (null == ipPattern) {
            ipPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)$");
        }
        if (ipAddress == null || ipAddress.trim().length() == 0) {
            return false;
        }
        Matcher m = ipPattern.matcher(ipAddress.trim());
        if (m.matches()) {
            for (int i = 1; i < m.groupCount(); ++i) {
                String componentString = m.group(i);
                Integer component = Integer.parseInt(componentString);
                if (component >= 0 && component <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Pattern getComponentPlaceHolderPattern(String component) {
        return Pattern.compile("^[\\p{L}\\p{N}-]+_" + component + "_\\d{17}-[0-9a-z]{15}$");
    }

    public static Pattern getTimeStampPattern() {
        if (null == timeStampPattern) {
            timeStampPattern = Pattern.compile("^\\d+.\\d{3}$");
        }
        return timeStampPattern;
    }

    public static Pattern getDomainNamePattern() {
        if (null == domainNamePattern) {
            domainNamePattern = Pattern.compile("^[\\p{L}\\p{N}][\\p{L}\\p{N}-]*[\\p{L}\\p{N}]\\.helpshift\\.(com|mobi)$");
        }
        return domainNamePattern;
    }

    public static Pattern getPropertyKeyPattern() {
        if (null == propertyKeyPattern) {
            propertyKeyPattern = Pattern.compile("^[\\p{L}\\p{N}][\\p{L}\\p{N}\\p{Pd}\\p{Pc}]*[\\p{L}\\p{N}]$");
        }
        return propertyKeyPattern;
    }

    public static Pattern getUrlPattern() {
        if (null == urlPattern) {
            urlPattern = Pattern.compile("[^\\p{Z}\\n\\p{Ps}]+://[^\\p{Z}\\n\\p{Pe}]*");
        }
        return urlPattern;
    }
}

