/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import com.helpshift.model.InfoModelFactory;
import java.util.Locale;

public class LocaleUtil {
    public static String getAcceptLanguageHeader() {
        String sdkLanguage = InfoModelFactory.getInstance().sdkInfoModel.getSdkLanguage();
        if (TextUtils.isEmpty((CharSequence)sdkLanguage)) {
            return Locale.getDefault().toString();
        }
        return sdkLanguage;
    }

    public static String getCountry(Context context) {
        String localeCountry = "";
        Locale topLocale = null;
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = context.getResources().getConfiguration().getLocales();
            if (localeList.size() > 0) {
                topLocale = localeList.get(0);
            }
        } else {
            topLocale = context.getResources().getConfiguration().locale;
        }
        if (topLocale != null) {
            localeCountry = topLocale.getCountry();
        }
        return localeCountry;
    }
}

