/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import com.helpshift.exceptions.InstallException;
import com.helpshift.util.HSPattern;
import com.helpshift.util.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaUtil {
    private static boolean validateInputForComponent(String input, String component) {
        Pattern pattern = HSPattern.getComponentPlaceHolderPattern(component);
        Matcher m = pattern.matcher(input);
        return !TextUtils.isEmpty(input) && m.matches();
    }

    public static boolean validatePlatformId(String platformId) {
        return !TextUtils.isEmpty(platformId) && SchemaUtil.validateInputForComponent(platformId, "platform");
    }

    public static boolean validateTimestamp(String timeStamp) {
        if (TextUtils.isEmpty(timeStamp)) {
            return false;
        }
        Pattern timeStampPattern = HSPattern.getTimeStampPattern();
        Matcher m = timeStampPattern.matcher(timeStamp);
        return m.matches();
    }

    public static boolean validateDomainName(String domainName) {
        if (TextUtils.isEmpty(domainName)) {
            return false;
        }
        Pattern domainNamePattern = HSPattern.getDomainNamePattern();
        Matcher m = domainNamePattern.matcher(domainName);
        return m.matches();
    }

    public static boolean validatePropertyKey(String propertyKey) {
        if (TextUtils.isEmpty(propertyKey)) {
            return false;
        }
        Pattern propertyKeyPattern = HSPattern.getPropertyKeyPattern();
        Matcher m = propertyKeyPattern.matcher(propertyKey);
        return m.matches();
    }

    public static boolean validateApiKey(String apiKey) {
        return !TextUtils.isEmpty(apiKey);
    }

    public static boolean validateInstallCredentials(String apiKey, String domainName, String platformId) throws InstallException {
        if (!SchemaUtil.validateApiKey(apiKey)) {
            throw new InstallException("The api key used in the Core.install(application, apiKey, domain, appId) is not valid!");
        }
        if (!SchemaUtil.validateDomainName(domainName)) {
            throw new InstallException("The domain name used in the Core.install(application, apiKey, domain, appId) is not valid!");
        }
        if (!SchemaUtil.validatePlatformId(platformId)) {
            throw new InstallException("The app id used in the Core.install(application, apiKey, domain, appId) is not valid!");
        }
        return true;
    }
}

