/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import com.helpshift.R;

public class Styles {
    public static int getColor(Context context, int attribute) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attribute});
        int color2 = typedArray.getColor(0, -1);
        typedArray.recycle();
        return color2;
    }

    public static int getDrawableResId(Context context, int attribute, int defaultResId) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attribute});
        int drawableId = typedArray.getResourceId(0, defaultResId);
        typedArray.recycle();
        return drawableId;
    }

    public static String getHexColor(Context context, int attribute) {
        return Styles.getHexColor(Styles.getColor(context, attribute));
    }

    public static String getHexColor(int color2) {
        return String.format("#%06X", 0xFFFFFF & color2);
    }

    public static void setActionButtonIconColor(Context context, Drawable actionButtonIcon) {
        Styles.setColorFilter(context, actionButtonIcon, R.attr.hs__actionButtonIconColor);
    }

    public static void setColorFilter(Context context, Drawable drawable2, int attr2) {
        if (drawable2 != null) {
            drawable2.setColorFilter(Styles.getColor(context, attr2), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static void setColorFilter(Drawable drawable2, int color2) {
        if (drawable2 != null) {
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static float dpToPx(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }
}

