/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util.concurrent;

import com.helpshift.common.domain.HSThreadFactory;
import com.helpshift.util.HSLogger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class DispatchQueue {
    private static final String TAG = "HS_DispatchQueue";
    private LinkedBlockingQueue<Future> tasks = new LinkedBlockingQueue();
    private LinkedBlockingQueue<Thread> afterThreads = new LinkedBlockingQueue();
    private ExecutorService threadPoolExecutor;

    public DispatchQueue(boolean isConcurrent) {
        if (isConcurrent) {
            HSThreadFactory threadFactory = new HSThreadFactory("cmdpq-a");
            this.threadPoolExecutor = Executors.newCachedThreadPool(threadFactory);
        } else {
            HSThreadFactory threadFactory = new HSThreadFactory("cmdpq-b");
            this.threadPoolExecutor = Executors.newSingleThreadExecutor(threadFactory);
        }
    }

    public void dispatchSync(Runnable runnable) {
        Future<?> taskFuture = this.threadPoolExecutor.submit(runnable);
        try {
            taskFuture.get();
        }
        catch (InterruptedException e) {
            HSLogger.w(TAG, "Runnable interrupted : ", e);
        }
        catch (ExecutionException e) {
            HSLogger.w(TAG, "Execution exception : ", e);
        }
    }

    private void trackTask(Future task) {
        this.tasks.add(task);
    }

    public void dispatchAsync(Runnable runnable) {
        Future<?> task = this.threadPoolExecutor.submit(runnable);
        this.trackTask(task);
    }

    public void dispatchAfter(final Runnable runnable, final long interval) {
        final DispatchQueue queue = this;
        Thread triggerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(interval);
                    queue.dispatchAsync(runnable);
                }
                catch (InterruptedException e) {
                    HSLogger.w(DispatchQueue.TAG, "Runnable interrupted : ", e);
                }
            }
        }, "HS-cmdpq-trig");
        triggerThread.start();
        this.afterThreads.add(triggerThread);
    }

    public void join() {
        try {
            for (Thread t : this.afterThreads) {
                t.join();
            }
            for (Future task : this.tasks) {
                task.get();
            }
            this.tasks.clear();
        }
        catch (InterruptedException e) {
            HSLogger.w(TAG, "Runnable interrupted : ", e);
        }
        catch (ExecutionException e) {
            HSLogger.w(TAG, "Execution exception : ", e);
        }
    }
}

