/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util.concurrent;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.RunnableUtil;

public class HandlerThreadExecutor
implements ApiExecutor {
    private Handler handler;
    Handler uiHandler;
    private final Object syncLock = new Object();

    public HandlerThreadExecutor(String name) {
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
        this.uiHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void runAsync(Runnable r) {
        this.handler.post(r);
    }

    @Override
    public void runOnUiThread(final Runnable r) {
        this.runAsync(new Runnable(){

            @Override
            public void run() {
                HandlerThreadExecutor.this.uiHandler.post(r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSync(Runnable r) {
        RunnableUtil.NotifyingRunnable runnable = new RunnableUtil.NotifyingRunnable(r);
        Object object = this.syncLock;
        synchronized (object) {
            this.handler.post((Runnable)runnable);
            runnable.waitForCompletion();
        }
    }

    @Override
    public <T> RunnableUtil.RunnableFuture<T> callAndReturn(RunnableUtil.ValueRunnable<T> valueRunnable) {
        RunnableUtil.NotifyingRunnable runnable = new RunnableUtil.NotifyingRunnable(valueRunnable);
        RunnableUtil.RunnableFuture<T> result = new RunnableUtil.RunnableFuture<T>(valueRunnable, runnable);
        this.handler.post((Runnable)runnable);
        return result;
    }
}

