/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util.concurrent;

import com.helpshift.util.HSLogger;

public class RunnableUtil {

    public static class RunnableFuture<T> {
        private final ValueRunnable<T> runnable;
        private final NotifyingRunnable notifyingRunnable;

        RunnableFuture(ValueRunnable<T> r, NotifyingRunnable notifyingRunnable) {
            this.runnable = r;
            this.notifyingRunnable = notifyingRunnable;
        }

        public T get() {
            this.notifyingRunnable.waitForCompletion();
            return this.runnable.runnableValue;
        }
    }

    public static abstract class ValueRunnable<T>
    implements Runnable {
        public T runnableValue;
    }

    public static class NotifyingRunnable
    implements Runnable {
        private static final String TAG = "Helpshift_NotiRunnable";
        private final Runnable runnable;
        private boolean isFinished;
        private final Object syncLock = new Object();

        NotifyingRunnable(Runnable r) {
            this.runnable = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            Object object = this.syncLock;
            synchronized (object) {
                try {
                    if (!this.isFinished) {
                        this.syncLock.wait();
                    }
                }
                catch (InterruptedException e) {
                    HSLogger.d(TAG, "Exception in NotifyingRunnable", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.syncLock;
            synchronized (object) {
                try {
                    this.runnable.run();
                    this.isFinished = true;
                }
                finally {
                    this.syncLock.notifyAll();
                }
            }
        }
    }
}

