/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.views;

import android.app.Dialog;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.HSLogger;
import com.helpshift.views.HSTypefaceSpan;
import java.lang.ref.WeakReference;

public final class FontApplier {
    public static final String TAG = "HS_FontApplier";
    private static Typeface typeface;
    private static HSTypefaceSpan typefaceSpan;
    private static boolean typefaceInitialisationTried;

    private FontApplier() {
    }

    public static void apply(TextView textView) {
        FontApplier.initTypeface(textView.getContext());
        if (typeface == null) {
            return;
        }
        textView.setTypeface(typeface);
    }

    public static void apply(Dialog dialog) {
        View dialogRoot = dialog.findViewById(0x1020002);
        FontApplier.apply(dialogRoot);
    }

    public static void apply(View view) {
        FontApplier.initTypeface(view.getContext());
        if (typeface == null) {
            return;
        }
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new FontLayoutListener(view));
    }

    static void applyInternal(View view) {
        if (view instanceof TextView) {
            FontApplier.apply((TextView)view);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                FontApplier.applyInternal(viewGroup.getChildAt(i));
            }
        }
    }

    @Nullable
    public static HSTypefaceSpan getTypefaceSpan() {
        if (typeface != null && typefaceSpan == null) {
            typefaceSpan = new HSTypefaceSpan(typeface);
        }
        return typefaceSpan;
    }

    @Nullable
    public static String getFontPath() {
        return InfoModelFactory.getInstance().appInfoModel.getFontPath();
    }

    private static void initTypeface(Context context) {
        String fontPath = FontApplier.getFontPath();
        if (fontPath != null && typeface == null && !typefaceInitialisationTried) {
            try {
                typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontPath);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Typeface initialisation failed. Using default typeface. " + e.getMessage());
            }
            finally {
                typefaceInitialisationTried = true;
            }
        }
    }

    static {
        typefaceInitialisationTried = false;
    }

    private static class FontLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final WeakReference<View> viewRef;

        public FontLayoutListener(View view) {
            this.viewRef = new WeakReference<View>(view);
        }

        public void onGlobalLayout() {
            View view = (View)this.viewRef.get();
            if (view == null) {
                return;
            }
            FontApplier.applyInternal(view);
        }
    }
}

