/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatButton;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.widget.TextView;
import com.helpshift.views.FontApplier;
import com.helpshift.views.HSTypefaceSpan;

public class HSButton
extends AppCompatButton {
    public HSButton(Context context) {
        super(context);
        this.init();
    }

    public HSButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public HSButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        FontApplier.apply((TextView)this);
    }

    public void setError(CharSequence error, Drawable icon) {
        if (error == null) {
            super.setError(error, icon);
            return;
        }
        HSTypefaceSpan tfs = FontApplier.getTypefaceSpan();
        if (tfs == null) {
            super.setError(error, icon);
            return;
        }
        SpannableString sb = new SpannableString(error);
        sb.setSpan((Object)tfs, 0, error.length(), 17);
        super.setError((CharSequence)sb, icon);
    }
}

