/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.views;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.widget.Toast;
import com.helpshift.views.HSToast;

public class HSTooltip {
    private Context context;
    private View targetView;
    private String text;

    public HSTooltip(View targetView, String text) {
        this.targetView = targetView;
        this.context = targetView.getContext();
        this.text = text;
    }

    public void show() {
        int[] screenPos = new int[2];
        Rect displayFrame = new Rect();
        this.targetView.getLocationOnScreen(screenPos);
        this.targetView.getWindowVisibleDisplayFrame(displayFrame);
        int width = this.targetView.getWidth();
        int height = this.targetView.getHeight();
        int midX = screenPos[0] + width / 2;
        int midY = screenPos[1] + height / 2;
        if (ViewCompat.getLayoutDirection((View)this.targetView) == 0) {
            int screenWidth = this.context.getResources().getDisplayMetrics().widthPixels;
            midX = screenWidth - midX;
        }
        Toast toast = HSToast.makeText(this.context, this.text, 0);
        if (midY < displayFrame.height()) {
            toast.setGravity(8388661, midX, midY);
        } else {
            toast.setGravity(81, 0, height);
        }
        toast.show();
    }
}

