/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.widget;

import com.helpshift.widget.Widget;
import java.util.regex.Pattern;

public abstract class TextWidget
extends Widget {
    static final Pattern specialCharactersPattern = Pattern.compile("\\W+");
    static final Pattern emailPattern = Pattern.compile("[a-zA-Z0-9\\+\\._%\\-\\+]{1,256}@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{1,62})+");
    private String text;
    private TextWidgetError error;

    public void setText(String text) {
        if (!this.getText().equals(text)) {
            this.text = text;
            if (this.getError() != null) {
                this.setError(null);
            }
        }
    }

    protected void setError(TextWidgetError error) {
        this.error = error;
        this.notifyChanged();
    }

    public TextWidgetError getError() {
        return this.error;
    }

    public String getText() {
        return this.text == null ? "" : this.text.trim();
    }

    public abstract void validateText();

    public static enum TextWidgetError {
        EMPTY,
        LESS_THAN_MINIMUM_LENGTH,
        ONLY_SPECIAL_CHARACTERS,
        INVALID_EMAIL;

    }
}

