/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.helpshift.Core;
import com.helpshift.HelpshiftUser;
import com.helpshift.applifecycle.HSAppLifeCycleController;
import com.helpshift.common.HelpshiftUtils;
import com.helpshift.exceptions.HelpshiftInitializationException;
import com.helpshift.exceptions.InstallException;
import com.helpshift.exceptions.handlers.UncaughtExceptionHandler;
import com.helpshift.executors.ActionExecutor;
import com.helpshift.logger.LoggerProvider;
import com.helpshift.logger.logmodels.LogExtrasModelFactory;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.static_classes.ErrorReporting;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.SchemaUtil;
import com.helpshift.util.TextUtils;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.ApiExecutorFactory;
import java.util.HashMap;
import java.util.Map;

public class CoreInternal {
    private static final String TAG = "Helpshift_CoreInternal";
    static Core.ApiProvider apiProvider;

    public static void init(Core.ApiProvider apiProvider) {
        CoreInternal.apiProvider = apiProvider;
    }

    protected static void verifyInit() {
        if (apiProvider == null) {
            throw new HelpshiftInitializationException("com.helpshift.Core.init() method not called with valid arguments");
        }
    }

    public static void setNameAndEmail(final String name, final String email) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                apiProvider._setNameAndEmail(name, email);
            }
        });
    }

    public static void install(Application application, String apiKey, String domain, String appId) throws InstallException {
        CoreInternal.install(application, apiKey, domain, appId, new HashMap());
    }

    public static void install(final Application application, String apiKey, final String domain, String appId, final Map config) throws InstallException {
        CoreInternal.verifyInit();
        final String trimApiKey = !TextUtils.isEmpty(apiKey) ? apiKey.trim() : apiKey;
        final String trimDomain = !TextUtils.isEmpty(domain) ? domain.trim() : domain;
        final String trimAppId = !TextUtils.isEmpty(appId) ? appId.trim() : appId;
        SchemaUtil.validateInstallCredentials(trimApiKey, trimDomain, trimAppId);
        HelpshiftContext.installAPICalled.compareAndSet(false, true);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runSync(new Runnable(){

            @Override
            public void run() {
                if (HelpshiftContext.installCallSuccessful.get()) {
                    return;
                }
                apiProvider._preInstall(application, trimApiKey, trimDomain, trimAppId, config);
            }
        });
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                if (HelpshiftContext.installCallSuccessful.get()) {
                    return;
                }
                CoreInternal.initLogging(application.getApplicationContext(), config);
                HSLogger.d(CoreInternal.TAG, "Helpshift install :\n Flavor : " + apiProvider.getClass().getSimpleName() + "\n Domain : " + domain + "\n Config : " + config.toString() + "\n Package Id : " + application.getPackageName() + "\n SDK version : " + "7.5.0" + "\n OS version : " + Build.VERSION.SDK_INT + "\n Device : " + Build.DEVICE);
                apiProvider._install(application, trimApiKey, trimDomain, trimAppId, config);
                HelpshiftContext.installCallSuccessful.compareAndSet(false, true);
            }
        });
    }

    public static void registerDeviceToken(final Context context, final String deviceToken) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Registering push token : " + deviceToken);
                apiProvider._registerDeviceToken(context, deviceToken);
            }
        });
    }

    public static void handlePush(final Context context, final Intent intent) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Handling push on main thread");
                apiProvider._handlePush(context, intent);
            }
        });
    }

    public static void handlePush(final Context context, final Bundle data) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.putExtras(data);
                HSLogger.d(CoreInternal.TAG, "Handling push on main thread");
                apiProvider._handlePush(context, intent);
            }
        });
    }

    public static void handlePush(final Context context, final Map<String, String> data) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                Bundle bundle = new Bundle();
                for (Map.Entry entry : data.entrySet()) {
                    bundle.putString((String)entry.getKey(), (String)entry.getValue());
                }
                intent.putExtras(bundle);
                HSLogger.d(CoreInternal.TAG, "Handling push on main thread");
                apiProvider._handlePush(context, intent);
            }
        });
    }

    public static void login(final HelpshiftUser helpshiftUser) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                if (HelpshiftUtils.isValidHelpshiftUser(helpshiftUser)) {
                    HSLogger.d(CoreInternal.TAG, "Login state changed : name : " + helpshiftUser.getName());
                    apiProvider._login(helpshiftUser);
                } else {
                    HSLogger.d(CoreInternal.TAG, "Login called with invalid helpshift user,So calling Logout");
                    apiProvider._logout();
                }
            }
        });
    }

    public static void logout() {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                apiProvider._logout();
                HSLogger.d(CoreInternal.TAG, "Logged out.");
            }
        });
    }

    public static void clearAnonymousUser() {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                apiProvider._clearAnonymousUser();
                HSLogger.d(CoreInternal.TAG, "resetAnonymousUser API called");
            }
        });
    }

    public static void setSDKLanguage(final String locale) {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Setting SDK language : " + locale);
                apiProvider._setSDKLanguage(locale);
            }
        });
    }

    public static void onAppForeground() {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Application foreground");
                HSAppLifeCycleController.getInstance().onManualAppForegroundAPI();
            }
        });
    }

    public static void onAppBackground() {
        if (!HelpshiftContext.verifyInstall()) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Application background");
                HSAppLifeCycleController.getInstance().onManualAppBackgroundAPI();
            }
        });
    }

    public static ActionExecutor getActionExecutor() {
        return apiProvider._getActionExecutor();
    }

    static void initLogging(Context context, Map config) {
        Object enableLoggingConfig = config.get("enableLogging");
        boolean enableLogging = enableLoggingConfig instanceof Boolean && (Boolean)enableLoggingConfig != false;
        Object disableErrorReportingConfig = config.get("disableErrorLogging");
        if (disableErrorReportingConfig == null) {
            disableErrorReportingConfig = config.get("disableErrorReporting");
        }
        if (disableErrorReportingConfig == null) {
            disableErrorReportingConfig = true;
        }
        boolean disableErrorReporting = disableErrorReportingConfig instanceof Boolean && (Boolean)disableErrorReportingConfig != false;
        float serverTimeDeltaInSeconds = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
        boolean isDebuggable = ApplicationUtil.isApplicationDebuggable(context);
        int loggingLevel = isDebuggable ? 2 : 4;
        HSLogger.initialize(LoggerProvider.getLoggerInstance(context, "__hs_log_store", "7.5.0"), loggingLevel);
        LogExtrasModelProvider.initialize(new LogExtrasModelFactory());
        HSLogger.updateTimeStampDelta(serverTimeDeltaInSeconds);
        HSLogger.enableLogging(enableLogging, !disableErrorReporting);
        ErrorReporting.shouldEnable(!disableErrorReporting);
        if (!disableErrorReporting) {
            UncaughtExceptionHandler.init(context);
        }
        if (HSLogger.getFatalLogsCount() == 0) {
            HSLogger.deleteAll();
        }
    }
}

