/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import com.helpshift.util.HSPattern;

public class HelpshiftUser {
    private String identifier;
    private String email;
    private String name;
    private String authToken;

    private HelpshiftUser(Builder builder) {
        this.identifier = builder.identifier;
        this.email = builder.email;
        this.name = builder.name;
        this.authToken = builder.authToken;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public static final class Builder {
        private String identifier = null;
        private String email = null;
        private String name;
        private String authToken;

        public Builder(String identifier, String email) {
            if (HSPattern.isValidLoginIdentifier(identifier) && HSPattern.isValidLoginEmail(email)) {
                this.identifier = identifier;
                this.email = email;
            }
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public HelpshiftUser build() {
            return new HelpshiftUser(this);
        }
    }
}

