/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;

public class InstallConfig {
    private final boolean enableInAppNotification;
    private final int notificationIcon;
    private final int largeNotificationIcon;
    private final int notificationSound;
    private final boolean enableDefaultFallbackLanguage;
    private final boolean enableInboxPolling;
    private final String fontPath;
    private final boolean enableLogging;
    private final int screenOrientation;
    private final String supportNotificationChannelId;
    private final Map<String, Object> extras;

    InstallConfig(boolean enableInAppNotification, int notificationIcon, int largeNotificationIcon, int notificationSound, boolean enableDefaultFallbackLanguage, boolean enableInboxPolling, String fontPath, boolean enableLogging, int screenOrientation, String supportNotificationChannelId, Map<String, Object> extras) {
        this.enableInAppNotification = enableInAppNotification;
        this.notificationIcon = notificationIcon;
        this.largeNotificationIcon = largeNotificationIcon;
        this.notificationSound = notificationSound;
        this.enableDefaultFallbackLanguage = enableDefaultFallbackLanguage;
        this.enableInboxPolling = enableInboxPolling;
        this.fontPath = fontPath;
        this.screenOrientation = screenOrientation;
        this.extras = extras;
        this.enableLogging = enableLogging;
        this.supportNotificationChannelId = supportNotificationChannelId;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enableInAppNotification", this.enableInAppNotification);
        if (this.notificationIcon != 0) {
            configMap.put("notificationIcon", this.notificationIcon);
        }
        if (this.largeNotificationIcon != 0) {
            configMap.put("largeNotificationIcon", this.largeNotificationIcon);
        }
        if (this.notificationSound != 0) {
            configMap.put("notificationSound", this.notificationSound);
        }
        configMap.put("enableDefaultFallbackLanguage", this.enableDefaultFallbackLanguage);
        configMap.put("enableInboxPolling", this.enableInboxPolling);
        configMap.put("enableLogging", this.enableLogging);
        configMap.put("font", this.fontPath);
        configMap.put("screenOrientation", this.screenOrientation);
        if (this.extras != null) {
            Object disableErrorLogging = this.extras.remove("disableErrorLogging");
            if (disableErrorLogging != null) {
                this.extras.put("disableErrorReporting", disableErrorLogging);
            }
            for (String key : this.extras.keySet()) {
                if (this.extras.get(key) == null) continue;
                configMap.put(key, this.extras.get(key));
            }
        }
        configMap.put("sdkType", "android");
        configMap.put("supportNotificationChannelId", this.supportNotificationChannelId);
        return configMap;
    }

    public static class Builder {
        private boolean enableInAppNotification = true;
        private int notificationIcon;
        private int largeNotificationIcon;
        private int notificationSound;
        private boolean enableInboxPolling = true;
        private boolean enableDefaultFallbackLanguage = true;
        private String fontPath = null;
        private boolean enableLogging = false;
        private int screenOrientation = -1;
        private String supportNotificationChannelId;
        private Map<String, Object> extras;

        public Builder setEnableInAppNotification(boolean enableInAppNotification) {
            this.enableInAppNotification = enableInAppNotification;
            return this;
        }

        public Builder setNotificationIcon(int notificationIconResId) {
            if (notificationIconResId != 0) {
                this.notificationIcon = notificationIconResId;
            }
            return this;
        }

        public Builder setLargeNotificationIcon(int largeNotificationIconResId) {
            if (largeNotificationIconResId != 0) {
                this.largeNotificationIcon = largeNotificationIconResId;
            }
            return this;
        }

        public Builder setNotificationSound(int notificationSoundResId) {
            if (notificationSoundResId != 0) {
                this.notificationSound = notificationSoundResId;
            }
            return this;
        }

        public Builder setEnableDefaultFallbackLanguage(boolean enableDefaultFallbackLanguage) {
            this.enableDefaultFallbackLanguage = enableDefaultFallbackLanguage;
            return this;
        }

        public Builder setEnableInboxPolling(boolean enableInboxPolling) {
            this.enableInboxPolling = enableInboxPolling;
            return this;
        }

        public Builder setFont(@NonNull String fontPath) {
            this.fontPath = fontPath;
            return this;
        }

        public Builder setScreenOrientation(int screenOrientation) {
            this.screenOrientation = screenOrientation;
            return this;
        }

        public Builder setExtras(Map<String, Object> extras) {
            this.extras = extras;
            return this;
        }

        public Builder setEnableLogging(boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        public Builder setSupportNotificationChannelId(String supportNotificationChannelId) {
            this.supportNotificationChannelId = supportNotificationChannelId;
            return this;
        }

        public InstallConfig build() {
            return new InstallConfig(this.enableInAppNotification, this.notificationIcon, this.largeNotificationIcon, this.notificationSound, this.enableDefaultFallbackLanguage, this.enableInboxPolling, this.fontPath, this.enableLogging, this.screenOrientation, this.supportNotificationChannelId, this.extras);
        }
    }
}

