/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import com.helpshift.CoreApi;
import com.helpshift.HelpshiftUser;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserLoginManager;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.analytics.domainmodel.AnalyticsEventDM;
import com.helpshift.cif.CustomIssueFieldDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.common.domain.AttachmentFileManagerDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.configuration.response.RootServerConfig;
import com.helpshift.conversation.ConversationInboxPoller;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationInfoRenderer;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.ConversationalRenderer;
import com.helpshift.conversation.activeconversation.ScreenshotPreviewRenderer;
import com.helpshift.conversation.activeconversation.ViewableConversation;
import com.helpshift.conversation.activeconversation.usersetup.UserSetupRenderer;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.domainmodel.ConversationInboxManagerDM;
import com.helpshift.conversation.usersetup.UserSetupVM;
import com.helpshift.conversation.viewmodel.ConversationInfoVM;
import com.helpshift.conversation.viewmodel.ConversationVM;
import com.helpshift.conversation.viewmodel.ConversationalVM;
import com.helpshift.conversation.viewmodel.NewConversationRenderer;
import com.helpshift.conversation.viewmodel.NewConversationVM;
import com.helpshift.conversation.viewmodel.ScreenshotPreviewVM;
import com.helpshift.crypto.CryptoDM;
import com.helpshift.delegate.RootDelegate;
import com.helpshift.delegate.UIThreadDelegateDecorator;
import com.helpshift.faq.FaqsDM;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import com.helpshift.logger.ErrorReportsDM;
import com.helpshift.meta.MetaDataDM;
import com.helpshift.redaction.RedactionAgent;
import com.helpshift.util.ValuePair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JavaCore
implements CoreApi {
    private static final String TAG = "Helpshift_JavaCore";
    final SDKConfigurationDM sdkConfigurationDM;
    final AnalyticsEventDM analyticsEventDM;
    final Platform platform;
    private final Threader serialThreader;
    private final Threader parallelThreader;
    private final MetaDataDM metaDataDM;
    private Domain domain;
    private UserManagerDM userManagerDM;
    private boolean isSDKSessionActive = false;

    public JavaCore(Platform platform) {
        this.platform = platform;
        this.domain = new Domain(platform);
        this.userManagerDM = this.domain.getUserManagerDM();
        this.serialThreader = this.domain.getSerialThreader();
        this.parallelThreader = this.domain.getParallelThreader();
        this.sdkConfigurationDM = this.domain.getSDKConfigurationDM();
        this.analyticsEventDM = this.domain.getAnalyticsEventDM();
        this.metaDataDM = this.domain.getMetaDataDM();
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public NewConversationVM getNewConversationViewModel(NewConversationRenderer renderer) {
        return new NewConversationVM(this.platform, this.domain, this.getConversationInboxDM(), renderer);
    }

    @Override
    public ConversationVM getConversationViewModel(Long conversationLocalId, ConversationRenderer renderer, boolean retainMessageBoxOnUI) {
        ViewableConversation viewableConversation = this.getConversationInboxDM().getConversationDM(false, conversationLocalId);
        return new ConversationVM(this.platform, this.domain, this.getConversationInboxDM(), viewableConversation, renderer, retainMessageBoxOnUI);
    }

    @Override
    public ConversationalVM getConversationalViewModel(boolean showConversationHistory, Long conversationLocalId, ConversationalRenderer renderer, boolean retainMessageBoxOnUI) {
        ViewableConversation viewableConversation = this.getConversationInboxDM().getConversationDM(showConversationHistory, conversationLocalId);
        return new ConversationalVM(this.platform, this.domain, this.getConversationInboxDM(), viewableConversation, renderer, showConversationHistory, retainMessageBoxOnUI);
    }

    @Override
    public ConversationInfoVM getConversationInfoViewModel(ConversationInfoRenderer renderer) {
        return new ConversationInfoVM(this.domain, renderer);
    }

    @Override
    public ScreenshotPreviewVM getScreenshotPreviewModel(ScreenshotPreviewRenderer renderer) {
        return new ScreenshotPreviewVM(this.domain, renderer);
    }

    @Override
    public ConversationDM getActiveConversation() {
        return this.getConversationInboxDM().getActiveConversationFromStorage();
    }

    @Override
    public ConversationDM getActiveConversationOrPreIssue() {
        return this.getConversationInboxDM().getActiveConversationOrPreIssue();
    }

    @Override
    public UserSetupVM getUserSetupVM(UserSetupRenderer renderer) {
        return new UserSetupVM(this.platform, this.domain, this.getUserManagerDM().getActiveUserSetupDM(), renderer);
    }

    @Override
    public boolean isActiveConversationActionable() {
        return this.getConversationInboxDM().isActiveConversationActionable();
    }

    @Override
    public boolean isSDKSessionActive() {
        return this.isSDKSessionActive;
    }

    @Override
    public void setDelegateListener(final RootDelegate rootDelegate) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.domain.setDelegate(rootDelegate);
            }
        });
    }

    @Override
    public synchronized boolean clearAnonymousUser() {
        return new UserLoginManager(this, this.domain, this.platform).clearAnonymousUser();
    }

    @Override
    public synchronized boolean login(HelpshiftUser helpshiftUser) {
        return new UserLoginManager(this, this.domain, this.platform).login(helpshiftUser);
    }

    @Override
    public void setNameAndEmail(final String name, final String email) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getConversationInboxDM().saveName(name);
                JavaCore.this.getConversationInboxDM().saveEmail(email);
            }
        });
    }

    @Override
    public synchronized boolean logout() {
        return new UserLoginManager(this, this.domain, this.platform).logout();
    }

    @Override
    public void setPushToken(final String pushToken) {
        this.runSerial(new F(){

            @Override
            public void f() {
                if (pushToken == null) {
                    return;
                }
                String savedPushToken = JavaCore.this.platform.getDevice().getPushToken();
                if (pushToken.equals(savedPushToken)) {
                    return;
                }
                JavaCore.this.platform.getDevice().setPushToken(pushToken);
                JavaCore.this.getUserManagerDM().resetPushTokenSyncStatusForUsers();
                JavaCore.this.getUserManagerDM().sendPushToken();
            }
        });
    }

    @Override
    public void onSDKSessionStarted() {
        this.isSDKSessionActive = true;
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getDelegate().sessionBegan();
            }
        });
    }

    @Override
    public void onSDKSessionEnded() {
        this.isSDKSessionActive = false;
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getDelegate().sessionEnded();
            }
        });
    }

    @Override
    public void fetchServerConfig() {
        this.runParallel(new F(){

            @Override
            public void f() {
                UserDM userDM = JavaCore.this.userManagerDM.getActiveUser();
                RootServerConfig serverConfig = JavaCore.this.sdkConfigurationDM.fetchServerConfig(JavaCore.this.userManagerDM);
                if (serverConfig != null) {
                    RedactionAgent redactionAgent = new RedactionAgent(JavaCore.this.platform, JavaCore.this.domain);
                    redactionAgent.checkAndUpdateRedactionState(userDM, serverConfig.profileCreatedAt, serverConfig.lastRedactionAt);
                }
            }
        });
    }

    @Override
    public void refreshPoller() {
        this.getConversationInboxPoller().refreshPoller(false);
    }

    @Override
    public void setInstallCredentials(final String apiKey, final String domainName, final String platformId) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.sdkConfigurationDM.setInstallCredentials(apiKey, domainName, platformId);
            }
        });
    }

    @Override
    public void updateInstallConfig(final Map<String, Object> installConfig) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.sdkConfigurationDM.updateInstallConfig(installConfig);
            }
        });
    }

    @Override
    public void updateApiConfig(final Map<String, Object> apiConfig) {
        final JavaCore coreApi = this;
        this.runSerial(new F(){

            @Override
            public void f() {
                boolean enableFullPrivacy;
                JavaCore.this.sdkConfigurationDM.updateApiConfig(apiConfig);
                if (apiConfig.containsKey("enableFullPrivacy") && (enableFullPrivacy = ((Boolean)apiConfig.get("enableFullPrivacy")).booleanValue())) {
                    new UserLoginManager(coreApi, JavaCore.this.domain, JavaCore.this.platform).clearPersonallyIdentifiableInformation();
                }
            }
        });
    }

    @Override
    public void sendAnalyticsEvent() {
        this.runParallel(new F(){

            @Override
            public void f() {
                if (JavaCore.this.analyticsEventDM != null) {
                    JavaCore.this.analyticsEventDM.sendEventsToServer(JavaCore.this.getUserManagerDM().getActiveUser());
                }
            }
        });
    }

    @Override
    public AnalyticsEventDM getAnalyticsEventDM() {
        return this.analyticsEventDM;
    }

    @Override
    public void sendAppStartEvent() {
        this.runParallel(new F(){

            @Override
            public void f() {
                JavaCore.this.analyticsEventDM.sendAppStartEvent(JavaCore.this.getUserManagerDM().getActiveUser());
            }
        });
    }

    @Override
    public UIThreadDelegateDecorator getDelegate() {
        return this.domain.getDelegate();
    }

    @Override
    public void sendFailedApiCalls() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getFaqDM();
                UserManagerDM userManagerDM = JavaCore.this.getUserManagerDM();
                JavaCore.this.getConversationInboxDM();
                userManagerDM.getActiveUserSetupDM();
                JavaCore.this.getAnalyticsEventDM();
                JavaCore.this.domain.getAutoRetryFailedEventDM().sendAllEvents();
            }
        });
    }

    @Override
    public UserManagerDM getUserManagerDM() {
        return this.userManagerDM;
    }

    @Override
    public MetaDataDM getMetaDataDM() {
        return this.metaDataDM;
    }

    @Override
    public CustomIssueFieldDM getCustomIssueFieldDM() {
        return this.domain.getCustomIssueFieldDM();
    }

    @Override
    public SDKConfigurationDM getSDKConfigurationDM() {
        return this.sdkConfigurationDM;
    }

    @Override
    public ConversationInboxPoller getConversationInboxPoller() {
        return this.getConversationInboxDM().getConversationInboxPoller();
    }

    @Override
    public void handlePushNotification(final String issueType, final String conversationServerId, final String appName) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getConversationInboxDM().handlePushNotification(issueType, conversationServerId, appName);
            }
        });
    }

    @Override
    public int getNotificationCountSync() {
        return this.getConversationInboxDM().getNotificationCountSync();
    }

    @Override
    public void getNotificationCountAsync(final FetchDataFromThread<ValuePair<Integer, Boolean>, Object> callback) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ValuePair<Integer, Boolean> value = null;
                try {
                    value = JavaCore.this.getConversationInboxDM().fetchConversationsAndGetNotificationCount();
                }
                finally {
                    if (callback != null) {
                        if (value != null && (Integer)value.first >= 0) {
                            callback.onDataFetched(value);
                        } else {
                            callback.onFailure(value);
                        }
                    }
                }
            }
        });
    }

    @Override
    public ConversationInboxDM getConversationInboxDM() {
        return this.getConversationInboxManagerDM().getActiveConversationInboxDM();
    }

    @Override
    public FaqsDM getFaqDM() {
        return this.domain.getFaqsDM();
    }

    @Override
    public CryptoDM getCryptoDM() {
        return this.domain.getCryptoDM();
    }

    @Override
    public LocaleProviderDM getLocaleProviderDM() {
        return this.domain.getLocaleProviderDM();
    }

    @Override
    public AttachmentFileManagerDM getAttachmentFileManagerDM() {
        return this.domain.getAttachmentFileManagerDM();
    }

    @Override
    public AutoRetryFailedEventDM getAutoRetryFailedEventDM() {
        return this.domain.getAutoRetryFailedEventDM();
    }

    @Override
    public void sendRequestIdsForSuccessfulApiCalls() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                String route = "/clear-idempotent-cache/";
                Network network = new POSTNetwork(route, JavaCore.this.domain, JavaCore.this.platform);
                network = new TSCorrectedNetwork(network, JavaCore.this.platform);
                Set<String> requestIds = JavaCore.this.platform.getNetworkRequestDAO().getAllSuccessfulRequestIds();
                if (!requestIds.isEmpty()) {
                    String requestIdsString = JavaCore.this.platform.getJsonifier().jsonify(requestIds);
                    HashMap<String, String> body = new HashMap<String, String>();
                    body.put("request_ids", requestIdsString);
                    network.makeRequest(new RequestData(body));
                    JavaCore.this.platform.getNetworkRequestDAO().clearSuccessfulRequestIds();
                }
            }
        });
    }

    @Override
    public void resetPreIssueConversations() {
        this.domain.getConversationInboxManagerDM().resetPreIssueConversations();
    }

    ConversationInboxManagerDM getConversationInboxManagerDM() {
        return this.domain.getConversationInboxManagerDM();
    }

    @Override
    public ErrorReportsDM getErrorReportsDM() {
        return this.domain.getErrorReportsDM();
    }

    private void runSerial(F f) {
        this.serialThreader.thread(f).f();
    }

    private void runParallel(F f) {
        this.parallelThreader.thread(f).f();
    }
}

