/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.delegate.AuthenticationFailureReason;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationFailureDM {
    List<AuthenticationFailureObserver> observerList = new ArrayList<AuthenticationFailureObserver>();
    Domain domain;

    public AuthenticationFailureDM(Domain domain) {
        this.domain = domain;
    }

    public void registerListener(AuthenticationFailureObserver observer) {
        if (observer != null) {
            this.observerList.add(observer);
        }
    }

    public void unregisterListener(AuthenticationFailureObserver observer) {
        if (observer != null) {
            this.observerList.remove(observer);
        }
    }

    public void notifyAuthenticationFailure(UserDM userDM, ExceptionType e) {
        if (!userDM.isActiveUser()) {
            return;
        }
        AuthenticationFailureReason reason = null;
        if (e == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
            reason = AuthenticationFailureReason.AUTH_TOKEN_NOT_PROVIDED;
        } else if (e == NetworkException.INVALID_AUTH_TOKEN) {
            reason = AuthenticationFailureReason.INVALID_AUTH_TOKEN;
        }
        if (reason == null) {
            return;
        }
        this.notifyObservers();
        this.domain.getDelegate().authenticationFailed(userDM, reason);
    }

    private void notifyObservers() {
        for (AuthenticationFailureObserver observer : this.observerList) {
            if (observer == null) continue;
            observer.onAuthenticationFailure();
        }
    }

    public static interface AuthenticationFailureObserver {
        public void onAuthenticationFailure();
    }
}

