/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.dao;

import com.helpshift.account.dao.UserDB;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.migration.LegacyAnalyticsEventIDDAO;
import java.util.ArrayList;
import java.util.List;

public class AndroidLegacyAnalyticsEventIDDAO
implements LegacyAnalyticsEventIDDAO {
    private UserDB userDB;

    public AndroidLegacyAnalyticsEventIDDAO(UserDB userDB) {
        this.userDB = userDB;
    }

    @Override
    public String getLegacyAnalyticsEventId(String identifier) {
        if (StringUtils.isEmpty(identifier)) {
            return null;
        }
        return this.userDB.fetchLegacyAnalyticsEventId(identifier);
    }

    @Override
    public void storeLegacyAnalyticsEventIDs(List<KeyValuePair> legacyAnalyticEventIDs) {
        if (ListUtils.isEmpty(legacyAnalyticEventIDs)) {
            return;
        }
        ArrayList<KeyValuePair> insertValues = new ArrayList<KeyValuePair>();
        for (KeyValuePair keyValuePair : legacyAnalyticEventIDs) {
            if (keyValuePair == null || StringUtils.isEmpty(keyValuePair.key) || StringUtils.isEmpty(keyValuePair.value)) continue;
            insertValues.add(keyValuePair);
        }
        this.userDB.storeLegacyAnalyticsEventIds(insertValues);
    }
}

