/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.dao;

import com.helpshift.account.dao.UserDB;
import com.helpshift.common.ListUtils;
import com.helpshift.migration.LegacyProfileMigrationDAO;
import com.helpshift.migration.MigrationState;
import com.helpshift.migration.legacyUser.LegacyProfile;
import java.util.List;

public class AndroidLegacyProfileMigrationDAO
implements LegacyProfileMigrationDAO {
    private final UserDB userDB;

    public AndroidLegacyProfileMigrationDAO(UserDB userDB) {
        this.userDB = userDB;
    }

    @Override
    public void storeLegacyProfiles(List<LegacyProfile> legacyProfiles) {
        if (ListUtils.isEmpty(legacyProfiles)) {
            return;
        }
        this.userDB.storeLegacyProfiles(legacyProfiles);
    }

    @Override
    public void deleteLegacyProfile(String identifier) {
        if (identifier == null) {
            return;
        }
        this.userDB.deleteLegacyProfile(identifier);
    }

    @Override
    public LegacyProfile fetchLegacyProfile(String identifier) {
        if (identifier == null) {
            return null;
        }
        return this.userDB.fetchLegacyProfile(identifier);
    }

    @Override
    public boolean updateMigrationState(String identifier, MigrationState migrationState) {
        if (identifier == null || migrationState == null) {
            return false;
        }
        return this.userDB.updateUserMigrationState(identifier, migrationState);
    }
}

