/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.dao;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.account.dao.ClearedUserSyncState;
import com.helpshift.account.dao.UserDBHelper;
import com.helpshift.account.dao.UserDBInfo;
import com.helpshift.account.domainmodel.ClearedUserDM;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserSyncStatus;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.migration.MigrationState;
import com.helpshift.migration.legacyUser.LegacyProfile;
import com.helpshift.redaction.RedactionDetail;
import com.helpshift.redaction.RedactionState;
import com.helpshift.redaction.RedactionType;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;

public class UserDB {
    private static final String TAG = "Helpshift_UserDB";
    private static UserDB instance;
    private final UserDBInfo userDBInfo = new UserDBInfo();
    private final UserDBHelper userDBHelper;

    private UserDB(Context context) {
        this.userDBHelper = new UserDBHelper(context, this.userDBInfo);
    }

    public static synchronized UserDB getInstance(Context context) {
        if (instance == null) {
            instance = new UserDB(context);
        }
        return instance;
    }

    private SQLiteDatabase getWritableDatabase() {
        return this.userDBHelper.getWritableDatabase();
    }

    private SQLiteDatabase getReadableDatabase() {
        return this.userDBHelper.getReadableDatabase();
    }

    UserDM createUser(UserDM userDM) {
        Long userLocalId = null;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = this.userDMToContentValues(userDM);
            userLocalId = database.insert("user_table", null, values);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in creating user", ex);
        }
        if (userLocalId == null) {
            return null;
        }
        return this.getUserDMWithLocalId(userDM, userLocalId);
    }

    synchronized boolean updateUser(UserDM userDM) {
        if (userDM.getLocalId() == null) {
            return false;
        }
        boolean updateSuccessful = false;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = this.userDMToContentValues(userDM);
            database.update("user_table", values, "_id = ?", new String[]{String.valueOf(userDM.getLocalId())});
            updateSuccessful = true;
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in updating user", ex);
        }
        return updateSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UserDM fetchUser(Long localId) {
        if (localId == null) {
            return null;
        }
        UserDM returnData = null;
        String[] selectionArgs = new String[]{localId.toString()};
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("user_table", null, "_id = ?", selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                returnData = this.cursorToUserDM(cursor);
            }
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UserDM fetchUser(String identifier, String email) {
        if (identifier == null && email == null) {
            return null;
        }
        if (identifier == null) {
            identifier = "";
        }
        if (email == null) {
            email = "";
        }
        UserDM returnData = null;
        Cursor cursor = null;
        String selection = "identifier = ? AND email = ?";
        String[] selectionArgs = new String[]{identifier, email};
        try {
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("user_table", null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                returnData = this.cursorToUserDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in reading user with email and identifier", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UserDM getActiveUser() {
        UserDM returnData = null;
        Cursor cursor = null;
        String selection = "active = ?";
        String[] selectionArgs = new String[]{UserDBInfo.INT_TRUE.toString()};
        try {
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("user_table", null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                returnData = this.cursorToUserDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in reading active user", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized UserDM getAnonymousUser() {
        UserDM returnData = null;
        Cursor cursor = null;
        String selection = "anonymous = ?";
        String[] selectionArgs = new String[]{UserDBInfo.INT_TRUE.toString()};
        try {
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("user_table", null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                returnData = this.cursorToUserDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in reading anonymous user", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<UserDM> fetchUsers() {
        ArrayList<UserDM> returnList = new ArrayList<UserDM>();
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("user_table", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    returnList.add(this.cursorToUserDM(cursor));
                } while (cursor.moveToNext());
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean activateUser(Long localId) {
        if (localId == null) {
            return false;
        }
        boolean activationSuccessful = false;
        SQLiteDatabase database = null;
        try {
            database = this.getWritableDatabase();
            ContentValues activeValueTrue = new ContentValues();
            activeValueTrue.put("active", Boolean.valueOf(true));
            ContentValues activeValueFalse = new ContentValues();
            activeValueFalse.put("active", Boolean.valueOf(false));
            database.beginTransaction();
            int updateCount = database.update("user_table", activeValueTrue, "_id = ?", new String[]{localId.toString()});
            if (updateCount > 0) {
                database.update("user_table", activeValueFalse, "_id != ?", new String[]{localId.toString()});
            }
            database.setTransactionSuccessful();
            activationSuccessful = true;
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in activating user", ex);
        }
        finally {
            try {
                if (database != null) {
                    database.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in activating user in finally block", e);
            }
        }
        return activationSuccessful;
    }

    synchronized boolean deleteUser(Long localId) {
        if (localId == null) {
            return false;
        }
        long itemsDeleted = 0L;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            itemsDeleted = database.delete("user_table", "_id = ?", new String[]{String.valueOf(localId)});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in deleting user", ex);
        }
        return itemsDeleted > 0L;
    }

    private UserDM cursorToUserDM(Cursor cursor) {
        Long localId = cursor.getLong(cursor.getColumnIndex("_id"));
        String identifier = cursor.getString(cursor.getColumnIndex("identifier"));
        String name = cursor.getString(cursor.getColumnIndex("name"));
        String email = cursor.getString(cursor.getColumnIndex("email"));
        String deviceId = cursor.getString(cursor.getColumnIndex("deviceid"));
        String authToken = cursor.getString(cursor.getColumnIndex("auth_token"));
        int isActiveValueValue = cursor.getInt(cursor.getColumnIndex("active"));
        boolean isActive = isActiveValueValue == UserDBInfo.INT_TRUE;
        int isAnonyomousValue = cursor.getInt(cursor.getColumnIndex("anonymous"));
        boolean isAnonoymous = isAnonyomousValue == UserDBInfo.INT_TRUE;
        int issueExistsValue = cursor.getInt(cursor.getColumnIndex("issue_exists"));
        boolean issueExists = issueExistsValue == UserDBInfo.INT_TRUE;
        int isPushTokenSyncedValue = cursor.getInt(cursor.getColumnIndex("push_token_synced"));
        boolean isPushTokenSynced = isPushTokenSyncedValue == UserDBInfo.INT_TRUE;
        UserSyncStatus syncState = this.intToUserSyncStatus(cursor.getInt(cursor.getColumnIndex("initial_state_synced")));
        return new UserDM(localId, identifier, email, name, deviceId, isActive, isAnonoymous, isPushTokenSynced, authToken, issueExists, syncState);
    }

    private ClearedUserDM cursorToClearedUserDM(Cursor cursor) {
        Long localId = cursor.getLong(cursor.getColumnIndex("_id"));
        String identifier = cursor.getString(cursor.getColumnIndex("identifier"));
        String email = cursor.getString(cursor.getColumnIndex("email"));
        String deviceId = cursor.getString(cursor.getColumnIndex("deviceid"));
        String authToken = cursor.getString(cursor.getColumnIndex("auth_token"));
        ClearedUserSyncState syncState = this.intToClearedUserSyncState(cursor.getInt(cursor.getColumnIndex("sync_state")));
        return new ClearedUserDM(localId, identifier, email, authToken, deviceId, syncState);
    }

    private LegacyProfile cursorToLegacyProfile(Cursor cursor) {
        String identifier = cursor.getString(cursor.getColumnIndex("identifier"));
        String email = cursor.getString(cursor.getColumnIndex("email"));
        String name = cursor.getString(cursor.getColumnIndex("name"));
        String serverId = cursor.getString(cursor.getColumnIndex("serverid"));
        MigrationState migrationState = this.intToMigrationState(cursor.getInt(cursor.getColumnIndex("migration_state")));
        return new LegacyProfile(identifier, email, name, serverId, migrationState);
    }

    private ContentValues clearedUserDMtoContentValues(ClearedUserDM clearedUserDM) {
        ContentValues values = new ContentValues();
        values.put("_id", clearedUserDM.localId);
        values.put("identifier", clearedUserDM.identifier);
        values.put("email", clearedUserDM.email);
        values.put("auth_token", clearedUserDM.authToken);
        values.put("deviceid", clearedUserDM.deviceId);
        values.put("sync_state", Integer.valueOf(clearedUserDM.syncState.ordinal()));
        return values;
    }

    private ContentValues userDMToContentValues(UserDM userDM) {
        ContentValues values = new ContentValues();
        if (userDM.getLocalId() != null) {
            values.put("_id", userDM.getLocalId());
        }
        if (userDM.getIdentifier() != null) {
            values.put("identifier", userDM.getIdentifier());
        } else {
            values.put("identifier", "");
        }
        if (userDM.getName() != null) {
            values.put("name", userDM.getName());
        } else {
            values.put("name", "");
        }
        if (userDM.getEmail() != null) {
            values.put("email", userDM.getEmail());
        } else {
            values.put("email", "");
        }
        if (userDM.getDeviceId() != null) {
            values.put("deviceid", userDM.getDeviceId());
        } else {
            values.put("deviceid", "");
        }
        if (userDM.getAuthToken() != null) {
            values.put("auth_token", userDM.getAuthToken());
        } else {
            values.put("auth_token", "");
        }
        values.put("active", Boolean.valueOf(userDM.isActiveUser()));
        values.put("anonymous", Boolean.valueOf(userDM.isAnonymousUser()));
        values.put("issue_exists", Boolean.valueOf(userDM.issueExists()));
        values.put("push_token_synced", Boolean.valueOf(userDM.isPushTokenSynced()));
        values.put("initial_state_synced", Integer.valueOf(userDM.getSyncState().ordinal()));
        return values;
    }

    private ContentValues legacyProfileToContentValues(LegacyProfile profile) {
        ContentValues values = new ContentValues();
        values.put("identifier", profile.identifier);
        values.put("name", profile.name);
        values.put("email", profile.email);
        values.put("serverid", profile.serverId);
        values.put("migration_state", Integer.valueOf(profile.migrationState.ordinal()));
        return values;
    }

    private ContentValues legacyAnalyticsIDPairToContentValues(KeyValuePair keyValuePair) {
        ContentValues values = new ContentValues();
        values.put("identifier", keyValuePair.key);
        values.put("analytics_event_id", keyValuePair.value);
        return values;
    }

    private UserDM getUserDMWithLocalId(UserDM userDM, long localId) {
        return new UserDM(localId, userDM.getIdentifier(), userDM.getEmail(), userDM.getName(), userDM.getDeviceId(), userDM.isActiveUser(), userDM.isAnonymousUser(), userDM.isPushTokenSynced(), userDM.getAuthToken(), userDM.issueExists(), userDM.getSyncState());
    }

    private ClearedUserDM getClearUserDMWithLocalId(ClearedUserDM clearedUserDM, long localId) {
        return new ClearedUserDM(localId, clearedUserDM.identifier, clearedUserDM.email, clearedUserDM.authToken, clearedUserDM.deviceId, clearedUserDM.syncState);
    }

    synchronized ClearedUserDM insertClearedUser(ClearedUserDM clearedUserDM) {
        Long clearUserLocalId = null;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = this.clearedUserDMtoContentValues(clearedUserDM);
            clearUserLocalId = database.insert("cleared_user_table", null, values);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in creating cleared user", ex);
        }
        if (clearUserLocalId == null) {
            return null;
        }
        return this.getClearUserDMWithLocalId(clearedUserDM, clearUserLocalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<ClearedUserDM> fetchClearedUsers() {
        ArrayList<ClearedUserDM> returnList = new ArrayList<ClearedUserDM>();
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("cleared_user_table", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    returnList.add(this.cursorToClearedUserDM(cursor));
                } while (cursor.moveToNext());
            }
        }
        return returnList;
    }

    synchronized boolean updateClearedUserSyncState(Long localId, ClearedUserSyncState syncState) {
        boolean updateSuccessful = false;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("sync_state", Integer.valueOf(syncState.ordinal()));
            database.update("cleared_user_table", values, "_id = ?", new String[]{localId.toString()});
            updateSuccessful = true;
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in updating cleared user sync status", ex);
        }
        return updateSuccessful;
    }

    synchronized boolean deleteClearedUser(Long localId) {
        long itemsDeleted = 0L;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            itemsDeleted = database.delete("user_table", "_id = ?", new String[]{String.valueOf(localId)});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in deleting cleared user", ex);
        }
        return itemsDeleted > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeLegacyProfiles(List<LegacyProfile> legacyProfiles) {
        SQLiteDatabase database = null;
        try {
            database = this.getWritableDatabase();
            database.beginTransaction();
            for (LegacyProfile profile : legacyProfiles) {
                ContentValues values = this.legacyProfileToContentValues(profile);
                database.insert("legacy_profile_table", null, values);
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in storing legacy profiles", ex);
        }
        finally {
            try {
                if (database != null) {
                    database.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in storing legacy profiles in finally block", e);
            }
        }
    }

    synchronized void deleteLegacyProfile(String identifier) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            database.delete("legacy_profile_table", "identifier = ?", new String[]{identifier});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in deleting legacy profile", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized LegacyProfile fetchLegacyProfile(String identifier) {
        LegacyProfile returnData = null;
        String[] selectionArgs = new String[]{identifier};
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("legacy_profile_table", null, "identifier = ?", selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                returnData = this.cursorToLegacyProfile(cursor);
            }
        }
        return returnData;
    }

    synchronized boolean updateUserMigrationState(String identifier, MigrationState syncState) {
        boolean updateSuccessful = false;
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("migration_state", Integer.valueOf(syncState.ordinal()));
            database.update("legacy_profile_table", values, "identifier = ?", new String[]{identifier});
            updateSuccessful = true;
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in updating user migration sync status", ex);
        }
        return updateSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeLegacyAnalyticsEventIds(List<KeyValuePair> legacyAnalyticEventIDs) {
        SQLiteDatabase database = null;
        try {
            database = this.getWritableDatabase();
            database.beginTransaction();
            for (KeyValuePair keyValuePair : legacyAnalyticEventIDs) {
                ContentValues values = this.legacyAnalyticsIDPairToContentValues(keyValuePair);
                database.insert("legacy_analytics_event_id_table", null, values);
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in storing legacy analytics events", ex);
        }
        finally {
            try {
                if (database != null) {
                    database.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in storing legacy analytics events in finally block", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String fetchLegacyAnalyticsEventId(String identifier) {
        String returnData = null;
        String[] selectionArgs = new String[]{identifier};
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("legacy_analytics_event_id_table", null, "identifier = ?", selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                returnData = cursor.getString(cursor.getColumnIndex("analytics_event_id"));
            }
        }
        return returnData;
    }

    private UserSyncStatus intToUserSyncStatus(int userSyncStatus) {
        if (userSyncStatus < 0 || userSyncStatus > 3) {
            userSyncStatus = 0;
        }
        return UserSyncStatus.values()[userSyncStatus];
    }

    private MigrationState intToMigrationState(int migrationState) {
        if (migrationState < 0 || migrationState > 3) {
            migrationState = 0;
        }
        return MigrationState.values()[migrationState];
    }

    private ClearedUserSyncState intToClearedUserSyncState(int clearedUserSyncState) {
        if (clearedUserSyncState < 0 || clearedUserSyncState > 3) {
            clearedUserSyncState = 0;
        }
        return ClearedUserSyncState.values()[clearedUserSyncState];
    }

    private RedactionState intToRedactionState(int redactionState) {
        RedactionState[] redactionStates = RedactionState.values();
        if (redactionState < 0 || redactionState > redactionStates.length) {
            redactionState = 0;
        }
        return redactionStates[redactionState];
    }

    private RedactionType intToRedactionType(int redactionType) {
        RedactionType[] redactionTypes = RedactionType.values();
        if (redactionType < 0 || redactionType > redactionTypes.length) {
            redactionType = 0;
        }
        return redactionTypes[redactionType];
    }

    private ContentValues redactionDetailToContentValues(RedactionDetail redactionDetail) {
        ContentValues values = new ContentValues();
        values.put("user_local_id", Long.valueOf(redactionDetail.userLocalId));
        values.put("redaction_state", Integer.valueOf(redactionDetail.redactionState.ordinal()));
        values.put("redaction_type", Integer.valueOf(redactionDetail.redactionType.ordinal()));
        return values;
    }

    private RedactionDetail cursorToRedactionDetail(Cursor cursor) {
        long userLocalId = cursor.getLong(cursor.getColumnIndex("user_local_id"));
        RedactionState redactionState = this.intToRedactionState(cursor.getInt(cursor.getColumnIndex("redaction_state")));
        RedactionType redactionType = this.intToRedactionType(cursor.getInt(cursor.getColumnIndex("redaction_type")));
        return new RedactionDetail(userLocalId, redactionState, redactionType);
    }

    synchronized void insertRedactionDetail(RedactionDetail redactionDetail) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues contentValues = this.redactionDetailToContentValues(redactionDetail);
            database.insert("redaction_info_table", null, contentValues);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in inserting redaction info of the user", ex);
        }
    }

    synchronized void updateRedactionDetail(RedactionDetail redactionDetail) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = this.redactionDetailToContentValues(redactionDetail);
            database.update("redaction_info_table", values, "user_local_id = ?", new String[]{String.valueOf(redactionDetail.userLocalId)});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in updating redaction detail", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized RedactionDetail fetchRedactionDetail(long userLocalId) {
        RedactionDetail redactionDetail = null;
        String[] selectionArgs = new String[]{String.valueOf(userLocalId)};
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query("redaction_info_table", null, "user_local_id = ?", selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                redactionDetail = this.cursorToRedactionDetail(cursor);
            }
        }
        return redactionDetail;
    }

    synchronized void updateRedactionState(long userLocalId, RedactionState redactionState) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("redaction_state", Integer.valueOf(redactionState.ordinal()));
            database.update("redaction_info_table", values, "user_local_id = ?", new String[]{String.valueOf(userLocalId)});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in updating redaction status", ex);
        }
    }

    synchronized void deleteRedactionDetail(long userLocalID) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            database.delete("redaction_info_table", "user_local_id = ?", new String[]{String.valueOf(userLocalID)});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in deleting redaction detail", ex);
        }
    }
}

