/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.dao;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.helpshift.account.dao.UserDBInfo;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.util.HSLogger;
import java.util.List;

public class UserDBHelper
extends SQLiteOpenHelper {
    private static final String TAG = "Helpshift_UserDBDB";
    private UserDBInfo dbInfo;

    UserDBHelper(Context context, UserDBInfo userDBInfo) {
        super(context, "__hs_db_helpshift_users", null, UserDBInfo.DATABASE_VERSION.intValue());
        this.dbInfo = userDBInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(SQLiteDatabase db) {
        if (!db.isOpen()) {
            return;
        }
        List<String> queries = this.dbInfo.getQueriesForOnCreate();
        try {
            db.beginTransaction();
            for (String query : queries) {
                db.execSQL(query);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.f(TAG, "Exception while creating userDB, version: " + UserDBInfo.DATABASE_VERSION, ex, new ILogExtrasModel[0]);
        }
        finally {
            try {
                if (db.inTransaction()) {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.f(TAG, "Error in onCreate inside finally block, ", e, new ILogExtrasModel[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (!db.isOpen()) {
            return;
        }
        List<String> queries = this.dbInfo.getQueriesForOnUpgrade(oldVersion);
        try {
            db.beginTransaction();
            for (String query : queries) {
                db.execSQL(query);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.f(TAG, "Exception while migrating userDB, version: " + UserDBInfo.DATABASE_VERSION, ex, new ILogExtrasModel[0]);
        }
        finally {
            try {
                if (db.inTransaction()) {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.f(TAG, "Exception while migrating userDB inside finally block, ", e, new ILogExtrasModel[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (!db.isOpen()) {
            return;
        }
        List<String> queries = this.dbInfo.getQueriesForDropAndCreate();
        try {
            db.beginTransaction();
            for (String query : queries) {
                db.execSQL(query);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.f(TAG, "Exception while downgrading userDB, version: " + newVersion, ex, new ILogExtrasModel[0]);
        }
        finally {
            try {
                if (db.inTransaction()) {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.f(TAG, "Exception while downgrading userDB inside finally block, ", e, new ILogExtrasModel[0]);
            }
        }
    }
}

