/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.dao.legacy;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.migration.legacyUser.LegacyProfileDAO;
import java.util.ArrayList;
import java.util.List;

public class AndroidLegacyProfileDAO
extends SQLiteOpenHelper
implements LegacyProfileDAO {
    private static final String TABLE_PROFILES = "profiles";
    private static final String TAG = "Helpshift_ALProfileDAO";
    private static final String COLUMN_ID = "_id";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_PROFILE_ID = "profile_id";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_EMAIL = "email";
    private static final String COLUMN_SALT = "salt";
    private static final String COLUMN_UID = "uid";
    private static final String COLUMN_DID = "did";
    private static final String COLUMN_PUSH_TOKEN_SYNC_STATUS = "push_token_sync";
    private static final String DATABASE_NAME = "__hs__db_profiles";
    private static final int DATABASE_VERSION = 3;
    private static final String DATABASE_CREATE = "CREATE TABLE profiles(_id INTEGER PRIMARY KEY AUTOINCREMENT, IDENTIFIER TEXT NOT NULL UNIQUE, profile_id TEXT UNIQUE, name TEXT, email TEXT, salt TEXT, uid TEXT, did TEXT, push_token_sync INTEGER );";
    private static final String ALTER_PROFILES_TABLE_ADD_USER_ID = "ALTER TABLE profiles ADD uid TEXT";
    private static final String ALTER_PROFILES_TABLE_ADD_DEVICE_ID = "ALTER TABLE profiles ADD did TEXT";
    private static final String ALTER_PROFILES_TABLE_ADD_PUSH_TOKEN_SYNC_STATUS = "ALTER TABLE profiles ADD push_token_sync INTEGER";
    private static AndroidLegacyProfileDAO instance;

    private AndroidLegacyProfileDAO(Context context) {
        super(context, DATABASE_NAME, null, 3);
    }

    public static synchronized AndroidLegacyProfileDAO getInstance(Context context) {
        if (instance == null) {
            instance = new AndroidLegacyProfileDAO(context);
        }
        return instance;
    }

    private static int getColumnIndexForIdentifier(Cursor cursor) {
        int result = cursor.getColumnIndex(COLUMN_IDENTIFIER);
        if (result == -1) {
            result = cursor.getColumnIndex(COLUMN_IDENTIFIER.toLowerCase());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProfileDTO> fetchProfiles() {
        ArrayList<ProfileDTO> profileDTOS = null;
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.getReadableDatabase();
            cursor = database.query(TABLE_PROFILES, null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                profileDTOS = new ArrayList<ProfileDTO>();
                do {
                    profileDTOS.add(this.cursorToProfile(cursor));
                } while (cursor.moveToNext());
            }
        }
        return profileDTOS;
    }

    @Override
    public void deleteProfiles() {
        SQLiteDatabase database = this.getWritableDatabase();
        if (database != null) {
            database.execSQL("DROP TABLE IF EXISTS profiles");
        }
    }

    public void onCreate(SQLiteDatabase database) {
        database.execSQL(DATABASE_CREATE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db.isOpen()) {
            if (oldVersion < 2) {
                db.execSQL(ALTER_PROFILES_TABLE_ADD_USER_ID);
                db.execSQL(ALTER_PROFILES_TABLE_ADD_DEVICE_ID);
            }
            if (oldVersion < 3) {
                db.execSQL(ALTER_PROFILES_TABLE_ADD_PUSH_TOKEN_SYNC_STATUS);
            }
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db.isOpen()) {
            db.execSQL("DROP TABLE IF EXISTS profiles");
            this.onCreate(db);
        }
    }

    private ProfileDTO cursorToProfile(Cursor cursor) {
        return new ProfileDTO(cursor.getLong(cursor.getColumnIndex(COLUMN_ID)), cursor.getString(AndroidLegacyProfileDAO.getColumnIndexForIdentifier(cursor)), cursor.getString(cursor.getColumnIndex(COLUMN_PROFILE_ID)), cursor.getString(cursor.getColumnIndex(COLUMN_NAME)), cursor.getString(cursor.getColumnIndex(COLUMN_EMAIL)), cursor.getString(cursor.getColumnIndex(COLUMN_SALT)), cursor.getString(cursor.getColumnIndex(COLUMN_UID)), cursor.getString(cursor.getColumnIndex(COLUMN_DID)), cursor.getInt(cursor.getColumnIndex(COLUMN_PUSH_TOKEN_SYNC_STATUS)) == 1);
    }
}

