/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.account.UserDMObserver;
import com.helpshift.account.domainmodel.UserSyncStatus;
import java.util.Observable;

public class UserDM
extends Observable
implements UserDMObserver {
    private Long localId;
    private String identifier;
    private String email;
    private String name;
    private String deviceId;
    private boolean isActiveUser;
    private boolean isAnonymousUser;
    private boolean isPushTokenSynced;
    private String authToken;
    private boolean issueExists;
    private UserSyncStatus syncState;

    public UserDM(Long localId, String identifier, String email, String name, String deviceId, boolean isActiveUser, boolean isAnonymousUser, boolean isPushTokenSynced, String authToken, boolean issueExists, UserSyncStatus syncState) {
        this.localId = localId;
        this.identifier = identifier;
        this.email = email;
        this.name = name;
        this.deviceId = deviceId;
        this.isActiveUser = isActiveUser;
        this.isAnonymousUser = isAnonymousUser;
        this.isPushTokenSynced = isPushTokenSynced;
        this.authToken = authToken;
        this.issueExists = issueExists;
        this.syncState = syncState;
    }

    public Long getLocalId() {
        return this.localId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public boolean isActiveUser() {
        return this.isActiveUser;
    }

    public boolean isAnonymousUser() {
        return this.isAnonymousUser;
    }

    public boolean isPushTokenSynced() {
        return this.isPushTokenSynced;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public boolean issueExists() {
        return this.issueExists;
    }

    public UserSyncStatus getSyncState() {
        return this.syncState;
    }

    @Override
    public void onUserDataChange(UserDM oldUser, UserDM newUser) {
        if (this.equals(oldUser)) {
            this.issueExists = newUser.issueExists();
            this.authToken = newUser.getAuthToken();
            this.name = newUser.getName();
            this.email = newUser.getEmail();
            this.syncState = newUser.getSyncState();
            this.isActiveUser = newUser.isActiveUser();
            this.isPushTokenSynced = newUser.isPushTokenSynced;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public static final class Builder {
        private Long localId;
        private String identifier;
        private String email;
        private String name;
        private String deviceId;
        private boolean isActiveUser;
        private boolean isAnonymousUser;
        private boolean isPushTokenSynced;
        private String authToken;
        private boolean issueExists;
        private UserSyncStatus syncState;

        public Builder(UserDM userDM) {
            this.localId = userDM.localId;
            this.identifier = userDM.identifier;
            this.email = userDM.email;
            this.name = userDM.name;
            this.deviceId = userDM.deviceId;
            this.isActiveUser = userDM.isActiveUser;
            this.isAnonymousUser = userDM.isAnonymousUser;
            this.isPushTokenSynced = userDM.isPushTokenSynced;
            this.authToken = userDM.authToken;
            this.issueExists = userDM.issueExists;
            this.syncState = userDM.syncState;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setIssueExists(boolean issueExists) {
            this.issueExists = issueExists;
            return this;
        }

        public Builder setIsActiveUser(boolean isActiveUser) {
            this.isActiveUser = isActiveUser;
            return this;
        }

        public Builder setAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder setIsPushTokenSynced(boolean isPushTokenSynced) {
            this.isPushTokenSynced = isPushTokenSynced;
            return this;
        }

        public Builder setSyncState(UserSyncStatus syncState) {
            this.syncState = syncState;
            return this;
        }

        public UserDM build() {
            return new UserDM(this.localId, this.identifier, this.email, this.name, this.deviceId, this.isActiveUser, this.isAnonymousUser, this.isPushTokenSynced, this.authToken, this.issueExists, this.syncState);
        }
    }
}

