/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.CoreApi;
import com.helpshift.HelpshiftUser;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.account.domainmodel.UserSetupDM;
import com.helpshift.account.domainmodel.UserSetupState;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.domainmodel.ConversationInboxManagerDM;
import com.helpshift.util.HSLogger;
import java.util.List;

public class UserLoginManager {
    private static final String TAG = "Helpshift_ULoginM";
    private CoreApi coreApi;
    private Domain domain;
    private Platform platform;

    public UserLoginManager(CoreApi coreApi, Domain domain, Platform platform) {
        this.coreApi = coreApi;
        this.domain = domain;
        this.platform = platform;
    }

    public boolean login(HelpshiftUser helpshiftUser) {
        UserManagerDM userManagerDM = this.coreApi.getUserManagerDM();
        boolean loginResult = false;
        boolean isAuthTokenUpdated = true;
        boolean isUserCurrentActive = userManagerDM.isActiveUser(helpshiftUser);
        if (isUserCurrentActive) {
            loginResult = true;
            UserDM activeUser = userManagerDM.getActiveUser();
            String activeUserAuthToken = activeUser.getAuthToken();
            if (activeUserAuthToken == null && helpshiftUser.getAuthToken() == null) {
                isAuthTokenUpdated = false;
            } else if (activeUserAuthToken == null || !activeUserAuthToken.equals(helpshiftUser.getAuthToken())) {
                userManagerDM.updateAuthToken(activeUser, helpshiftUser.getAuthToken());
                isAuthTokenUpdated = true;
            }
            String activeUserName = activeUser.getName();
            if (!(StringUtils.isEmpty(activeUserName) && StringUtils.isEmpty(helpshiftUser.getName()) || !StringUtils.isEmpty(activeUserName) && activeUserName.equals(helpshiftUser.getName()))) {
                userManagerDM.updateUserName(activeUser, helpshiftUser.getName());
            }
        } else {
            if (this.coreApi.isSDKSessionActive()) {
                HSLogger.d(TAG, "Login should be called before starting a Helpshift session");
                return false;
            }
            this.cleanUpActiveUser();
            userManagerDM.login(helpshiftUser);
            List<UserDM> inActiveLoggedInUsers = userManagerDM.getInactiveLoggedInUsers();
            for (UserDM userDM : inActiveLoggedInUsers) {
                this.deleteUser(userDM);
            }
            this.setUpActiveUser();
            loginResult = true;
        }
        if (loginResult) {
            this.clearConfigRouteETag();
            if (isAuthTokenUpdated) {
                this.domain.getAutoRetryFailedEventDM().onUserAuthenticationUpdated();
            }
        }
        return loginResult;
    }

    private void cleanUpActiveUser() {
        ConversationInboxManagerDM conversationInboxManagerDM = this.domain.getConversationInboxManagerDM();
        ConversationInboxDM conversationInboxDM = conversationInboxManagerDM.getActiveConversationInboxDM();
        conversationInboxDM.clearPushNotifications();
        conversationInboxDM.getConversationInboxPoller().stop();
    }

    private void setUpActiveUser() {
        ConversationInboxManagerDM conversationInboxManagerDM = this.domain.getConversationInboxManagerDM();
        ConversationInboxDM conversationInboxDM = conversationInboxManagerDM.getActiveConversationInboxDM();
        conversationInboxDM.showPushNotifications();
        UserSetupDM userSetupDM = this.coreApi.getUserManagerDM().getActiveUserSetupDM();
        if (UserSetupState.COMPLETED == userSetupDM.getState()) {
            conversationInboxDM.getConversationInboxPoller().startAppPoller(false);
        } else {
            userSetupDM.startSetup();
        }
    }

    private boolean deleteUser(UserDM userDM) {
        UserManagerDM userManagerDM = this.coreApi.getUserManagerDM();
        boolean success = userManagerDM.deleteUser(userDM);
        if (success) {
            this.platform.getRedactionDAO().deleteRedactionDetail(userDM.getLocalId());
            this.domain.getConversationInboxManagerDM().deleteConversations(userDM);
        }
        return success;
    }

    public boolean clearAnonymousUser() {
        UserManagerDM userManagerDM = this.coreApi.getUserManagerDM();
        UserDM userDM = this.coreApi.getUserManagerDM().getAnonymousUser();
        if (userDM != null) {
            if (userDM.isActiveUser()) {
                HSLogger.d(TAG, "clearAnonymousUser should be called when a logged-in user is active");
                return false;
            }
            boolean deleted = this.deleteUser(userDM);
            if (deleted) {
                userManagerDM.clearAnonymousUser(userDM);
            }
        }
        return true;
    }

    public boolean logout() {
        if (this.coreApi.isSDKSessionActive()) {
            HSLogger.d(TAG, "Logout should be called before starting a Helpshift session");
            return false;
        }
        UserManagerDM userManagerDM = this.coreApi.getUserManagerDM();
        UserDM userDM = userManagerDM.getActiveUser();
        if (userDM != null && userDM.isAnonymousUser()) {
            return true;
        }
        this.cleanUpActiveUser();
        boolean success = userManagerDM.loginWithAnonymousUser();
        this.setUpActiveUser();
        if (success) {
            this.clearConfigRouteETag();
            this.domain.getAutoRetryFailedEventDM().onUserAuthenticationUpdated();
        }
        return success;
    }

    public void clearPersonallyIdentifiableInformation() {
        if (this.coreApi.isSDKSessionActive()) {
            HSLogger.d(TAG, "clear PII should not be called after starting a Helpshift session");
            return;
        }
        UserManagerDM userManagerDM = this.coreApi.getUserManagerDM();
        UserDM activeUserDM = userManagerDM.getActiveUser();
        if (StringUtils.isEmpty(activeUserDM.getIdentifier())) {
            boolean logoutSucceeded = this.logout();
            if (logoutSucceeded) {
                this.deleteUser(activeUserDM);
                this.platform.getCampaignModuleAPIs().logout();
            }
        } else {
            userManagerDM.resetNameAndEmail(activeUserDM);
            this.coreApi.getConversationInboxDM().saveName(null);
            this.coreApi.getConversationInboxDM().saveEmail(null);
        }
    }

    private void clearConfigRouteETag() {
        this.platform.getNetworkRequestDAO().removeETag(NetworkConstants.SUPPORT_CONFIG_ROUTE);
    }
}

