/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.HelpshiftUser;
import com.helpshift.account.UserDMObserver;
import com.helpshift.account.dao.ClearedUserDAO;
import com.helpshift.account.dao.ClearedUserSyncState;
import com.helpshift.account.dao.UserDAO;
import com.helpshift.account.dao.UserManagerDAO;
import com.helpshift.account.domainmodel.ClearedUserDM;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserSetupDM;
import com.helpshift.account.domainmodel.UserSetupState;
import com.helpshift.account.domainmodel.UserSyncStatus;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.HelpshiftUtils;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.AuthenticationFailureNetwork;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.PUTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.domain.network.UserNotFoundNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.util.HSFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserManagerDM
implements AutoRetriableDM {
    private static final String ANONYMOUS_USER_ID_BACKUP_KEY = "anonymous_user_id_backup_key";
    private UserDAO userDAO;
    private UserManagerDAO userManagerDAO;
    private BackupDAO backupDAO;
    private ClearedUserDAO clearedUserDAO;
    private Device device;
    private UserDM activeUserDM;
    private UserSetupDM activeUserSetupDM;
    private Set<UserDMObserver> userDMObservers;
    private Platform platform;
    private Domain domain;

    public UserManagerDM(Platform platform, Domain domain) {
        this.platform = platform;
        this.domain = domain;
    }

    public void init() {
        this.device = this.platform.getDevice();
        this.userDAO = this.platform.getUserDAO();
        this.userManagerDAO = this.platform.getUserManagerDAO();
        this.backupDAO = this.platform.getBackupDAO();
        this.clearedUserDAO = this.platform.getClearedUserDAO();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.PUSH_TOKEN, this);
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.CLEAR_USER, this);
        this.updateAnonymousIDInBackupDAO();
    }

    public UserDM getActiveUser() {
        if (this.activeUserDM != null) {
            return this.activeUserDM;
        }
        this.activeUserDM = this.userDAO.getActiveUser();
        if (this.activeUserDM == null) {
            this.loginWithAnonymousUser();
        } else {
            this.addUserDMObserver(this.activeUserDM);
            this.activeUserSetupDM = null;
        }
        return this.activeUserDM;
    }

    public synchronized void login(HelpshiftUser helpshiftUser) {
        UserDM userDM = this.userDAO.fetchUser(helpshiftUser.getIdentifier(), helpshiftUser.getEmail());
        if (userDM == null) {
            userDM = this.userDAO.createUser(this.buildUser(helpshiftUser));
        }
        if (userDM != null) {
            this.addUserDMObserver(userDM);
            this.activateUser(userDM);
        }
    }

    public synchronized boolean loginWithAnonymousUser() {
        UserDM anonymousUser = this.getAnonymousUser();
        if (anonymousUser == null) {
            anonymousUser = this.createAnonymousUser();
        }
        this.activateUser(anonymousUser);
        return true;
    }

    public synchronized UserDM createAnonymousUser() {
        String anonymousUserId = this.generateAnonymousUserId();
        UserDM anonymousUser = new UserDM(null, anonymousUserId, null, null, this.device.getDeviceId(), false, true, false, null, true, UserSyncStatus.NOT_STARTED);
        anonymousUser = this.userDAO.createUser(anonymousUser);
        return anonymousUser;
    }

    private synchronized void activateUser(UserDM userDM) {
        if (userDM == null) {
            return;
        }
        if (this.activeUserDM != null && this.activeUserDM.getLocalId().equals(userDM.getLocalId())) {
            return;
        }
        if (this.userDAO.activateUser(userDM.getLocalId())) {
            if (this.activeUserDM != null) {
                UserDM previousActiveUser = new UserDM.Builder(this.activeUserDM).setIsActiveUser(false).build();
                this.notifyUserDMObservers(this.activeUserDM, previousActiveUser);
            }
            this.activeUserDM = new UserDM.Builder(userDM).setIsActiveUser(true).build();
            this.activeUserSetupDM = null;
            this.addUserDMObserver(this.activeUserDM);
        }
    }

    private synchronized UserDM buildUser(HelpshiftUser user) {
        return new UserDM(null, user.getIdentifier(), user.getEmail(), user.getName(), this.device.getDeviceId(), false, false, false, user.getAuthToken(), true, UserSyncStatus.NOT_STARTED);
    }

    private synchronized String generateAnonymousUserId() {
        String anonymousUserId = null;
        Serializable anonymousUserData = this.backupDAO.getValue(ANONYMOUS_USER_ID_BACKUP_KEY);
        if (anonymousUserData instanceof String) {
            anonymousUserId = (String)((Object)anonymousUserData);
        }
        if (StringUtils.isEmpty(anonymousUserId)) {
            long currentTimestamp = System.currentTimeMillis();
            anonymousUserId = "hsft_anon_" + HSFormat.timeStampAnonymousUserFormat.format(new Date(currentTimestamp)) + "-" + StringUtils.generateRandomString("abcdefghijklmnopqrstuvwxyz0123456789".toCharArray(), 15);
            this.backupDAO.storeValue(ANONYMOUS_USER_ID_BACKUP_KEY, (Serializable)((Object)anonymousUserId));
        }
        return anonymousUserId;
    }

    private void updateAnonymousIDInBackupDAO() {
        UserDM anonymousUser = this.getAnonymousUser();
        if (anonymousUser != null) {
            this.backupDAO.storeValue(ANONYMOUS_USER_ID_BACKUP_KEY, (Serializable)((Object)anonymousUser.getIdentifier()));
        }
    }

    public UserDM getAnonymousUser() {
        UserDM userDM = this.activeUserDM != null && this.activeUserDM.isAnonymousUser() ? this.activeUserDM : this.userDAO.getAnonymousUser();
        return userDM;
    }

    public boolean deleteUser(UserDM userDM) {
        if (userDM == null) {
            return false;
        }
        boolean success = this.userDAO.deleteUser(userDM.getLocalId());
        if (success) {
            Long userLocalId;
            if (userDM.isAnonymousUser()) {
                this.backupDAO.removeKey(ANONYMOUS_USER_ID_BACKUP_KEY);
            }
            if (this.activeUserDM != null && (userLocalId = this.activeUserDM.getLocalId()) != null && userLocalId.equals(userDM.getLocalId())) {
                if (this.userDMObservers != null) {
                    this.userDMObservers.remove(this.activeUserDM);
                }
                this.activeUserDM = null;
                this.activeUserSetupDM = null;
            }
        }
        return success;
    }

    public void registerUserWithServer(UserDM userDM) {
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(userDM);
        data.put("name", userDM.getName());
        try {
            this.buildCreateProfileNetwork().makeRequest(new RequestData(data));
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(userDM, e.exceptionType);
            }
            throw e;
        }
    }

    public synchronized void resetPushTokenSyncStatusForUsers() {
        List<UserDM> storedUsers = this.userDAO.fetchUsers();
        for (UserDM user : storedUsers) {
            if (this.activeUserDM != null && user.getLocalId().equals(this.activeUserDM.getLocalId())) {
                this.updateIsPushTokenSynced(this.activeUserDM, false);
                continue;
            }
            this.updateIsPushTokenSynced(user, false);
        }
    }

    public synchronized void sendPushTokenSync() {
        try {
            this.sendPushTokenInternal();
        }
        catch (RootAPIException e) {
            this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.PUSH_TOKEN, e.getServerStatusCode());
            throw e;
        }
    }

    public synchronized void sendPushToken() {
        if (this.getActiveUserSetupDM().getState() != UserSetupState.COMPLETED) {
            return;
        }
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                UserManagerDM.this.sendPushTokenSync();
            }
        });
    }

    public String getUserMetaIdentifier() {
        UserDM userDM = this.getActiveUser();
        if (userDM.isAnonymousUser()) {
            return this.userManagerDAO.getUserMetaIdentifier();
        }
        return userDM.getIdentifier();
    }

    public void setUserMetaIdentifier(String userMetaIdentifier) {
        this.userManagerDAO.setUserMetaIdentifier(userMetaIdentifier);
    }

    public List<UserDM> getAllUsers() {
        return this.userDAO.fetchUsers();
    }

    private void sendPushTokenInternal() {
        block5: {
            String pushToken = this.device.getPushToken();
            UserDM activeUser = this.getActiveUser();
            if (StringUtils.isEmpty(pushToken) || activeUser.isPushTokenSynced() || !activeUser.issueExists() || this.getActiveUserSetupDM().getState() != UserSetupState.COMPLETED) {
                return;
            }
            HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(activeUser);
            data.put("token", pushToken);
            Network request = new POSTNetwork("/update-push-token/", this.domain, this.platform);
            request = new TSCorrectedNetwork(request, this.platform);
            request = new AuthenticationFailureNetwork(request);
            request = new UserNotFoundNetwork(request);
            request = new FailedAPICallNetworkDecorator(request);
            request = new GuardOKNetwork(request);
            try {
                request.makeRequest(new RequestData(data));
                this.updateIsPushTokenSynced(activeUser, true);
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.USER_NOT_FOUND) break block5;
                if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                    this.domain.getAuthenticationFailureDM().notifyAuthenticationFailure(activeUser, e.exceptionType);
                    throw e;
                }
                if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                    this.updateIsPushTokenSynced(activeUser, true);
                }
                throw e;
            }
        }
    }

    private Network buildCreateProfileNetwork() {
        Network network = new POSTNetwork("/profiles/", this.domain, this.platform);
        network = new AuthenticationFailureNetwork(network);
        network = new TSCorrectedNetwork(network, this.platform);
        return new GuardOKNetwork(network);
    }

    public synchronized void updateIssueExists(UserDM userDM, boolean issueExists) {
        if (userDM.issueExists() == issueExists) {
            return;
        }
        UserDM updatedUserDM = new UserDM.Builder(userDM).setIssueExists(issueExists).build();
        if (this.userDAO.updateUser(updatedUserDM)) {
            this.notifyUserDMObservers(userDM, updatedUserDM);
        }
    }

    public synchronized void updateAuthToken(UserDM userDM, String authToken) {
        UserDM updatedUserDM = new UserDM.Builder(userDM).setAuthToken(authToken).build();
        if (this.userDAO.updateUser(updatedUserDM)) {
            this.notifyUserDMObservers(userDM, updatedUserDM);
        }
    }

    public synchronized void updateUserName(UserDM userDM, String name) {
        UserDM updatedUserDM = new UserDM.Builder(userDM).setName(name).build();
        if (this.userDAO.updateUser(updatedUserDM)) {
            this.notifyUserDMObservers(userDM, updatedUserDM);
        }
    }

    public synchronized void updateSyncState(UserDM userDM, UserSyncStatus syncState) {
        if (userDM.getSyncState() == syncState) {
            return;
        }
        UserDM updatedUserDM = new UserDM.Builder(userDM).setSyncState(syncState).build();
        if (this.userDAO.updateUser(updatedUserDM)) {
            this.notifyUserDMObservers(userDM, updatedUserDM);
        }
    }

    public synchronized void resetSyncStateForAllUsers() {
        List<UserDM> users = this.getAllUsers();
        for (UserDM userDM : users) {
            this.resetSyncState(userDM);
        }
        this.destroyUserSetupDM();
    }

    public synchronized void resetSyncState(UserDM userDM) {
        this.updateSyncState(userDM, UserSyncStatus.NOT_STARTED);
    }

    private synchronized void updateIsPushTokenSynced(UserDM userDM, boolean isPushTokenSynced) {
        if (userDM.isPushTokenSynced() == isPushTokenSynced) {
            return;
        }
        UserDM updatedUserDM = new UserDM.Builder(userDM).setIsPushTokenSynced(isPushTokenSynced).build();
        if (this.userDAO.updateUser(updatedUserDM)) {
            this.notifyUserDMObservers(userDM, updatedUserDM);
        }
    }

    private synchronized void addUserDMObserver(UserDMObserver userDMObserver) {
        if (userDMObserver == null) {
            return;
        }
        if (this.userDMObservers == null) {
            this.userDMObservers = new HashSet<UserDMObserver>();
        }
        this.userDMObservers.add(userDMObserver);
    }

    private synchronized void notifyUserDMObservers(UserDM oldUser, UserDM newUser) {
        if (this.userDMObservers == null) {
            return;
        }
        for (UserDMObserver userDMObserver : this.userDMObservers) {
            userDMObserver.onUserDataChange(oldUser, newUser);
        }
    }

    public boolean isActiveUser(HelpshiftUser helpshiftUser) {
        if (!HelpshiftUtils.isValidHelpshiftUser(helpshiftUser)) {
            return false;
        }
        UserDM activeUser = this.activeUserDM;
        if (activeUser == null) {
            activeUser = this.userDAO.getActiveUser();
        }
        if (activeUser == null) {
            return false;
        }
        return helpshiftUser.getIdentifier() == null ? activeUser.getIdentifier() == null && helpshiftUser.getEmail().equals(activeUser.getEmail()) : (helpshiftUser.getEmail() == null ? activeUser.getEmail() == null && helpshiftUser.getIdentifier().equals(activeUser.getIdentifier()) : helpshiftUser.getIdentifier().equals(activeUser.getIdentifier()) && helpshiftUser.getEmail().equals(activeUser.getEmail()));
    }

    public List<UserDM> getInactiveLoggedInUsers() {
        List<UserDM> userDMList = this.userDAO.fetchUsers();
        ArrayList<UserDM> inActiveLoggedInUsers = new ArrayList<UserDM>();
        if (ListUtils.isEmpty(userDMList)) {
            return inActiveLoggedInUsers;
        }
        for (UserDM userDM : userDMList) {
            if (userDM.isAnonymousUser() || userDM.isActiveUser()) continue;
            inActiveLoggedInUsers.add(userDM);
        }
        return inActiveLoggedInUsers;
    }

    @Override
    public void sendFailedApiCalls(AutoRetryFailedEventDM.EventType eventType) {
        switch (eventType) {
            case PUSH_TOKEN: {
                this.sendPushTokenInternal();
                break;
            }
            case CLEAR_USER: {
                List<ClearedUserDM> clearedUserDMS = this.clearedUserDAO.fetchClearedUsers();
                if (ListUtils.isEmpty(clearedUserDMS)) {
                    return;
                }
                for (ClearedUserDM clearedUserDM : clearedUserDMS) {
                    if (clearedUserDM.syncState == ClearedUserSyncState.COMPLETED) {
                        this.clearedUserDAO.deleteClearedUser(clearedUserDM.localId);
                        continue;
                    }
                    this.clearAnonymousUserInternal(clearedUserDM);
                }
                break;
            }
        }
    }

    public synchronized UserSetupDM getActiveUserSetupDM() {
        if (this.activeUserSetupDM == null) {
            UserSetupDM userSetupDM = new UserSetupDM(this.platform, this.domain, this.getActiveUser(), this, this.domain.getConversationInboxManagerDM().getActiveConversationInboxDM());
            userSetupDM.init();
            this.activeUserSetupDM = userSetupDM;
        }
        return this.activeUserSetupDM;
    }

    public synchronized void destroyUserSetupDM() {
        this.activeUserSetupDM = null;
    }

    public void clearAnonymousUser(UserDM userDM) {
        ClearedUserDM clearedUserDM = new ClearedUserDM(null, userDM.getIdentifier(), userDM.getEmail(), userDM.getAuthToken(), userDM.getDeviceId(), ClearedUserSyncState.NOT_STARTED);
        final ClearedUserDM clearUser = this.clearedUserDAO.insertClearedUser(clearedUserDM);
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    UserManagerDM.this.clearAnonymousUserInternal(clearUser);
                }
                catch (RootAPIException e) {
                    UserManagerDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.CLEAR_USER, e.getServerStatusCode());
                    throw e;
                }
            }
        });
    }

    private void clearAnonymousUserInternal(ClearedUserDM clearedUserDM) {
        if (clearedUserDM == null || clearedUserDM.localId == null) {
            return;
        }
        if (clearedUserDM.syncState == ClearedUserSyncState.COMPLETED || clearedUserDM.syncState == ClearedUserSyncState.IN_PROGRESS) {
            return;
        }
        Network network = new PUTNetwork("/clear-profile/", this.domain, this.platform);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new UserNotFoundNetwork(network);
        network = new FailedAPICallNetworkDecorator(network);
        network = new GuardOKNetwork(network);
        HashMap<String, String> data = NetworkDataRequestUtil.getUserRequestData(clearedUserDM);
        this.clearedUserDAO.updateSyncState(clearedUserDM.localId, ClearedUserSyncState.IN_PROGRESS);
        try {
            network.makeRequest(new RequestData(data));
            this.clearedUserDAO.updateSyncState(clearedUserDM.localId, ClearedUserSyncState.COMPLETED);
            this.clearedUserDAO.deleteClearedUser(clearedUserDM.localId);
        }
        catch (RootAPIException e) {
            if (e.exceptionType == NetworkException.USER_NOT_FOUND || e.exceptionType == NetworkException.NON_RETRIABLE) {
                this.clearedUserDAO.updateSyncState(clearedUserDM.localId, ClearedUserSyncState.COMPLETED);
                this.clearedUserDAO.deleteClearedUser(clearedUserDM.localId);
            }
            this.clearedUserDAO.updateSyncState(clearedUserDM.localId, ClearedUserSyncState.FAILED);
            throw e;
        }
    }

    public void resetNameAndEmail(UserDM userDM) {
        UserDM updatedUserDM = new UserDM.Builder(userDM).setEmail(null).setName(null).build();
        if (this.userDAO.updateUser(updatedUserDM)) {
            this.notifyUserDMObservers(userDM, updatedUserDM);
        }
    }
}

