/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.account.domainmodel.IUserSyncExecutor;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.account.domainmodel.UserSetupState;
import com.helpshift.account.domainmodel.UserSyncDM;
import com.helpshift.account.domainmodel.UserSyncStatus;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.ConversationInboxPoller;
import com.helpshift.migration.MigrationState;
import com.helpshift.migration.RemoteDataMigrator;
import com.helpshift.redaction.RedactionManager;
import com.helpshift.redaction.RedactionState;
import java.lang.ref.WeakReference;

public class UserSetupDM
implements UserSyncDM.UserSyncListener,
RemoteDataMigrator.RemoteDataMigratorListener,
RedactionManager.RedactionManagerListener,
AutoRetriableDM {
    Domain domain;
    UserDM userDM;
    private WeakReference<UserSetupListener> userSetupListener;
    private UserSyncDM userSyncDM;
    private RemoteDataMigrator remoteDataMigrator;
    private RedactionManager redactionManager;

    public UserSetupDM(Platform platform, Domain domain, UserDM userDM, UserManagerDM userManagerDM, IUserSyncExecutor userSyncExecutor) {
        this.domain = domain;
        this.userDM = userDM;
        this.userSyncDM = new UserSyncDM(domain, userDM, userManagerDM, userSyncExecutor, this);
        this.remoteDataMigrator = new RemoteDataMigrator(platform, domain, userDM, this);
        this.redactionManager = new RedactionManager(platform, domain, userDM, this);
    }

    public void init() {
        this.redactionManager.setAppropriateInitialState();
        this.remoteDataMigrator.setAppropriateInitialState();
        this.userSyncDM.setAppropriateInitialState();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.MIGRATION, this);
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.SYNC_USER, this);
    }

    public UserSetupState getState() {
        RedactionState redactionState = this.redactionManager.getRedactionState();
        if (redactionState == RedactionState.PENDING) {
            return UserSetupState.NON_STARTED;
        }
        if (redactionState == RedactionState.IN_PROGRESS) {
            return UserSetupState.IN_PROGRESS;
        }
        MigrationState migrationState = this.remoteDataMigrator.getProfileMigrationState();
        if (migrationState == MigrationState.NOT_STARTED) {
            return UserSetupState.NON_STARTED;
        }
        if (migrationState == MigrationState.FAILED) {
            return UserSetupState.FAILED;
        }
        if (migrationState == MigrationState.IN_PROGRESS) {
            return UserSetupState.IN_PROGRESS;
        }
        UserSyncStatus userSyncStatus = this.userSyncDM.getSyncState();
        if (userSyncStatus == UserSyncStatus.NOT_STARTED) {
            return UserSetupState.NON_STARTED;
        }
        if (userSyncStatus == UserSyncStatus.FAILED) {
            return UserSetupState.FAILED;
        }
        if (userSyncStatus == UserSyncStatus.IN_PROGRESS) {
            return UserSetupState.IN_PROGRESS;
        }
        return UserSetupState.COMPLETED;
    }

    public void startSetup() {
        UserSetupState userSetupState = this.getState();
        if (userSetupState == UserSetupState.IN_PROGRESS || userSetupState == UserSetupState.COMPLETED) {
            return;
        }
        RedactionState redactionState = this.redactionManager.getRedactionState();
        this.onRedactionStateChange(redactionState);
        if (redactionState == RedactionState.PENDING) {
            this.redactionManager.executeRedaction();
        }
    }

    @Override
    public void redactionStateChanged(UserDM userDM, RedactionState oldState, RedactionState newState) {
        this.onRedactionStateChange(newState);
    }

    @Override
    public void userSyncStateChanged(UserDM userDM, UserSyncStatus oldState, UserSyncStatus newState) {
        this.onUserSyncStateChange(newState);
    }

    @Override
    public void onMigrationStateChanged(UserDM userDM, MigrationState oldState, MigrationState newState) {
        this.onMigrationStateChange(newState);
    }

    private void onRedactionStateChange(RedactionState redactionState) {
        if (redactionState == RedactionState.COMPLETED) {
            MigrationState migrationState = this.remoteDataMigrator.getProfileMigrationState();
            if (migrationState == MigrationState.COMPLETED || migrationState == MigrationState.IN_PROGRESS) {
                this.onMigrationStateChange(migrationState);
            } else {
                this.remoteDataMigrator.startProfileMigration();
            }
        } else if (redactionState == RedactionState.IN_PROGRESS) {
            this.updateUserSetupStateChange(UserSetupState.IN_PROGRESS);
        } else if (redactionState == RedactionState.PENDING) {
            this.updateUserSetupStateChange(UserSetupState.NON_STARTED);
        }
    }

    private void onMigrationStateChange(MigrationState migrationState) {
        if (migrationState == MigrationState.COMPLETED) {
            UserSyncStatus userSyncStatus = this.userSyncDM.getSyncState();
            if (userSyncStatus == UserSyncStatus.COMPLETED || userSyncStatus == UserSyncStatus.IN_PROGRESS) {
                this.onUserSyncStateChange(userSyncStatus);
            } else {
                this.userSyncDM.syncUser();
            }
        } else if (migrationState == MigrationState.IN_PROGRESS) {
            this.updateUserSetupStateChange(UserSetupState.IN_PROGRESS);
        } else if (migrationState == MigrationState.FAILED) {
            this.updateUserSetupStateChange(UserSetupState.FAILED);
        } else if (migrationState == MigrationState.NOT_STARTED) {
            this.updateUserSetupStateChange(UserSetupState.NON_STARTED);
        }
    }

    private void onUserSyncStateChange(UserSyncStatus userSyncStatus) {
        if (userSyncStatus == UserSyncStatus.COMPLETED) {
            this.updateUserSetupStateChange(UserSetupState.COMPLETED);
        } else if (userSyncStatus == UserSyncStatus.IN_PROGRESS) {
            this.updateUserSetupStateChange(UserSetupState.IN_PROGRESS);
        } else if (userSyncStatus == UserSyncStatus.FAILED) {
            this.updateUserSetupStateChange(UserSetupState.FAILED);
        } else if (userSyncStatus == UserSyncStatus.NOT_STARTED) {
            this.updateUserSetupStateChange(UserSetupState.NON_STARTED);
        }
    }

    private void updateUserSetupStateChange(final UserSetupState newState) {
        UserSetupListener setupListener;
        UserSetupListener userSetupListener = setupListener = this.userSetupListener == null ? null : (UserSetupListener)this.userSetupListener.get();
        if (setupListener != null) {
            this.domain.runSerial(new F(){

                @Override
                public void f() {
                    setupListener.userSetupStateChanged(UserSetupDM.this.userDM, newState);
                }
            });
        }
        if (newState == UserSetupState.COMPLETED) {
            this.domain.runParallel(new F(){

                @Override
                public void f() {
                    try {
                        UserSetupDM.this.domain.getUserManagerDM().sendPushTokenSync();
                    }
                    finally {
                        ConversationInboxPoller conversationInboxPoller = UserSetupDM.this.domain.getConversationInboxManagerDM().getActiveConversationInboxDM().getConversationInboxPoller();
                        UserSetupDM.this.userDM.addObserver(conversationInboxPoller);
                        conversationInboxPoller.refreshPoller(false);
                    }
                }
            });
        }
    }

    public void registerUserSetupListener(UserSetupListener listener) {
        this.userSetupListener = listener == null ? null : new WeakReference<UserSetupListener>(listener);
    }

    @Override
    public void sendFailedApiCalls(AutoRetryFailedEventDM.EventType eventType) {
        RedactionState redactionState = this.redactionManager.getRedactionState();
        if (redactionState != RedactionState.COMPLETED) {
            return;
        }
        switch (eventType) {
            case MIGRATION: {
                this.remoteDataMigrator.retry();
                if (this.remoteDataMigrator.getProfileMigrationState() != MigrationState.COMPLETED) break;
                this.userSyncDM.syncUser();
                break;
            }
            case SYNC_USER: {
                if (this.remoteDataMigrator.getProfileMigrationState() != MigrationState.COMPLETED) break;
                this.userSyncDM.retry();
            }
        }
    }

    public static interface UserSetupListener {
        public void userSetupStateChanged(UserDM var1, UserSetupState var2);
    }
}

