/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.account.domainmodel.IUserSyncExecutor;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.account.domainmodel.UserSyncStatus;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import java.lang.ref.WeakReference;

public class UserSyncDM {
    private Domain domain;
    private UserDM userDM;
    private UserManagerDM userManagerDM;
    private IUserSyncExecutor userSyncExecutor;
    private WeakReference<UserSyncListener> userSyncListener;

    public UserSyncDM(Domain domain, UserDM userDM, UserManagerDM userManagerDM, IUserSyncExecutor userSyncExecutor, UserSyncListener listener) {
        this.domain = domain;
        this.userDM = userDM;
        this.userManagerDM = userManagerDM;
        this.userSyncExecutor = userSyncExecutor;
        this.userSyncListener = new WeakReference<UserSyncListener>(listener);
    }

    public void setAppropriateInitialState() {
        UserSyncStatus userSyncStatus = this.getSyncState();
        if (userSyncStatus == UserSyncStatus.IN_PROGRESS) {
            this.updateUserSyncState(UserSyncStatus.IN_PROGRESS, UserSyncStatus.NOT_STARTED);
        }
    }

    private void updateUserSyncState(final UserSyncStatus oldState, final UserSyncStatus newState) {
        UserSyncListener listener = null;
        if (this.userSyncListener != null) {
            listener = (UserSyncListener)this.userSyncListener.get();
        }
        this.userManagerDM.updateSyncState(this.userDM, newState);
        if (listener != null) {
            final UserSyncListener finalListener = listener;
            this.domain.runSerial(new F(){

                @Override
                public void f() {
                    finalListener.userSyncStateChanged(UserSyncDM.this.userDM, oldState, newState);
                }
            });
        }
    }

    public UserSyncStatus getSyncState() {
        return this.userDM.getSyncState();
    }

    public void syncUser() {
        UserSyncStatus userSyncStatus = this.getSyncState();
        if (userSyncStatus == UserSyncStatus.COMPLETED || userSyncStatus == UserSyncStatus.IN_PROGRESS) {
            return;
        }
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    UserSyncDM.this.syncUserInternal();
                }
                catch (RootAPIException e) {
                    UserSyncDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.SYNC_USER, e.getServerStatusCode());
                    throw e;
                }
            }
        });
    }

    private synchronized void syncUserInternal() {
        UserSyncStatus userSyncStatus = this.getSyncState();
        if (userSyncStatus != UserSyncStatus.NOT_STARTED && userSyncStatus != UserSyncStatus.FAILED) {
            return;
        }
        this.updateUserSyncState(userSyncStatus, UserSyncStatus.IN_PROGRESS);
        try {
            this.userSyncExecutor.executeUserSync();
            this.updateUserSyncState(userSyncStatus, UserSyncStatus.COMPLETED);
        }
        catch (RootAPIException e) {
            if (e.getServerStatusCode() == NetworkErrorCodes.CONTENT_NOT_FOUND.intValue() || e.exceptionType == NetworkException.NON_RETRIABLE) {
                this.updateUserSyncState(userSyncStatus, UserSyncStatus.COMPLETED);
                this.userManagerDM.updateIssueExists(this.userDM, false);
            }
            this.updateUserSyncState(userSyncStatus, UserSyncStatus.FAILED);
            throw e;
        }
    }

    public void retry() {
        this.syncUserInternal();
    }

    public static interface UserSyncListener {
        public void userSyncStateChanged(UserDM var1, UserSyncStatus var2, UserSyncStatus var3);
    }
}

