/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.analytics.domainmodel;

import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.analytics.AnalyticsEventDAO;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.analytics.domainmodel.LegacyAnalyticsEventDM;
import com.helpshift.analytics.dto.AnalyticsEventDTO;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkDataRequestUtil;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class AnalyticsEventDM
implements AutoRetriableDM {
    private static final DecimalFormat tsSecFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private final Domain domain;
    private final Platform platform;
    private final Jsonifier jsonifier;
    private final AnalyticsEventDAO analyticsEventDAO;
    private List<AnalyticsEventDTO> eventModelList;
    private SDKConfigurationDM sdkConfigurationDM;

    public AnalyticsEventDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.jsonifier = platform.getJsonifier();
        this.analyticsEventDAO = platform.getAnalyticsEventDAO();
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.ANALYTICS, this);
    }

    private void addEventToStorage(AnalyticsEventDTO eventModel) {
        if (this.eventModelList == null) {
            this.eventModelList = new ArrayList<AnalyticsEventDTO>();
        }
        this.eventModelList.add(eventModel);
    }

    public synchronized void pushEvent(AnalyticsEventType type, Map<String, Object> data) {
        String timestamp = tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        String uuid = UUID.randomUUID().toString();
        this.addEventToStorage(new AnalyticsEventDTO(uuid, type, data, timestamp));
    }

    public synchronized void pushEvent(AnalyticsEventType analyticsEventType, String id) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", id);
        this.pushEvent(analyticsEventType, data);
    }

    public synchronized void pushEvent(AnalyticsEventType analyticsEventType) {
        this.pushEvent(analyticsEventType, (Map<String, Object>)null);
    }

    public void sendEventsToServer(UserDM userDM) {
        List<AnalyticsEventDTO> analyticsEventDTOs = this.getCurrentSessionEventsCopy();
        this.clearAnalyticsEvent();
        this.sendEvents(analyticsEventDTOs, userDM);
    }

    @Override
    public void sendFailedApiCalls(AutoRetryFailedEventDM.EventType eventType) {
        if (eventType != AutoRetryFailedEventDM.EventType.ANALYTICS) {
            return;
        }
        Map<String, HashMap<String, String>> analyticsMapList = this.analyticsEventDAO.getUnsentAnalytics();
        if (analyticsMapList != null && analyticsMapList.size() > 0) {
            Network network = this.getAnalyticsNetwork();
            for (String key : analyticsMapList.keySet()) {
                try {
                    RequestData requestData = new RequestData((Map<String, String>)analyticsMapList.get(key));
                    network.makeRequest(requestData);
                    this.analyticsEventDAO.removeAnalyticsData(key);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                        this.analyticsEventDAO.removeAnalyticsData(key);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    private void sendEvents(List<AnalyticsEventDTO> analyticsEventDTOList, UserDM userDM) {
        block3: {
            if (!ListUtils.isEmpty(analyticsEventDTOList)) {
                String data = this.jsonifier.jsonifyAnalyticsDTOList(analyticsEventDTOList);
                HashMap<String, String> analyticsMap = this.buildEventRequestMap(data, userDM);
                try {
                    RequestData requestData = new RequestData(analyticsMap);
                    this.getAnalyticsNetwork().makeRequest(requestData);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) break block3;
                    String key = UUID.randomUUID().toString();
                    this.analyticsEventDAO.saveUnsentAnalyticsData(key, analyticsMap);
                    this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.ANALYTICS, e.getServerStatusCode());
                    throw e;
                }
            }
        }
    }

    private Network getAnalyticsNetwork() {
        Network network = new POSTNetwork("/events/", this.domain, this.platform);
        network = new FailedAPICallNetworkDecorator(network);
        return new GuardOKNetwork(network);
    }

    private HashMap<String, String> buildEventRequestMap(String data, UserDM userDM) {
        HashMap<String, String> params = NetworkDataRequestUtil.getUserRequestData(userDM);
        params.put("id", this.getAnalyticsEventId(userDM));
        params.put("e", data);
        Device device = this.platform.getDevice();
        params.put("v", device.getSDKVersion());
        params.put("os", device.getOSVersion());
        params.put("av", device.getAppVersion());
        params.put("dm", device.getDeviceModel());
        params.put("s", this.sdkConfigurationDM.getString("sdkType"));
        String pluginVersion = this.sdkConfigurationDM.getString("pluginVersion");
        String runtimeVersion = this.sdkConfigurationDM.getString("runtimeVersion");
        if (!StringUtils.isEmpty(pluginVersion)) {
            params.put("pv", pluginVersion);
        }
        if (!StringUtils.isEmpty(runtimeVersion)) {
            params.put("rv", runtimeVersion);
        }
        params.put("rs", device.getRom());
        String cc = device.getSimCountryIso();
        if (!StringUtils.isEmpty(cc)) {
            params.put("cc", cc);
        }
        params.put("ln", device.getLanguage());
        String developerSetLanguage = this.domain.getLocaleProviderDM().getSDKLanguage();
        if (!StringUtils.isEmpty(developerSetLanguage)) {
            params.put("dln", developerSetLanguage);
        }
        return params;
    }

    private String getAnalyticsEventId(UserDM userDM) {
        LegacyAnalyticsEventDM legacyAnalyticsEventDM = new LegacyAnalyticsEventDM(this.platform);
        String legacyAnalyticsEventID = legacyAnalyticsEventDM.getLegacyAnalyticsEventId(userDM);
        String resultAnalyticsEventId = StringUtils.isEmpty(legacyAnalyticsEventID) ? userDM.getDeviceId() : legacyAnalyticsEventID;
        return resultAnalyticsEventId;
    }

    public synchronized void clearAnalyticsEvent() {
        if (this.eventModelList != null) {
            this.eventModelList.clear();
        }
    }

    public synchronized List<AnalyticsEventDTO> getCurrentSessionEventsCopy() {
        ArrayList<AnalyticsEventDTO> copy = new ArrayList<AnalyticsEventDTO>();
        if (this.eventModelList != null) {
            copy.addAll(this.eventModelList);
        }
        return copy;
    }

    public void sendAppStartEvent(UserDM userDM) {
        if (!this.sdkConfigurationDM.getBoolean("disableAppLaunchEvent")) {
            String uuid = UUID.randomUUID().toString();
            String timestamp = tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
            AnalyticsEventDTO analyticsEventDTO = new AnalyticsEventDTO(uuid, AnalyticsEventType.APP_START, null, timestamp);
            this.sendEvents(Collections.singletonList(analyticsEventDTO), userDM);
        }
    }
}

