/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.android.commons.downloader;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.helpshift.android.commons.downloader.DownloadConfig;
import com.helpshift.android.commons.downloader.HelpshiftSSLSocketFactory;
import com.helpshift.android.commons.downloader.contracts.DownloaderKeyValueStorage;
import com.helpshift.android.commons.downloader.contracts.NetworkAuthDataFetcher;
import com.helpshift.android.commons.downloader.contracts.OnDownloadFinishListener;
import com.helpshift.android.commons.downloader.contracts.OnProgressChangedListener;
import com.helpshift.android.commons.downloader.storage.DownloadManagerDbStorage;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.util.HSLogger;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadRunnable
implements Runnable {
    private static final String TAG = "Helpshift_DownloadRun";
    private Context context;
    private DownloaderKeyValueStorage storage;
    private String urlString;
    private boolean isSecureAttachment;
    private DownloadConfig downloadConfig;
    private OnDownloadFinishListener onDownloadFinishListener;
    private OnProgressChangedListener onProgressChangedListener;
    private NetworkAuthDataFetcher networkAuthDataFetcher;

    public DownloadRunnable(Context context, DownloaderKeyValueStorage storage, String urlString, boolean isSecureAttachment, DownloadConfig downloadConfig, NetworkAuthDataFetcher networkAuthDataFetcher, OnDownloadFinishListener onDownloadFinishListener, OnProgressChangedListener onProgressChangedListener) {
        this.context = context;
        this.storage = storage;
        this.urlString = urlString;
        this.isSecureAttachment = isSecureAttachment;
        this.downloadConfig = downloadConfig;
        this.onDownloadFinishListener = onDownloadFinishListener;
        this.onProgressChangedListener = onProgressChangedListener;
        this.networkAuthDataFetcher = networkAuthDataFetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block41: {
            HSLogger.d(TAG, "Starting download : " + this.urlString);
            Process.setThreadPriority((int)10);
            try {
                FileOutputStream fos;
                InputStream response;
                HttpURLConnection connection;
                block40: {
                    URI downloadURI;
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (this.isSecureAttachment) {
                        URI secureUrl = new URI(this.urlString);
                        String apiPath = secureUrl.getPath();
                        String query = secureUrl.getQuery();
                        Map<String, String> params = this.getQueryMap(query);
                        params.put("v", "1");
                        params.put("uri", apiPath);
                        params = this.networkAuthDataFetcher.getAuthData(params);
                        ArrayList<String> dataList = new ArrayList<String>();
                        for (Map.Entry<String, String> entry : params.entrySet()) {
                            dataList.add(entry.getKey() + "=" + entry.getValue());
                        }
                        String authParams = this.join("&", dataList);
                        downloadURI = new URI(secureUrl.getScheme(), secureUrl.getAuthority(), secureUrl.getPath(), authParams, null);
                    } else {
                        downloadURI = new URI(this.urlString);
                    }
                    URL downloadURL = new URL(downloadURI.toASCIIString());
                    if ("https".equals(downloadURL.getProtocol())) {
                        connection = (HttpsURLConnection)downloadURL.openConnection();
                        this.fixSSLSocketProtocols((HttpsURLConnection)connection);
                    } else {
                        connection = (HttpURLConnection)downloadURL.openConnection();
                    }
                    connection.setInstanceFollowRedirects(true);
                    DownloadManagerDbStorage downloadManagerDbStorage = new DownloadManagerDbStorage(this.context, this.storage, this.downloadConfig.externalStorageDirectoryPath, this.downloadConfig.isNoMedia);
                    response = null;
                    fos = null;
                    File file = downloadManagerDbStorage.getCachedFile(this.urlString);
                    long alreadyDownloadBytes = file.length();
                    connection.setRequestProperty("Range", "bytes=" + alreadyDownloadBytes + "-");
                    int status = connection.getResponseCode();
                    if (status == 416) {
                        downloadManagerDbStorage.removeCachedFile(this.urlString);
                        this.deleteFile(file);
                        throw new IOException("Requested Range Not Satisfiable, failed with 416 status");
                    }
                    long lastDispatchedProgress = 0L;
                    response = connection.getInputStream();
                    if (!this.downloadConfig.writeToFile) {
                        Set<Map.Entry<String, List<String>>> headers = connection.getHeaderFields().entrySet();
                        for (Map.Entry<String, List<String>> header : headers) {
                            if (header.getKey() == null || !header.getKey().equals("Content-Encoding") || !header.getValue().get(0).equalsIgnoreCase("gzip")) continue;
                            response = new GZIPInputStream(response);
                        }
                        InputStreamReader inputStream = new InputStreamReader(response);
                        StringBuilder responseStr = new StringBuilder();
                        BufferedReader rd = new BufferedReader(inputStream);
                        try {
                            String line;
                            while ((line = rd.readLine()) != null) {
                                responseStr.append(line);
                            }
                        }
                        catch (IOException ex) {
                            HSLogger.d(TAG, "IO Exception while reading response", ex);
                        }
                        try {
                            JSONObject responseObject = new JSONObject(responseStr.toString());
                            this.onDownloadFinishListener.onDownloadFinish(true, this.urlString, responseObject);
                        }
                        catch (JSONException e) {
                            try {
                                JSONArray responseArray = new JSONArray(responseStr.toString());
                                this.onDownloadFinishListener.onDownloadFinish(true, this.urlString, responseArray);
                            }
                            catch (JSONException e1) {
                                this.onDownloadFinishListener.onDownloadFinish(true, this.urlString, responseStr);
                            }
                        }
                    } else {
                        int readResult;
                        int contentSize = connection.getContentLength();
                        fos = new FileOutputStream(file, true);
                        int bufferSize = 8192;
                        byte[] byteBuffer = new byte[bufferSize];
                        while ((readResult = response.read(byteBuffer, 0, bufferSize)) != -1) {
                            if (readResult < 0) {
                                throw new EOFException();
                            }
                            fos.write(byteBuffer, 0, readResult);
                            long downloadedBytes = file.length();
                            long progress = (long)((float)downloadedBytes / (float)((long)contentSize + alreadyDownloadBytes) * 100.0f);
                            if (progress == lastDispatchedProgress) continue;
                            lastDispatchedProgress = progress;
                            if (this.onProgressChangedListener == null) continue;
                            this.onProgressChangedListener.onProgressChanged(this.urlString, (int)progress);
                        }
                        downloadManagerDbStorage.removeCachedFile(this.urlString);
                        String filePath = file.getAbsolutePath();
                        HSLogger.d(TAG, "Download finished : " + this.urlString);
                        this.onDownloadFinishListener.onDownloadFinish(true, this.urlString, filePath);
                        Thread.interrupted();
                    }
                    if (response == null) break block40;
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                        HSLogger.e(TAG, "Exception in closing download response", e, LogExtrasModelProvider.fromString("route", this.urlString));
                    }
                }
                connection.disconnect();
                if (fos != null) {
                    fos.close();
                }
                break block41;
                catch (IOException e) {
                    block42: {
                        try {
                            this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                            HSLogger.e(TAG, "Exception in download", e, LogExtrasModelProvider.fromString("route", this.urlString));
                            if (response == null) break block42;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (IOException e2) {
                                    this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e2);
                                    HSLogger.e(TAG, "Exception in closing download response", e2, LogExtrasModelProvider.fromString("route", this.urlString));
                                }
                            }
                            connection.disconnect();
                            if (fos != null) {
                                fos.close();
                            }
                            throw throwable;
                        }
                        try {
                            response.close();
                        }
                        catch (IOException e3) {
                            this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e3);
                            HSLogger.e(TAG, "Exception in closing download response", e3, LogExtrasModelProvider.fromString("route", this.urlString));
                        }
                    }
                    connection.disconnect();
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (InterruptedException e) {
                this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                HSLogger.e(TAG, "Exception Interrupted", e, LogExtrasModelProvider.fromString("route", this.urlString));
            }
            catch (MalformedURLException e) {
                this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                HSLogger.e(TAG, "MalformedURLException", e, LogExtrasModelProvider.fromString("route", this.urlString));
            }
            catch (IOException e) {
                this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                HSLogger.e(TAG, "Exception IO", e, LogExtrasModelProvider.fromString("route", this.urlString));
            }
            catch (GeneralSecurityException e) {
                this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                HSLogger.e(TAG, "GeneralSecurityException", e, LogExtrasModelProvider.fromString("route", this.urlString));
            }
            catch (Exception e) {
                this.onDownloadFinishListener.onDownloadFinish(false, this.urlString, e);
                HSLogger.e(TAG, "Unknown Exception", e, LogExtrasModelProvider.fromString("route", this.urlString));
            }
        }
    }

    private void fixSSLSocketProtocols(HttpsURLConnection connection) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 19) {
            ArrayList<String> enableProtocols = new ArrayList<String>();
            enableProtocols.add("TLSv1.2");
            ArrayList<String> disableProtocols = new ArrayList<String>();
            disableProtocols.add("SSLv3");
            SSLSocketFactory sslSocketFactory = connection.getSSLSocketFactory();
            connection.setSSLSocketFactory(new HelpshiftSSLSocketFactory(sslSocketFactory, enableProtocols, disableProtocols));
        }
    }

    private Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            String name = keyValue[0];
            String value = keyValue[1];
            map.put(name, value);
        }
        return map;
    }

    private String join(CharSequence delimiter, Iterable tokens) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private void deleteFile(File file) {
        try {
            if (file == null) {
                return;
            }
            file.delete();
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Exception in deleting file ", e);
        }
    }
}

