/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.android.commons.downloader;

import com.helpshift.util.HSLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class HelpshiftSSLSocketFactory
extends SSLSocketFactory {
    private static final String TAG = "hs_ssl_factory";
    private SSLSocketFactory sslSocketFactory;
    private List<String> enableProtocols;
    private List<String> disableProtocols;
    private List<Socket> socketCacheList;

    public HelpshiftSSLSocketFactory(SSLSocketFactory sslSocketFactory, List<String> enableProtocols, List<String> disableProtocols) {
        this.sslSocketFactory = sslSocketFactory;
        this.enableProtocols = enableProtocols;
        this.disableProtocols = disableProtocols;
        this.socketCacheList = new ArrayList<Socket>();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(s, host, port, autoClose);
        return this.updateProtocols(socket);
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslSocketFactory.createSocket();
        return this.updateProtocols(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        return this.updateProtocols(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port, localHost, localPort);
        return this.updateProtocols(socket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        return this.updateProtocols(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
        return this.updateProtocols(socket);
    }

    Socket updateProtocols(Socket socket) {
        this.socketCacheList.add(socket);
        if (socket == null || !(socket instanceof SSLSocket)) {
            return socket;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        String[] enabledProtocolArray = sslSocket.getEnabledProtocols();
        if (enabledProtocolArray == null) {
            return sslSocket;
        }
        ArrayList<String> enabledProtocols = new ArrayList<String>(Arrays.asList(enabledProtocolArray));
        String[] supportedProtocolsArray = sslSocket.getSupportedProtocols();
        List<Object> supportedProtocolsList = new ArrayList();
        if (supportedProtocolsArray != null) {
            supportedProtocolsList = Arrays.asList(supportedProtocolsArray);
        }
        ArrayList<String> protocolsToEnable = new ArrayList<String>();
        if (this.enableProtocols != null && this.enableProtocols.size() > 0) {
            for (String protocol : this.enableProtocols) {
                if (enabledProtocols.contains(protocol) || !supportedProtocolsList.contains(protocol)) continue;
                protocolsToEnable.add(protocol);
            }
        }
        enabledProtocols.addAll(protocolsToEnable);
        if (this.disableProtocols != null && this.disableProtocols.size() > 0) {
            enabledProtocols.removeAll(this.disableProtocols);
        }
        sslSocket.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
        return socket;
    }

    public void closeSockets() {
        try {
            for (Socket socket : this.socketCacheList) {
                if (socket == null) continue;
                socket.close();
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Exception on closing open sockets: " + e);
        }
        finally {
            this.socketCacheList.clear();
        }
    }
}

