/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.android.commons.downloader.storage;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.android.commons.downloader.contracts.DownloadManagerStorage;
import com.helpshift.android.commons.downloader.contracts.DownloaderKeyValueStorage;
import com.helpshift.util.HSLogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class DownloadManagerDbStorage
implements DownloadManagerStorage {
    private static final String TAG = DownloadManagerDbStorage.class.getSimpleName();
    private static final String DOWNLOAD_MANAGER_DB_KEY = "kDownloadManagerCachedFiles";
    private Context context;
    private DownloaderKeyValueStorage storage;
    private String externalStorageDirectoryPath;
    private boolean isNoMedia;

    public DownloadManagerDbStorage(Context context, DownloaderKeyValueStorage storage, String externalStorageDirectoryPath, boolean isNoMedia) {
        this.context = context;
        this.storage = storage;
        this.externalStorageDirectoryPath = externalStorageDirectoryPath;
        this.isNoMedia = isNoMedia;
    }

    @Override
    public File getCachedFile(String url) throws IOException {
        File cacheFile;
        String cachedFilePath;
        HashMap<String, String> allCachedFiles = (HashMap<String, String>)this.storage.get(DOWNLOAD_MANAGER_DB_KEY);
        if (allCachedFiles == null) {
            allCachedFiles = new HashMap<String, String>();
        }
        if (!TextUtils.isEmpty((CharSequence)(cachedFilePath = (String)allCachedFiles.get(url))) && (cacheFile = new File(cachedFilePath)).exists()) {
            return cacheFile;
        }
        cacheFile = this.createCacheFile(url);
        if (cacheFile == null) {
            throw new IOException("Error creating cache file");
        }
        allCachedFiles.put(url, cacheFile.getAbsolutePath());
        this.storage.set(DOWNLOAD_MANAGER_DB_KEY, allCachedFiles);
        return cacheFile;
    }

    @Override
    public void removeCachedFile(String url) {
        HashMap allCachedFiles = (HashMap)this.storage.get(DOWNLOAD_MANAGER_DB_KEY);
        allCachedFiles.remove(url);
        this.storage.set(DOWNLOAD_MANAGER_DB_KEY, allCachedFiles);
    }

    private File createCacheFile(String url) {
        File dir = !TextUtils.isEmpty((CharSequence)this.externalStorageDirectoryPath) && this.isPermissionGranted("android.permission.WRITE_EXTERNAL_STORAGE") ? Environment.getExternalStoragePublicDirectory((String)this.externalStorageDirectoryPath) : this.context.getFilesDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (this.isNoMedia) {
            try {
                String noMediaFileName = ".nomedia";
                File noMediaFile = new File(dir, noMediaFileName);
                if (!noMediaFile.exists()) {
                    noMediaFile.createNewFile();
                }
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)"Exception while creating no media file", (Throwable)e);
            }
        }
        File file = null;
        if (dir.canWrite()) {
            String fileName = "Support_" + System.currentTimeMillis() + url.substring(url.lastIndexOf("/") + 1);
            file = new File(dir, fileName);
        }
        return file;
    }

    private boolean isPermissionGranted(String permissionName) {
        try {
            PackageManager packageManager = this.context.getPackageManager();
            String packageName = this.context.getPackageName();
            return packageManager.checkPermission(permissionName, packageName) == 0;
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error checking for permission : " + permissionName, e);
            return false;
        }
    }
}

