/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.app;

import android.content.Context;
import com.helpshift.app.LifecycleListener;
import com.helpshift.applifecycle.HSAppLifeCycleController;
import com.helpshift.applifecycle.HSAppLifeCycleListener;
import com.helpshift.common.domain.HSThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class CampaignAppLifeCycleListener
implements HSAppLifeCycleListener {
    private LinkedBlockingDeque<LifecycleListener> lifecycleListeners = new LinkedBlockingDeque();
    private ExecutorService cachedExecutorService = Executors.newCachedThreadPool(new HSThreadFactory("m-lcycle"));

    public void addLifecycleListener(final LifecycleListener listener) {
        this.lifecycleListeners.addFirst(listener);
        this.cachedExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                if (HSAppLifeCycleController.getInstance().isAppInForeground()) {
                    listener.onForeground();
                }
            }
        });
    }

    @Override
    public void onAppForeground(Context context) {
        if (this.lifecycleListeners.size() == 0) {
            return;
        }
        this.cachedExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                for (LifecycleListener listener : CampaignAppLifeCycleListener.this.lifecycleListeners) {
                    listener.onForeground();
                }
            }
        });
    }

    @Override
    public void onAppBackground(Context context) {
        if (this.lifecycleListeners.size() == 0) {
            return;
        }
        this.cachedExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                for (LifecycleListener listener : CampaignAppLifeCycleListener.this.lifecycleListeners) {
                    listener.onBackground();
                }
            }
        });
    }
}

