/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.applifecycle;

import android.content.Context;
import android.support.annotation.NonNull;
import com.helpshift.applifecycle.HSAppLifeCycleListener;

public abstract class BaseAppLifeCycleTracker {
    private Context context;
    private HSAppLifeCycleListener lifeCycleListener;

    BaseAppLifeCycleTracker(Context context) {
        this.context = context;
    }

    void registerAppLifeCycleListener(@NonNull HSAppLifeCycleListener lifeCycleListener) {
        this.lifeCycleListener = lifeCycleListener;
    }

    void unregisterAppLifeCycleListener() {
        this.lifeCycleListener = null;
    }

    void notifyAppForeground() {
        if (this.lifeCycleListener == null) {
            return;
        }
        this.lifeCycleListener.onAppForeground(this.context);
    }

    void notifyAppBackground() {
        if (this.lifeCycleListener == null) {
            return;
        }
        this.lifeCycleListener.onAppBackground(this.context);
    }

    public abstract boolean isAppInForeground();

    public abstract void onManualAppForegroundAPI();

    public abstract void onManualAppBackgroundAPI();
}

