/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.applifecycle;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.helpshift.applifecycle.BaseAppLifeCycleTracker;
import com.helpshift.util.HSLogger;

class DefaultAppLifeCycleTracker
extends BaseAppLifeCycleTracker
implements Application.ActivityLifecycleCallbacks {
    private int started;
    private int stopped;
    private boolean isAppForeground;
    private boolean isConfigurationChanged = false;
    private static String TAG = "DALCTracker";

    DefaultAppLifeCycleTracker(Application application) {
        super((Context)application);
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @Override
    public boolean isAppInForeground() {
        return this.started > this.stopped;
    }

    @Override
    public void onManualAppForegroundAPI() {
        HSLogger.e(TAG, "Install API is called with manualLifeCycleTracking config as false, Ignore this event");
    }

    @Override
    public void onManualAppBackgroundAPI() {
        HSLogger.e(TAG, "Install API is called with manualLifeCycleTracking config as false, Ignore this event");
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        ++this.started;
        if (!this.isConfigurationChanged) {
            if (!this.isAppForeground) {
                this.notifyAppForeground();
            }
            this.isAppForeground = true;
        }
        this.isConfigurationChanged = false;
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        ++this.stopped;
        boolean bl = this.isConfigurationChanged = activity != null && activity.isChangingConfigurations();
        if (!this.isConfigurationChanged && this.started == this.stopped) {
            this.isAppForeground = false;
            this.notifyAppBackground();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

