/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.applifecycle;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import com.helpshift.applifecycle.BaseAppLifeCycleTracker;
import com.helpshift.applifecycle.DefaultAppLifeCycleTracker;
import com.helpshift.applifecycle.HSAppLifeCycleListener;
import com.helpshift.applifecycle.ManualAppLifeCycleTracker;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.ApiExecutorFactory;
import java.util.ArrayList;
import java.util.List;

public class HSAppLifeCycleController
implements HSAppLifeCycleListener {
    private List<HSAppLifeCycleListener> appLifeCycleListeners = new ArrayList<HSAppLifeCycleListener>();
    private static final Object lock = new Object();
    private BaseAppLifeCycleTracker lifeCycleTracker;
    private static HSAppLifeCycleController instance;

    private HSAppLifeCycleController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HSAppLifeCycleController getInstance() {
        if (instance != null) return instance;
        Class<HSAppLifeCycleListener> clazz = HSAppLifeCycleListener.class;
        synchronized (HSAppLifeCycleListener.class) {
            if (instance != null) return instance;
            instance = new HSAppLifeCycleController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(Application application, boolean isManualLifeCycleTracking) {
        if (this.lifeCycleTracker != null) {
            return;
        }
        this.lifeCycleTracker = isManualLifeCycleTracking ? new ManualAppLifeCycleTracker((Context)application) : new DefaultAppLifeCycleTracker(application);
        this.lifeCycleTracker.registerAppLifeCycleListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAppLifeCycleListener(@NonNull HSAppLifeCycleListener lifeCycleListener) {
        Object object = lock;
        synchronized (object) {
            this.appLifeCycleListeners.add(lifeCycleListener);
        }
    }

    public void onManualAppForegroundAPI() {
        if (this.lifeCycleTracker == null) {
            return;
        }
        this.lifeCycleTracker.onManualAppForegroundAPI();
    }

    public void onManualAppBackgroundAPI() {
        if (this.lifeCycleTracker == null) {
            return;
        }
        this.lifeCycleTracker.onManualAppBackgroundAPI();
    }

    public boolean isAppInForeground() {
        if (this.lifeCycleTracker == null) {
            return false;
        }
        return this.lifeCycleTracker.isAppInForeground();
    }

    @Override
    public void onAppForeground(final Context context) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    for (HSAppLifeCycleListener appLifeCycleListener : HSAppLifeCycleController.this.appLifeCycleListeners) {
                        appLifeCycleListener.onAppForeground(context);
                    }
                }
            }
        });
    }

    @Override
    public void onAppBackground(final Context context) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    for (HSAppLifeCycleListener appLifeCycleListener : HSAppLifeCycleController.this.appLifeCycleListeners) {
                        appLifeCycleListener.onAppBackground(context);
                    }
                }
            }
        });
    }
}

