/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.applifecycle;

import android.content.Context;
import com.helpshift.applifecycle.BaseAppLifeCycleTracker;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;

class ManualAppLifeCycleTracker
extends BaseAppLifeCycleTracker {
    private static String TAG = "MALCTracker";
    private boolean isAppInForeground = false;

    ManualAppLifeCycleTracker(Context context) {
        super(context);
    }

    @Override
    public boolean isAppInForeground() {
        return this.isAppInForeground;
    }

    @Override
    public void onManualAppForegroundAPI() {
        if (this.isAppInForeground) {
            HSLogger.d(TAG, "Application is already in foreground, so ignore this event");
            return;
        }
        if (HelpshiftContext.installCallSuccessful.get()) {
            this.isAppInForeground = true;
            this.notifyAppForeground();
        } else {
            HSLogger.e(TAG, "onManualAppForegroundAPI is called without calling install API");
        }
    }

    @Override
    public void onManualAppBackgroundAPI() {
        if (!this.isAppInForeground) {
            HSLogger.d(TAG, "Application is already in background, so ignore this event");
            return;
        }
        if (HelpshiftContext.installCallSuccessful.get()) {
            this.isAppInForeground = false;
            this.notifyAppBackground();
        } else {
            HSLogger.e(TAG, "onManualAppBackgroundAPI is called without calling install API");
        }
    }
}

