/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.auth.domainmodel;

import com.helpshift.auth.dto.WebSocketAuthData;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.GETNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.RequestData;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.util.HSLogger;
import java.util.HashMap;

public class WebSocketAuthDM {
    public static final String WEBSOCKET_AUTH_DATA = "websocket_auth_data";
    private static final String TAG = "Helpshift_WebSocketAuthDM";
    private final Object fetchSyncObject = new Object();
    private WebSocketAuthData cachedAuthData;
    private Domain domain;
    private Platform platform;
    private ResponseParser responseParser;
    private KVStore kvStore;

    public WebSocketAuthDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.responseParser = platform.getResponseParser();
        this.kvStore = platform.getKVStore();
    }

    public WebSocketAuthData getAuthToken() {
        Object authDataObject;
        if (this.cachedAuthData == null && (authDataObject = this.kvStore.getSerializable(WEBSOCKET_AUTH_DATA)) instanceof WebSocketAuthData) {
            this.cachedAuthData = (WebSocketAuthData)authDataObject;
        }
        if (this.cachedAuthData == null) {
            this.cachedAuthData = this.fetchNewTokenInternal();
            this.kvStore.setSerializable(WEBSOCKET_AUTH_DATA, this.cachedAuthData);
        }
        return this.cachedAuthData;
    }

    public WebSocketAuthData refreshAuthToken() {
        this.cachedAuthData = this.fetchNewTokenInternal();
        this.kvStore.setSerializable(WEBSOCKET_AUTH_DATA, this.cachedAuthData);
        return this.cachedAuthData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketAuthData fetchNewTokenInternal() {
        WebSocketAuthData returnData = null;
        Object object = this.fetchSyncObject;
        synchronized (object) {
            HSLogger.d(TAG, "Fetching auth token");
            Network network = new GETNetwork("/ws-config/", this.domain, this.platform);
            network = new GuardOKNetwork(network);
            try {
                Response response = network.makeRequest(this.getRequestData());
                returnData = this.responseParser.parseAuthToken(response.responseString);
                HSLogger.d(TAG, "Auth token fetch successful");
            }
            catch (RootAPIException e) {
                HSLogger.e(TAG, "Exception in fetching auth token", e);
            }
        }
        return returnData;
    }

    private RequestData getRequestData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("platform-id", this.platform.getAppId());
        return new RequestData(data);
    }
}

