/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.cif;

import com.helpshift.cif.dao.CustomIssueFieldDAO;
import com.helpshift.cif.dto.CustomIssueFieldDTO;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class CustomIssueFieldDM {
    private static final String TAG = "Helpshift_CIF_DM";
    private Domain domain;
    private CustomIssueFieldDAO customIssueFieldDAO;
    private Jsonifier jsonifier;

    public CustomIssueFieldDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.customIssueFieldDAO = platform.getCustomIssueFieldDAO();
        this.jsonifier = platform.getJsonifier();
    }

    public Object getCustomIssueFieldData() {
        ArrayList<CustomIssueFieldDTO> customIssueFieldDTOs = this.customIssueFieldDAO.getCustomIssueFields();
        if (customIssueFieldDTOs == null || customIssueFieldDTOs.size() == 0) {
            return null;
        }
        Object data = null;
        try {
            data = this.jsonifier.jsonifyCustomIssueFieldDTOList(customIssueFieldDTOs);
        }
        catch (RootAPIException e) {
            HSLogger.e(TAG, "Exception when jsonify data : " + e.getMessage());
        }
        return data;
    }

    public void setCustomIssueFieldData(final Map<String, String[]> data) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                ArrayList customIssueFieldDTOs = CustomIssueFieldDM.this.convertMapToDTOs(data);
                CustomIssueFieldDM.this.customIssueFieldDAO.setCustomIssueFields(customIssueFieldDTOs);
            }
        });
    }

    private ArrayList<CustomIssueFieldDTO> convertMapToDTOs(Map<String, String[]> data) {
        if (data == null) {
            return null;
        }
        ArrayList<CustomIssueFieldDTO> customIssueFieldDTOs = new ArrayList<CustomIssueFieldDTO>();
        int MIN_VALUES_LENGTH = 2;
        for (String key : data.keySet()) {
            String type;
            String[] valueSet;
            if (StringUtils.isEmpty(key) || (valueSet = data.get(key)) == null || valueSet.length < MIN_VALUES_LENGTH || StringUtils.isEmpty(type = valueSet[0])) continue;
            String[] values = Arrays.copyOfRange(valueSet, 1, valueSet.length);
            CustomIssueFieldDTO customIssueFieldDTO = new CustomIssueFieldDTO(key, type, values);
            customIssueFieldDTOs.add(customIssueFieldDTO);
        }
        return customIssueFieldDTOs;
    }
}

