/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common;

import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.poller.HttpBackoff;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class AutoRetryFailedEventDM {
    private final Domain domain;
    private final Platform platform;
    private final HttpBackoff retryBackoff;
    private boolean shouldScheduleAuthenticationEvent = true;
    private AtomicBoolean isBatcherScheduled = new AtomicBoolean(false);
    private Map<EventType, AutoRetriableDM> listeners = new HashMap<EventType, AutoRetriableDM>();
    private Set<EventType> pendingRetryEventTypes = Collections.synchronizedSet(new LinkedHashSet());

    public AutoRetryFailedEventDM(Domain domain, Platform platform, HttpBackoff retryBackoff) {
        this.domain = domain;
        this.platform = platform;
        this.retryBackoff = retryBackoff;
    }

    public void register(EventType eventType, AutoRetriableDM autoRetriableDM) {
        this.listeners.put(eventType, autoRetriableDM);
    }

    public void scheduleRetryTaskForEventType(EventType eventType, int statusCode) {
        this.pendingRetryEventTypes.add(eventType);
        if (this.isAuthenticatedType(eventType)) {
            if (statusCode == NetworkErrorCodes.INVALID_AUTH_TOKEN || statusCode == NetworkErrorCodes.AUTH_TOKEN_NOT_PROVIDED) {
                this.shouldScheduleAuthenticationEvent = false;
            } else {
                this.scheduleSync(statusCode, this.pendingRetryEventTypes);
            }
        } else {
            this.scheduleSync(statusCode, this.pendingRetryEventTypes);
        }
    }

    public void sendAllEvents() {
        this.pendingRetryEventTypes.add(EventType.MIGRATION);
        this.pendingRetryEventTypes.add(EventType.SYNC_USER);
        this.pendingRetryEventTypes.add(EventType.PUSH_TOKEN);
        this.pendingRetryEventTypes.add(EventType.CLEAR_USER);
        this.pendingRetryEventTypes.add(EventType.CONVERSATION);
        this.pendingRetryEventTypes.add(EventType.FAQ);
        this.pendingRetryEventTypes.add(EventType.ANALYTICS);
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                AutoRetryFailedEventDM.this.retryFailedApis(AutoRetryFailedEventDM.this.pendingRetryEventTypes);
            }
        });
    }

    public void sendEvents(final EventType eventType) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                LinkedHashSet<EventType> eventTypes = new LinkedHashSet<EventType>();
                eventTypes.add(eventType);
                AutoRetryFailedEventDM.this.retryFailedApis(eventTypes);
            }
        });
    }

    public void resetBackoff() {
        this.retryBackoff.reset();
    }

    private void scheduleSync(int statusCode, final Set<EventType> eventTypes) {
        if (this.isBatcherScheduled.compareAndSet(false, true)) {
            long nextInterval = this.retryBackoff.nextIntervalMillis(statusCode);
            if (nextInterval != -100L) {
                this.domain.runDelayedInParallel(new F(){

                    @Override
                    public void f() {
                        AutoRetryFailedEventDM.this.retryFailedApis(eventTypes);
                    }
                }, nextInterval);
            } else {
                this.isBatcherScheduled.compareAndSet(true, false);
            }
        }
    }

    void retryFailedApis(Set<EventType> eventTypes) {
        this.isBatcherScheduled.compareAndSet(true, false);
        if (!this.platform.isOnline()) {
            this.scheduleSync(0, eventTypes);
            return;
        }
        LinkedList<EventType> eventTypeList = new LinkedList<EventType>(this.pendingRetryEventTypes);
        try {
            for (EventType eventType : eventTypeList) {
                if (!this.canRetryEventType(eventType)) continue;
                AutoRetriableDM autoRetriableDM = this.listeners.get((Object)eventType);
                if (autoRetriableDM == null) {
                    this.pendingRetryEventTypes.remove((Object)eventType);
                    continue;
                }
                try {
                    autoRetriableDM.sendFailedApiCalls(eventType);
                    this.pendingRetryEventTypes.remove((Object)eventType);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.INVALID_AUTH_TOKEN || e.exceptionType == NetworkException.AUTH_TOKEN_NOT_PROVIDED) {
                        this.shouldScheduleAuthenticationEvent = false;
                        continue;
                    }
                    throw e;
                }
            }
            this.retryBackoff.reset();
        }
        catch (RootAPIException ex) {
            int statusCode = ex.getServerStatusCode();
            this.scheduleSync(statusCode, eventTypes);
        }
    }

    public void onUserAuthenticationUpdated() {
        if (this.shouldScheduleAuthenticationEvent) {
            return;
        }
        this.shouldScheduleAuthenticationEvent = true;
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                AutoRetryFailedEventDM.this.retryFailedApis(AutoRetryFailedEventDM.this.pendingRetryEventTypes);
            }
        });
    }

    private boolean isAuthenticatedType(EventType eventType) {
        boolean isTypeAuthenticated;
        switch (eventType) {
            case PUSH_TOKEN: 
            case CONVERSATION: 
            case SYNC_USER: {
                isTypeAuthenticated = true;
                break;
            }
            default: {
                isTypeAuthenticated = false;
            }
        }
        return isTypeAuthenticated;
    }

    private boolean canRetryEventType(EventType eventType) {
        boolean isTypeAuthenticated = this.isAuthenticatedType(eventType);
        return !isTypeAuthenticated || this.shouldScheduleAuthenticationEvent;
    }

    public static enum EventType {
        MIGRATION,
        SYNC_USER,
        PUSH_TOKEN,
        CLEAR_USER,
        CONVERSATION,
        FAQ,
        ANALYTICS;

    }
}

