/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.conversation;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.conversation.ConversationDBInfo;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminBotControlMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageWithTextInputDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AutoRetriableMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageDM;
import com.helpshift.conversation.activeconversation.message.FAQListMessageWithOptionInputDM;
import com.helpshift.conversation.activeconversation.message.FollowupAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.ImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UserBotControlMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForOptionInput;
import com.helpshift.conversation.activeconversation.message.UserResponseMessageForTextInputDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.activeconversation.message.input.TextInput;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.conversation.dto.dao.ConversationInboxRecord;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.platform.db.ConversationDBHelper;
import com.helpshift.support.Faq;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationDB {
    private static final String TAG = "Helpshift_ConverDB";
    private static ConversationDB instance;
    private final String KEY_CSAT_RATING = "csat_rating";
    private final String KEY_CSAT_STATE = "csat_state";
    private final String KEY_CSAT_FEEDBACK = "csat_feedback";
    private final String KEY_INCREMENT_MESSAGE_COUNT = "increment_message_count";
    private final String KEY_CONVERSATION_ENDED_DELEGATE_SENT = "ended_delegate_sent";
    private final String KEY_IMAGE_ATTACHMENT_DRAFT_ORIGINAL_NAME = "image_draft_orig_name";
    private final String KEY_IMAGE_ATTACHMENT_DRAFT_ORIGINAL_SIZE = "image_draft_orig_size";
    private final String KEY_IMAGE_ATTACHMENT_DRAFT_FILE_PATH = "image_draft_file_path";
    private final String KEY_IMAGE_ATTACHMENT_COMPRESSION_COPYING_DONE = "image_copy_done";
    private final String KEY_REFERRED_MESSAGE_ID = "referredMessageId";
    private final String KEY_FOLLOW_UP_REJECTED_REASON = "rejected_reason";
    private final String KEY_FOLLOW_UP_REJECTED_OPEN_CONVERSATION = "rejected_conv_id";
    private final String KEY_IS_ANSWERED = "is_answered";
    private final String KEY_CONTENT_TYPE = "content_type";
    private final String KEY_FILE_NAME = "file_name";
    private final String KEY_URL = "url";
    private final String KEY_SIZE = "size";
    private final String KEY_THUMBNAIL_URL = "thumbnail_url";
    private final String KEY_THUMBNAIL_FILE_PATH = "thumbnailFilePath";
    private final String KEY_FILE_PATH = "filePath";
    private final String KEY_SEEN_AT_MESSAGE_CURSOR = "seen_cursor";
    private final String KEY_SEEN_SYNC_STATUS = "seen_sync_status";
    private final String KEY_READ_AT = "read_at";
    private final String KEY_INPUT_KEYBOARD = "input_keyboard";
    private final String KEY_INPUT_REQUIRED = "input_required";
    private final String KEY_INPUT_SKIP_LABEL = "input_skip_label";
    private final String KEY_INPUT_PLACEHOLDER = "input_placeholder";
    private final String KEY_INPUT_LABEL = "input_label";
    private final String KEY_INPUT_OPTIONS = "input_options";
    private final String KEY_OPTION_TYPE = "option_type";
    private final String KEY_OPTION_TITLE = "option_title";
    private final String KEY_OPTION_DATA = "option_data";
    private final String KEY_CHATBOT_INFO = "chatbot_info";
    private final String KEY_HAS_NEXT_BOT = "has_next_bot";
    private final String KEY_FAQS = "faqs";
    private final String KEY_FAQ_TITLE = "faq_title";
    private final String KEY_FAQ_PUBLISH_ID = "faq_publish_id";
    private final String KEY_FAQ_LANGUAGE = "faq_language";
    private final String KEY_IS_RESPONSE_SKIPPED = "is_response_skipped";
    private final String KEY_SELECTED_OPTION_DATA = "selected_option_data";
    private final String KEY_REFERRED_MESSAGE_TYPE = "referred_message_type";
    private final String KEY_BOT_ACTION_TYPE = "bot_action_type";
    private final String KEY_BOT_ENDED_REASON = "bot_ended_reason";
    private final String KEY_MESSAGE_SYNC_STATUS = "message_sync_status";
    private final String KEY_SECURE_ATTACHMENT = "is_secure";
    private final String KEY_IS_MESSAGE_EMPTY = "is_message_empty";
    private final String KEY_IS_SUGGESTION_READ_EVENT_SENT = "is_suggestion_read_event_sent";
    private final String KEY_SUGGESTION_READ_FAQ_PUBLISH_ID = "suggestion_read_faq_publish_id";
    private final String KEY_DATE_TIME = "dt";
    private final String KEY_TIMEZONE_ID = "timezone_id";
    private final ConversationDBInfo dbInfo = new ConversationDBInfo();
    private final ConversationDBHelper dbHelper;

    private ConversationDB(Context context) {
        this.dbHelper = new ConversationDBHelper(context, this.dbInfo);
    }

    public static synchronized ConversationDB getInstance(Context context) {
        if (instance == null) {
            instance = new ConversationDB(context);
        }
        return instance;
    }

    private static ContentValues faqToContentValues(Faq faq) {
        ContentValues values = new ContentValues();
        values.put("question_id", faq.getId());
        values.put("publish_id", faq.publish_id);
        values.put("language", faq.language);
        values.put("section_id", faq.section_publish_id);
        values.put("title", faq.title);
        values.put("body", faq.body);
        values.put("helpful", Integer.valueOf(faq.is_helpful));
        values.put("rtl", faq.is_rtl);
        values.put("tags", String.valueOf(new JSONArray(faq.getTags())));
        values.put("c_tags", String.valueOf(new JSONArray(faq.getCategoryTags())));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ConversationDM> readConversationsWithLocalId(long userLocalId) {
        ArrayList<ConversationDM> conversations = new ArrayList<ConversationDM>();
        Cursor cursor = null;
        String selection = this.dbInfo.USER_LOCAL_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(userLocalId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    ConversationDM conversation = this.cursorToReadableConversation(cursor);
                    conversations.add(conversation);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with localId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationDM readConversationWithLocalId(Long localId) {
        ConversationDM conversation = null;
        Cursor cursor = null;
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                conversation = this.cursorToReadableConversation(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with localId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversation;
    }

    public synchronized void deleteConversationWithLocalId(long localId) {
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.delete(this.dbInfo.TABLE_CONVERSATIONS, selection, selectionArgs);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in delete conversation with localId", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationDM readConversationWithServerId(String serverId) {
        ConversationDM conversation = null;
        Cursor cursor = null;
        String selection = this.dbInfo.SERVER_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(serverId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                conversation = this.cursorToReadableConversation(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with serverId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationDM readPreConversationWithServerId(String preConversationServerId) {
        ConversationDM conversation = null;
        Cursor cursor = null;
        String selection = this.dbInfo.PRE_CONVERSATION_SERVER_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(preConversationServerId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                conversation = this.cursorToReadableConversation(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with serverId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversation;
    }

    public synchronized long insertConversation(ConversationDM conversation) {
        ContentValues values = this.readableConversationToContentValues(conversation);
        long localId = -1L;
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            localId = database.insert(this.dbInfo.TABLE_CONVERSATIONS, null, values);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert conversation", ex);
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> insertConversations(List<ConversationDM> conversations) {
        if (conversations.size() == 0) {
            return null;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        for (ConversationDM conversation : conversations) {
            ContentValues values = this.readableConversationToContentValues(conversation);
            contentValues.add(values);
        }
        SQLiteDatabase database = null;
        ArrayList<Long> localIds = new ArrayList<Long>();
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (ContentValues contentValue : contentValues) {
                Long localId = database.insert(this.dbInfo.TABLE_CONVERSATIONS, null, contentValue);
                localIds.add(localId);
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert conversations", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in insert conversations inside finally block", e);
                }
            }
        }
        return localIds;
    }

    public synchronized void updateConversation(ConversationDM conversation) {
        ContentValues values = this.readableConversationToContentValues(conversation);
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(conversation.localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.update(this.dbInfo.TABLE_CONVERSATIONS, values, selection, selectionArgs);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update conversation", ex);
        }
    }

    public synchronized void updateLastUserActivityTimeInConversation(Long localId, long lastUserActivityTime) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.LAST_USER_ACTIVITY_TIME, Long.valueOf(lastUserActivityTime));
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.update(this.dbInfo.TABLE_CONVERSATIONS, contentValues, selection, selectionArgs);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in updateLastUserActivityTimeInConversation", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateConversations(List<ConversationDM> conversations) {
        if (conversations.size() == 0) {
            return;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        ArrayList<String[]> selectionArgs = new ArrayList<String[]>();
        for (ConversationDM conversation : conversations) {
            ContentValues values = this.readableConversationToContentValues(conversation);
            contentValues.add(values);
            String[] selectionArg = new String[]{String.valueOf(conversation.localId)};
            selectionArgs.add(selectionArg);
        }
        SQLiteDatabase database = null;
        String selection = this.dbInfo.ID + " = ?";
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (int i = 0; i < conversations.size(); ++i) {
                database.update(this.dbInfo.TABLE_CONVERSATIONS, (ContentValues)contentValues.get(i), selection, (String[])selectionArgs.get(i));
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update conversations", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in update conversations inside finally block", e);
                }
            }
        }
    }

    public synchronized ConversationInboxRecord storeConversationInboxRecord(ConversationInboxRecord record) {
        String selection = this.dbInfo.USER_LOCAL_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(record.userLocalId)};
        ContentValues values = this.conversationInboxRecordToContentValues(record);
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            boolean isRowExist = this.exists(database, this.dbInfo.TABLE_CONVERSATION_INBOX, selection, selectionArgs);
            if (isRowExist) {
                database.update(this.dbInfo.TABLE_CONVERSATION_INBOX, values, selection, selectionArgs);
            } else {
                database.insert(this.dbInfo.TABLE_CONVERSATION_INBOX, null, values);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in store conversation inbox record", ex);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationInboxRecord readConversationInboxRecord(long userLocalId) {
        ConversationInboxRecord record = null;
        Cursor cursor = null;
        String selection = this.dbInfo.USER_LOCAL_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(userLocalId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATION_INBOX, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                record = this.cursorToConversationInboxRecord(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversation inbox record", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return record;
    }

    public synchronized long insertMessage(MessageDM readableMessage) {
        ContentValues values = this.readableMessageToContentValues(readableMessage);
        long localId = -1L;
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            localId = database.insert(this.dbInfo.TABLE_MESSAGES, null, values);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert message", ex);
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> insertMessages(List<MessageDM> messageDMs) {
        if (messageDMs.size() == 0) {
            return null;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        for (MessageDM messageDM : messageDMs) {
            ContentValues values = this.readableMessageToContentValues(messageDM);
            contentValues.add(values);
        }
        SQLiteDatabase database = null;
        ArrayList<Long> localIds = new ArrayList<Long>();
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (ContentValues contentValue : contentValues) {
                Long localId = database.insert(this.dbInfo.TABLE_MESSAGES, null, contentValue);
                localIds.add(localId);
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert messages", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in insert messages inside finally block", e);
                }
            }
        }
        return localIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized List<MessageDM> readMessagesForConversations(Collection<Long> conversationslocalIds) {
        ArrayList<MessageDM> readableMessages = new ArrayList<MessageDM>();
        Cursor cursor = null;
        SQLiteDatabase database = null;
        try {
            int maxbatchCount = 900;
            List<List<Long>> batches = com.helpshift.util.DatabaseUtils.createBatches(maxbatchCount, new ArrayList<Long>(conversationslocalIds));
            database = this.dbHelper.getReadableDatabase();
            database.beginTransaction();
            for (List<Long> batch : batches) {
                String placeholders = com.helpshift.util.DatabaseUtils.makePlaceholders(batch.size());
                String selection = this.dbInfo.CONVERSATION_ID + " IN (" + placeholders + ")";
                String[] selectionArgs = new String[batch.size()];
                for (int index = 0; index < batch.size(); ++index) {
                    selectionArgs[index] = String.valueOf(batch.get(index));
                }
                cursor = database.query(this.dbInfo.TABLE_MESSAGES, null, selection, selectionArgs, null, null, null);
                if (!cursor.moveToFirst()) continue;
                do {
                    MessageDM readableMessage;
                    if ((readableMessage = this.cursorToMessageDM(cursor)) == null) continue;
                    readableMessages.add(readableMessage);
                } while (cursor.moveToNext());
            }
            database.setTransactionSuccessful();
            return readableMessages;
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read messages", ex);
            return readableMessages;
        }
        finally {
            try {
                if (database != null && database.inTransaction()) {
                    database.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in read messages inside finally block, ", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Map<Long, Integer> getMessagesCountForConversations(List<Long> conversationslocalIds, String[] messageTypes) {
        HashMap<Long, Integer> messageCountMap = new HashMap<Long, Integer>();
        for (Long conversationLocalId : conversationslocalIds) {
            messageCountMap.put(conversationLocalId, 0);
        }
        Cursor cursor = null;
        SQLiteDatabase database = null;
        try {
            int maxbatchCount = 900;
            List<List<Long>> batches = com.helpshift.util.DatabaseUtils.createBatches(maxbatchCount, new ArrayList<Long>(conversationslocalIds));
            database = this.dbHelper.getReadableDatabase();
            database.beginTransaction();
            for (List<Long> batch : batches) {
                String conversationIdPlaceholders = com.helpshift.util.DatabaseUtils.makePlaceholders(batch.size());
                StringBuilder selectionBuilder = new StringBuilder();
                String conversationIdSelection = this.dbInfo.CONVERSATION_ID + " IN (" + conversationIdPlaceholders + ")";
                selectionBuilder.append(conversationIdSelection);
                ArrayList<String> selectionArgsList = new ArrayList<String>();
                for (Long conversationLocalId : batch) {
                    selectionArgsList.add(String.valueOf(conversationLocalId));
                }
                if (messageTypes != null) {
                    String messageTypePlaceholders = com.helpshift.util.DatabaseUtils.makePlaceholders(messageTypes.length);
                    String messageTypeSelection = this.dbInfo.TYPE + " IN (" + messageTypePlaceholders + ")";
                    selectionBuilder.append(" AND ");
                    selectionBuilder.append(messageTypeSelection);
                    selectionArgsList.addAll(Arrays.asList(messageTypes));
                }
                String[] selectionArgs = new String[selectionArgsList.size()];
                selectionArgsList.toArray(selectionArgs);
                cursor = database.query(this.dbInfo.TABLE_MESSAGES, new String[]{"COUNT(*) AS COUNT", this.dbInfo.CONVERSATION_ID}, selectionBuilder.toString(), selectionArgs, this.dbInfo.CONVERSATION_ID, null, null);
                if (!cursor.moveToFirst()) continue;
                do {
                    long conversationLocalId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.CONVERSATION_ID));
                    int messagesCount = cursor.getInt(cursor.getColumnIndex("COUNT"));
                    messageCountMap.put(conversationLocalId, messagesCount);
                } while (cursor.moveToNext());
            }
            database.setTransactionSuccessful();
            return messageCountMap;
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in get messages count", ex);
            return messageCountMap;
        }
        finally {
            try {
                if (database != null && database.inTransaction()) {
                    database.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in get messages count inside finally block, ", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    public synchronized List<MessageDM> readMessages(long conversationLocalId) {
        String selection = this.dbInfo.CONVERSATION_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(conversationLocalId)};
        return this.readMessages(selection, selectionArgs);
    }

    public synchronized List<MessageDM> readMessages(long conversationLocalId, MessageType messageType) {
        String selection = this.dbInfo.CONVERSATION_ID + " = ? AND " + this.dbInfo.TYPE + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(conversationLocalId), messageType.getValue()};
        return this.readMessages(selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageDM> readMessages(String selection, String[] selectionArgs) {
        ArrayList<MessageDM> readableMessages = new ArrayList<MessageDM>();
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_MESSAGES, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    MessageDM readableMessage;
                    if ((readableMessage = this.cursorToMessageDM(cursor)) == null) continue;
                    readableMessages.add(readableMessage);
                } while (cursor.moveToNext());
            }
        }
        return readableMessages;
    }

    public synchronized void updateMessage(MessageDM readableMessage) {
        ContentValues values = this.readableMessageToContentValues(readableMessage);
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(readableMessage.localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.update(this.dbInfo.TABLE_MESSAGES, values, selection, selectionArgs);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update message", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMessages(List<MessageDM> messageDMs) {
        if (messageDMs.size() == 0) {
            return;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        ArrayList<String[]> selectionArgs = new ArrayList<String[]>();
        for (MessageDM messageDM : messageDMs) {
            ContentValues values = this.readableMessageToContentValues(messageDM);
            contentValues.add(values);
            String[] selectionArg = new String[]{String.valueOf(messageDM.localId)};
            selectionArgs.add(selectionArg);
        }
        SQLiteDatabase database = null;
        String selection = this.dbInfo.ID + " = ?";
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (int i = 0; i < messageDMs.size(); ++i) {
                database.update(this.dbInfo.TABLE_MESSAGES, (ContentValues)contentValues.get(i), selection, (String[])selectionArgs.get(i));
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update messages", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in update messages", e);
                }
            }
        }
    }

    private boolean exists(SQLiteDatabase database, String table, String query, String[] selectionArgs) {
        return DatabaseUtils.longForQuery((SQLiteDatabase)database, (String)("SELECT COUNT(*) FROM " + table + " WHERE " + query + " LIMIT 1"), (String[])selectionArgs) > 0L;
    }

    private ConversationInboxRecord cursorToConversationInboxRecord(Cursor cursor) {
        long userLocalId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.USER_LOCAL_ID));
        String formName = cursor.getString(cursor.getColumnIndex(this.dbInfo.FORM_NAME));
        String formEmail = cursor.getString(cursor.getColumnIndex(this.dbInfo.FORM_EMAIL));
        String description = cursor.getString(cursor.getColumnIndex(this.dbInfo.DESCRIPTION_DRAFT));
        long descriptionTimeStamp = cursor.getLong(cursor.getColumnIndex(this.dbInfo.DESCRIPTION_DRAFT_TIMESTAMP));
        String attachedDraftJson = cursor.getString(cursor.getColumnIndex(this.dbInfo.ATTACHMENT_DRAFT));
        ImagePickerFile imageAttachedDraft = this.parseAndGetImageAttachmentDraft(attachedDraftJson);
        int descriptionType = cursor.getInt(cursor.getColumnIndex(this.dbInfo.DESCRIPTION_TYPE));
        String archivedText = cursor.getString(cursor.getColumnIndex(this.dbInfo.ARCHIVAL_TEXT));
        String replyText = cursor.getString(cursor.getColumnIndex(this.dbInfo.REPLY_TEXT));
        boolean persistMessageBox = cursor.getInt(cursor.getColumnIndex(this.dbInfo.PERSIST_MESSAGE_BOX)) == 1;
        String inboxTimestamp = cursor.getString(cursor.getColumnIndex(this.dbInfo.LAST_SYNC_TIMESTAMP));
        Boolean hasOlderMessages = com.helpshift.util.DatabaseUtils.parseBooleanColumnSafe(cursor, this.dbInfo.HAS_OLDER_MESSAGES);
        Long lastRedactionTime = com.helpshift.util.DatabaseUtils.parseColumnSafe(cursor, this.dbInfo.LAST_CONVERSATIONS_REDACTION_TIME, Long.class);
        return new ConversationInboxRecord(userLocalId, formName, formEmail, description, descriptionTimeStamp, imageAttachedDraft, descriptionType, archivedText, replyText, persistMessageBox, inboxTimestamp, hasOlderMessages, lastRedactionTime);
    }

    private ContentValues conversationInboxRecordToContentValues(ConversationInboxRecord record) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.USER_LOCAL_ID, Long.valueOf(record.userLocalId));
        contentValues.put(this.dbInfo.FORM_NAME, record.formName);
        contentValues.put(this.dbInfo.FORM_EMAIL, record.formEmail);
        contentValues.put(this.dbInfo.DESCRIPTION_DRAFT, record.description);
        contentValues.put(this.dbInfo.DESCRIPTION_DRAFT_TIMESTAMP, Long.valueOf(record.descriptionTimeStamp));
        contentValues.put(this.dbInfo.DESCRIPTION_TYPE, Integer.valueOf(record.descriptionType));
        contentValues.put(this.dbInfo.ARCHIVAL_TEXT, record.archivalText);
        contentValues.put(this.dbInfo.REPLY_TEXT, record.replyText);
        contentValues.put(this.dbInfo.PERSIST_MESSAGE_BOX, Integer.valueOf(record.persistMessageBox ? 1 : 0));
        contentValues.put(this.dbInfo.LAST_SYNC_TIMESTAMP, record.lastSyncTimestamp);
        if (record.hasOlderMessages != null) {
            contentValues.put(this.dbInfo.HAS_OLDER_MESSAGES, Integer.valueOf(record.hasOlderMessages != false ? 1 : 0));
        }
        contentValues.put(this.dbInfo.LAST_CONVERSATIONS_REDACTION_TIME, record.lastConversationsRedactionTime);
        try {
            String imageAttachmentDraft = this.getImageAttachmentDraftMeta(record.imageAttachmentDraft);
            contentValues.put(this.dbInfo.ATTACHMENT_DRAFT, imageAttachmentDraft);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in generating meta string for image attachment", e);
        }
        return contentValues;
    }

    private ContentValues readableConversationToContentValues(ConversationDM conversation) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.USER_LOCAL_ID, Long.valueOf(conversation.userLocalId));
        contentValues.put(this.dbInfo.SERVER_ID, conversation.serverId);
        contentValues.put(this.dbInfo.PRE_CONVERSATION_SERVER_ID, conversation.preConversationServerId);
        contentValues.put(this.dbInfo.PUBLISH_ID, conversation.publishId);
        contentValues.put(this.dbInfo.LOCAL_UUID, conversation.localUUID);
        contentValues.put(this.dbInfo.TITLE, conversation.title);
        contentValues.put(this.dbInfo.MESSAGE_CURSOR, conversation.messageCursor);
        contentValues.put(this.dbInfo.SHOW_AGENT_NAME, Integer.valueOf(conversation.showAgentName ? 1 : 0));
        contentValues.put(this.dbInfo.IS_START_NEW_CONVERSATION_CLICKED, Integer.valueOf(conversation.isStartNewConversationClicked ? 1 : 0));
        contentValues.put(this.dbInfo.CREATED_AT, conversation.getCreatedAt());
        contentValues.put(this.dbInfo.UPDATED_AT, conversation.updatedAt);
        contentValues.put(this.dbInfo.EPOCH_TIME_CREATE_AT, Long.valueOf(conversation.getEpochCreatedAtTime()));
        contentValues.put(this.dbInfo.LAST_USER_ACTIVITY_TIME, Long.valueOf(conversation.lastUserActivityTime));
        contentValues.put(this.dbInfo.ISSUE_TYPE, conversation.issueType);
        contentValues.put(this.dbInfo.FULL_PRIVACY_ENABLED, Integer.valueOf(conversation.wasFullPrivacyEnabledAtCreation ? 1 : 0));
        contentValues.put(this.dbInfo.STATE, Integer.valueOf(conversation.state == null ? -1 : conversation.state.getValue()));
        this.dbInfo.getClass();
        contentValues.put("is_redacted", Integer.valueOf(conversation.isRedacted ? 1 : 0));
        try {
            String conversationMeta = this.getConversationMeta(conversation);
            this.dbInfo.getClass();
            contentValues.put("meta", conversationMeta);
        }
        catch (JSONException jsonException) {
            HSLogger.e(TAG, "Error in generating meta string for conversation", jsonException);
        }
        return contentValues;
    }

    private String getImageAttachmentDraftMeta(ImagePickerFile imagePickerFile) throws JSONException {
        if (imagePickerFile == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("image_draft_orig_name", (Object)imagePickerFile.originalFileName);
        jsonObject.put("image_draft_orig_size", (Object)imagePickerFile.originalFileSize);
        jsonObject.put("image_draft_file_path", (Object)imagePickerFile.filePath);
        jsonObject.put("image_copy_done", imagePickerFile.isFileCompressionAndCopyingDone);
        return jsonObject.toString();
    }

    private String getConversationMeta(ConversationDM conversation) throws JSONException {
        ConversationCSATState csatState = conversation.csatState;
        JSONObject jsonObject = new JSONObject();
        String csatFeedback = conversation.csatFeedback;
        int csatRating = conversation.csatRating;
        jsonObject.put("csat_feedback", (Object)csatFeedback);
        jsonObject.put("csat_rating", csatRating);
        jsonObject.put("csat_state", csatState.getValue());
        jsonObject.put("increment_message_count", conversation.shouldIncrementMessageCount);
        jsonObject.put("ended_delegate_sent", conversation.isConversationEndedDelegateSent);
        return jsonObject.toString();
    }

    private ConversationDM cursorToReadableConversation(Cursor cursor) {
        Long localId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.ID));
        long userLocalId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.USER_LOCAL_ID));
        String serverId = cursor.getString(cursor.getColumnIndex(this.dbInfo.SERVER_ID));
        String publishId = cursor.getString(cursor.getColumnIndex(this.dbInfo.PUBLISH_ID));
        String localUUID = cursor.getString(cursor.getColumnIndex(this.dbInfo.LOCAL_UUID));
        String title = cursor.getString(cursor.getColumnIndex(this.dbInfo.TITLE));
        int showAgentNameValue = cursor.getInt(cursor.getColumnIndex(this.dbInfo.SHOW_AGENT_NAME));
        boolean showAgentName = showAgentNameValue == 1;
        String messageCursor = cursor.getString(cursor.getColumnIndex(this.dbInfo.MESSAGE_CURSOR));
        int startNewConversationValue = cursor.getInt(cursor.getColumnIndex(this.dbInfo.IS_START_NEW_CONVERSATION_CLICKED));
        boolean startNewConversationAction = startNewConversationValue == 1;
        this.dbInfo.getClass();
        String meta = cursor.getString(cursor.getColumnIndex("meta"));
        String createdAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.CREATED_AT));
        long epochCreatedAt = cursor.getLong(cursor.getColumnIndex(this.dbInfo.EPOCH_TIME_CREATE_AT));
        String updatedAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.UPDATED_AT));
        String preConversationServerId = cursor.getString(cursor.getColumnIndex(this.dbInfo.PRE_CONVERSATION_SERVER_ID));
        long lastUserAccessTime = cursor.getLong(cursor.getColumnIndex(this.dbInfo.LAST_USER_ACTIVITY_TIME));
        String issueType = cursor.getString(cursor.getColumnIndex(this.dbInfo.ISSUE_TYPE));
        boolean wasFullPrivacyEnabledAtCreation = com.helpshift.util.DatabaseUtils.parseBooleanColumnSafe(cursor, this.dbInfo.FULL_PRIVACY_ENABLED, false);
        int preIssueStatusOrdinal = cursor.getInt(cursor.getColumnIndex(this.dbInfo.STATE));
        IssueState preIssueStatus = IssueState.fromInt(preIssueStatusOrdinal);
        this.dbInfo.getClass();
        boolean isRedacted = com.helpshift.util.DatabaseUtils.parseBooleanColumnSafe(cursor, "is_redacted", false);
        ConversationDM conversationDM = new ConversationDM(title, preIssueStatus, createdAt, epochCreatedAt, updatedAt, publishId, messageCursor, showAgentName);
        conversationDM.serverId = serverId;
        conversationDM.preConversationServerId = preConversationServerId;
        conversationDM.setLocalId(localId);
        conversationDM.localUUID = localUUID;
        conversationDM.issueType = issueType;
        conversationDM.state = preIssueStatus;
        conversationDM.userLocalId = userLocalId;
        conversationDM.setStartNewConversationButtonClicked(startNewConversationAction, false);
        conversationDM.lastUserActivityTime = lastUserAccessTime;
        conversationDM.wasFullPrivacyEnabledAtCreation = wasFullPrivacyEnabledAtCreation;
        conversationDM.isRedacted = isRedacted;
        this.parseAndSetMetaData(conversationDM, meta);
        return conversationDM;
    }

    private ContentValues readableMessageToContentValues(MessageDM messageDM) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.SERVER_ID, messageDM.serverId);
        contentValues.put(this.dbInfo.CONVERSATION_ID, messageDM.conversationLocalId);
        contentValues.put(this.dbInfo.BODY, messageDM.body);
        contentValues.put(this.dbInfo.AUTHOR_NAME, messageDM.authorName);
        contentValues.put(this.dbInfo.CREATED_AT, messageDM.getCreatedAt());
        contentValues.put(this.dbInfo.EPOCH_TIME_CREATE_AT, Long.valueOf(messageDM.getEpochCreatedAtTime()));
        contentValues.put(this.dbInfo.TYPE, messageDM.messageType.getValue());
        contentValues.put(this.dbInfo.DELIVERY_STATE, Integer.valueOf(messageDM.deliveryState));
        this.dbInfo.getClass();
        contentValues.put("is_redacted", Integer.valueOf(messageDM.isRedacted ? 1 : 0));
        try {
            this.dbInfo.getClass();
            contentValues.put("meta", this.getMessageMeta(messageDM));
        }
        catch (JSONException jsonException) {
            HSLogger.e(TAG, "Error in generating meta string for message", jsonException);
        }
        return contentValues;
    }

    private void parseAndSetMetaData(ConversationDM conversationDM, String meta) {
        if (meta == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(meta);
            int csatRating = jsonObject.optInt("csat_rating", 0);
            int csatState = jsonObject.optInt("csat_state", ConversationCSATState.NONE.getValue());
            String csatFeedback = jsonObject.optString("csat_feedback", null);
            conversationDM.setCSATData(csatRating, ConversationCSATState.fromInt(csatState), csatFeedback);
            boolean increaseMessageCount = jsonObject.optBoolean("increment_message_count", false);
            conversationDM.setShouldIncrementMessageCount(increaseMessageCount, false);
            conversationDM.isConversationEndedDelegateSent = jsonObject.optBoolean("ended_delegate_sent", false);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in parseAndSetMetaData", e);
        }
    }

    private ImagePickerFile parseAndGetImageAttachmentDraft(String meta) {
        if (meta == null) {
            return null;
        }
        ImagePickerFile imagePickerFile = null;
        try {
            JSONObject jsonObject = new JSONObject(meta);
            String originalName = jsonObject.optString("image_draft_orig_name", null);
            Long originalSize = jsonObject.optLong("image_draft_orig_size", -1L);
            String filePath = jsonObject.optString("image_draft_file_path", null);
            boolean isFileCopyingDone = jsonObject.optBoolean("image_copy_done", false);
            imagePickerFile = new ImagePickerFile(filePath, originalName, originalSize == -1L ? null : originalSize);
            imagePickerFile.isFileCompressionAndCopyingDone = isFileCopyingDone;
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in parseAndGetImageAttachmentDraft", e);
        }
        return imagePickerFile;
    }

    @Nullable
    private MessageDM cursorToMessageDM(Cursor cursor) {
        MessageDM messageDM;
        long localId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.ID));
        long conversationLocalId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.CONVERSATION_ID));
        String serverId = cursor.getString(cursor.getColumnIndex(this.dbInfo.SERVER_ID));
        String body = cursor.getString(cursor.getColumnIndex(this.dbInfo.BODY));
        String authorName = cursor.getString(cursor.getColumnIndex(this.dbInfo.AUTHOR_NAME));
        this.dbInfo.getClass();
        String metaText = cursor.getString(cursor.getColumnIndex("meta"));
        String type = cursor.getString(cursor.getColumnIndex(this.dbInfo.TYPE));
        String createAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.CREATED_AT));
        long epochCreatedAtTime = HSDateFormatSpec.convertToEpochTime(createAt);
        int deliveryState = cursor.getInt(cursor.getColumnIndex(this.dbInfo.DELIVERY_STATE));
        this.dbInfo.getClass();
        boolean isRedacted = com.helpshift.util.DatabaseUtils.parseBooleanColumnSafe(cursor, "is_redacted", false);
        MessageType messageType = MessageType.fromValue(type);
        JSONObject metaJson = this.jsonify(metaText);
        switch (messageType) {
            case USER_TEXT: {
                messageDM = new UserMessageDM(body, createAt, epochCreatedAtTime, authorName);
                messageDM.serverId = serverId;
                break;
            }
            case USER_RESP_FOR_TEXT_INPUT: {
                UserResponseMessageForTextInputDM userResponseMessageForTextInputDM = new UserResponseMessageForTextInputDM(body, createAt, epochCreatedAtTime, authorName, this.parseInputKeyboardFromMeta(metaJson), this.parseBotInfoFromMeta(metaJson), this.parseIsResponseSkippedFromMeta(metaJson), this.parseReferredMessageIdFromMeta(metaJson), this.parseIsMessageEmptyFromMeta(metaJson));
                userResponseMessageForTextInputDM.serverId = serverId;
                userResponseMessageForTextInputDM.dateInMillis = this.parseDateTimeFromMeta(metaJson);
                userResponseMessageForTextInputDM.timeZoneId = this.parseTimeZoneIdFromMeta(metaJson);
                messageDM = userResponseMessageForTextInputDM;
                break;
            }
            case USER_RESP_FOR_OPTION_INPUT: {
                messageDM = new UserResponseMessageForOptionInput(body, createAt, epochCreatedAtTime, authorName, this.parseBotInfoFromMeta(metaJson), this.parseIsResponseSkippedFromMeta(metaJson), this.parseSelectedOptionDataFromMeta(metaJson), this.parseReferredMessageIdFromMeta(metaJson), this.parseReferredMessageTypeFromMeta(metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case ADMIN_TEXT: {
                messageDM = new AdminMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName);
                break;
            }
            case ADMIN_TEXT_WITH_TEXT_INPUT: {
                messageDM = new AdminMessageWithTextInputDM(serverId, body, createAt, epochCreatedAtTime, authorName, this.parseBotInfoFromMeta(metaJson), this.parseInputPlaceholderFromMeta(metaJson), this.parseInputRequiredFromMeta(metaJson), this.parseInputLabelFromMeta(metaJson), this.parseInputSkipLabelFromMeta(metaJson), this.parseInputKeyboardFromMeta(metaJson), this.parseIsMessageEmptyFromMeta(metaJson));
                break;
            }
            case ADMIN_TEXT_WITH_OPTION_INPUT: {
                List<OptionInput.Option> options = this.parseInputOptionsFromMeta(metaJson);
                messageDM = new AdminMessageWithOptionInputDM(serverId, body, createAt, epochCreatedAtTime, authorName, this.parseBotInfoFromMeta(metaJson), this.parseInputRequiredFromMeta(metaJson), this.parseInputLabelFromMeta(metaJson), this.parseInputSkipLabelFromMeta(metaJson), options, this.parseInputOptionTypeFromMeta(metaJson, options.size()));
                break;
            }
            case FAQ_LIST: {
                messageDM = new FAQListMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName, this.parseFAQListFromMeta(metaJson), this.parseIsSuggestionsReadEventSent(metaJson), this.parseSuggestionReadFAQPublishId(metaJson));
                break;
            }
            case FAQ_LIST_WITH_OPTION_INPUT: {
                messageDM = new FAQListMessageWithOptionInputDM(serverId, body, createAt, epochCreatedAtTime, authorName, this.parseFAQListFromMeta(metaJson), this.parseBotInfoFromMeta(metaJson), this.parseInputRequiredFromMeta(metaJson), this.parseInputLabelFromMeta(metaJson), this.parseInputSkipLabelFromMeta(metaJson), this.parseInputOptionsFromMeta(metaJson), this.parseIsSuggestionsReadEventSent(metaJson), this.parseSuggestionReadFAQPublishId(metaJson));
                break;
            }
            case ACCEPTED_APP_REVIEW: {
                messageDM = new AcceptedAppReviewMessageDM(body, createAt, epochCreatedAtTime, authorName, this.parseReferredMessageIdFromMeta(metaJson), this.parseAndGetMessageSyncState(serverId, metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case REQUESTED_APP_REVIEW: {
                messageDM = new RequestAppReviewMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName, this.parseIsAnsweredFromMeta(metaJson));
                break;
            }
            case FOLLOWUP_ACCEPTED: {
                messageDM = new FollowupAcceptedMessageDM(body, createAt, epochCreatedAtTime, authorName, this.parseReferredMessageIdFromMeta(metaJson), this.parseAndGetMessageSyncState(serverId, metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case FOLLOWUP_REJECTED: {
                messageDM = new FollowupRejectedMessageDM(body, createAt, epochCreatedAtTime, authorName, this.parseReferredMessageIdFromMeta(metaJson), this.parseAndGetMessageSyncState(serverId, metaJson));
                messageDM.serverId = serverId;
                this.parseAndSetFollowUpRejectedDataFromMeta((FollowupRejectedMessageDM)messageDM, metaJson);
                break;
            }
            case CONFIRMATION_ACCEPTED: {
                messageDM = new ConfirmationAcceptedMessageDM(body, createAt, epochCreatedAtTime, authorName, this.parseAndGetMessageSyncState(serverId, metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case CONFIRMATION_REJECTED: {
                messageDM = new ConfirmationRejectedMessageDM(body, createAt, epochCreatedAtTime, authorName, this.parseAndGetMessageSyncState(serverId, metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case SCREENSHOT: {
                ImageAttachmentInfo imageAttachmentInfo = this.parseImageAttachmentInfoFromMeta(metaJson);
                ScreenshotMessageDM screenshotMessageDM = new ScreenshotMessageDM(body, createAt, epochCreatedAtTime, authorName, imageAttachmentInfo.contentType, imageAttachmentInfo.thumbnailUrl, imageAttachmentInfo.fileName, imageAttachmentInfo.url, imageAttachmentInfo.size, imageAttachmentInfo.isSecure);
                screenshotMessageDM.filePath = imageAttachmentInfo.filePath;
                screenshotMessageDM.serverId = serverId;
                screenshotMessageDM.setRefersMessageId(this.parseReferredMessageIdFromMeta(metaJson));
                messageDM = screenshotMessageDM;
                break;
            }
            case REQUESTED_SCREENSHOT: {
                messageDM = new RequestScreenshotMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName, this.parseIsAnsweredFromMeta(metaJson));
                break;
            }
            case ADMIN_ATTACHMENT: {
                AttachmentInfo attachmentInfo = this.parseAttachmentInfoFromMeta(metaJson);
                AdminAttachmentMessageDM adminAttachmentMessageDM = new AdminAttachmentMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName, attachmentInfo.size, attachmentInfo.contentType, attachmentInfo.url, attachmentInfo.fileName, attachmentInfo.isSecure);
                adminAttachmentMessageDM.filePath = attachmentInfo.filePath;
                adminAttachmentMessageDM.updateState();
                messageDM = adminAttachmentMessageDM;
                break;
            }
            case ADMIN_IMAGE_ATTACHMENT: {
                ImageAttachmentInfo imageAttachmentInfo = this.parseImageAttachmentInfoFromMeta(metaJson);
                AdminImageAttachmentMessageDM adminImageAttachmentMessageDM = new AdminImageAttachmentMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName, imageAttachmentInfo.url, imageAttachmentInfo.fileName, imageAttachmentInfo.thumbnailUrl, imageAttachmentInfo.contentType, imageAttachmentInfo.isSecure, imageAttachmentInfo.size);
                adminImageAttachmentMessageDM.filePath = imageAttachmentInfo.filePath;
                adminImageAttachmentMessageDM.thumbnailFilePath = imageAttachmentInfo.thumbnailFilePath;
                adminImageAttachmentMessageDM.updateState();
                messageDM = adminImageAttachmentMessageDM;
                break;
            }
            case REQUEST_FOR_REOPEN: {
                RequestForReopenMessageDM requestForReopenMessageDM = new RequestForReopenMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName);
                requestForReopenMessageDM.setAnswered(this.parseIsAnsweredFromMeta(metaJson));
                messageDM = requestForReopenMessageDM;
                break;
            }
            case ADMIN_BOT_CONTROL: {
                String actionType = this.parseBotActionTypeFromMeta(metaJson);
                String botInfo = this.parseBotInfoFromMeta(metaJson);
                Boolean hasNextBot = this.parseHasNextBotFromMeta(metaJson);
                AdminBotControlMessageDM adminBotControlMessageDM = new AdminBotControlMessageDM(serverId, body, createAt, epochCreatedAtTime, authorName, actionType, botInfo);
                adminBotControlMessageDM.hasNextBot = hasNextBot;
                messageDM = adminBotControlMessageDM;
                break;
            }
            case USER_BOT_CONTROL: {
                String actionType = this.parseBotActionTypeFromMeta(metaJson);
                String botInfo = this.parseBotInfoFromMeta(metaJson);
                String reason = this.parseBotEndedReasonFromMeta(metaJson);
                String refersMessageId = this.parseReferredMessageIdFromMeta(metaJson);
                int syncStatus = this.parseAndGetMessageSyncState(serverId, metaJson);
                messageDM = new UserBotControlMessageDM(body, createAt, epochCreatedAtTime, authorName, actionType, reason, botInfo, refersMessageId, syncStatus);
                messageDM.serverId = serverId;
                break;
            }
            default: {
                return null;
            }
        }
        messageDM.conversationLocalId = conversationLocalId;
        messageDM.localId = localId;
        messageDM.deliveryState = deliveryState;
        messageDM.isRedacted = isRedacted;
        this.parseAndSetMessageSeenData(messageDM, metaJson);
        return messageDM;
    }

    private OptionInput.Type parseInputOptionTypeFromMeta(JSONObject metaJson, int optionsCount) {
        return OptionInput.Type.getType(this.getStringFromJson(metaJson, "option_type", ""), optionsCount);
    }

    private boolean parseIsMessageEmptyFromMeta(JSONObject metaJson) {
        return this.getBooleanFromJson(metaJson, "is_message_empty", false);
    }

    private String parseBotActionTypeFromMeta(JSONObject metaJson) {
        return metaJson.optString("bot_action_type", "");
    }

    private String parseBotEndedReasonFromMeta(JSONObject metaJson) {
        return metaJson.optString("bot_ended_reason", "");
    }

    private String parseSuggestionReadFAQPublishId(JSONObject metaJson) {
        return this.getStringFromJson(metaJson, "suggestion_read_faq_publish_id", "");
    }

    private boolean parseIsSuggestionsReadEventSent(JSONObject metaJson) {
        return this.getBooleanFromJson(metaJson, "is_suggestion_read_event_sent", false);
    }

    private List<FAQListMessageDM.FAQ> parseFAQListFromMeta(@NonNull JSONObject metaJson) {
        ArrayList<FAQListMessageDM.FAQ> result = new ArrayList<FAQListMessageDM.FAQ>();
        try {
            JSONArray faqsArray = metaJson.getJSONArray("faqs");
            for (int i = 0; i < faqsArray.length(); ++i) {
                JSONObject faqObj = faqsArray.getJSONObject(i);
                result.add(new FAQListMessageDM.FAQ(faqObj.getString("faq_title"), faqObj.getString("faq_publish_id"), faqObj.getString("faq_language")));
            }
        }
        catch (JSONException e) {
            return result;
        }
        return result;
    }

    private List<OptionInput.Option> parseInputOptionsFromMeta(@NonNull JSONObject metaJson) {
        ArrayList<OptionInput.Option> result = new ArrayList<OptionInput.Option>();
        try {
            JSONArray optionsArray = metaJson.getJSONArray("input_options");
            for (int i = 0; i < optionsArray.length(); ++i) {
                JSONObject optionObj = optionsArray.getJSONObject(i);
                result.add(new OptionInput.Option(optionObj.getString("option_title"), optionObj.getString("option_data")));
            }
        }
        catch (JSONException e) {
            return result;
        }
        return result;
    }

    private int getIntFromJson(@NonNull JSONObject metaJson, String key, int defVal) {
        return metaJson.optInt(key, defVal);
    }

    private String getStringFromJson(@NonNull JSONObject metaJson, String key, String defVal) {
        return metaJson.optString(key, defVal);
    }

    private boolean getBooleanFromJson(@NonNull JSONObject metaJson, String key, boolean defVal) {
        return metaJson.optBoolean(key, defVal);
    }

    private MessageType parseReferredMessageTypeFromMeta(JSONObject metaJson) {
        return MessageType.fromValue(this.getStringFromJson(metaJson, "referred_message_type", ""));
    }

    private String parseSelectedOptionDataFromMeta(JSONObject metaJson) {
        return this.getStringFromJson(metaJson, "selected_option_data", "{}");
    }

    private boolean parseIsResponseSkippedFromMeta(JSONObject metaJson) {
        return this.getBooleanFromJson(metaJson, "is_response_skipped", false);
    }

    private int parseInputKeyboardFromMeta(JSONObject metaJson) {
        return this.getIntFromJson(metaJson, "input_keyboard", 1);
    }

    private String parseInputSkipLabelFromMeta(JSONObject metaJson) {
        return this.getStringFromJson(metaJson, "input_skip_label", "");
    }

    private String parseInputLabelFromMeta(JSONObject metaJson) {
        return this.getStringFromJson(metaJson, "input_label", "");
    }

    private boolean parseInputRequiredFromMeta(JSONObject metaJson) {
        return this.getBooleanFromJson(metaJson, "input_required", false);
    }

    private String parseInputPlaceholderFromMeta(JSONObject metaJson) {
        return this.getStringFromJson(metaJson, "input_placeholder", "");
    }

    private String parseBotInfoFromMeta(@NonNull JSONObject metaJson) {
        String result = "{}";
        result = metaJson.optString("chatbot_info", result);
        return result;
    }

    private long parseDateTimeFromMeta(@NonNull JSONObject metaJson) {
        return metaJson.optLong("dt", 0L);
    }

    private String parseTimeZoneIdFromMeta(@NonNull JSONObject metaJson) {
        return metaJson.optString("timezone_id");
    }

    private Boolean parseHasNextBotFromMeta(@NonNull JSONObject metaJson) {
        return metaJson.optBoolean("has_next_bot", false);
    }

    private int parseAndGetMessageSyncState(String serverId, @NonNull JSONObject metaJson) {
        if (!StringUtils.isEmpty(serverId)) {
            return 2;
        }
        return metaJson.optInt("message_sync_status", 1);
    }

    private void parseAndSetMessageSeenData(MessageDM messageDM, @NonNull JSONObject meta) {
        String readAt = meta.optString("read_at", "");
        String seenAtMessageCursor = meta.optString("seen_cursor", null);
        boolean seenSyncStatus = meta.optBoolean("seen_sync_status", false);
        messageDM.seenAtMessageCursor = seenAtMessageCursor;
        messageDM.isMessageSeenSynced = seenSyncStatus;
        messageDM.readAt = readAt;
    }

    private JSONObject jsonify(String data) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isEmpty(data)) {
            return jsonObject;
        }
        try {
            jsonObject = new JSONObject(data);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Exception in jsonify", e);
        }
        return jsonObject;
    }

    private String parseReferredMessageIdFromMeta(@NonNull JSONObject meta) {
        return meta.optString("referredMessageId", null);
    }

    private boolean parseIsAnsweredFromMeta(@NonNull JSONObject meta) {
        return meta.optBoolean("is_answered", false);
    }

    private AttachmentInfo parseAttachmentInfoFromMeta(@NonNull JSONObject meta) {
        return new AttachmentInfo(meta);
    }

    private ImageAttachmentInfo parseImageAttachmentInfoFromMeta(@NonNull JSONObject meta) {
        return new ImageAttachmentInfo(meta);
    }

    private void parseAndSetFollowUpRejectedDataFromMeta(FollowupRejectedMessageDM messageDM, @NonNull JSONObject meta) {
        int reason = meta.optInt("rejected_reason");
        String activeConversationId = meta.optString("rejected_conv_id", null);
        messageDM.reason = reason;
        messageDM.openConversationId = activeConversationId;
    }

    private String getMessageMeta(MessageDM messageDM) throws JSONException {
        MessageType messageType = messageDM.messageType;
        JSONObject result = null;
        switch (messageType) {
            case USER_RESP_FOR_TEXT_INPUT: {
                result = new JSONObject();
                UserResponseMessageForTextInputDM userResponseMessageForTextInputDM = (UserResponseMessageForTextInputDM)messageDM;
                this.buildMetaForBotInfo(result, userResponseMessageForTextInputDM.botInfo);
                this.buildMetaForInputKeyboard(result, userResponseMessageForTextInputDM.keyboard);
                this.buildMetaForIsResponseSkipped(result, userResponseMessageForTextInputDM.skipped);
                this.buildMetaForReferredMessageId(result, userResponseMessageForTextInputDM.getReferredMessageId());
                this.buildMetaForIsMessageEmpty(result, userResponseMessageForTextInputDM.isMessageEmpty);
                this.buildMetaForDateTime(result, userResponseMessageForTextInputDM);
                break;
            }
            case USER_RESP_FOR_OPTION_INPUT: {
                result = new JSONObject();
                UserResponseMessageForOptionInput userResponseMessageForOptionInput = (UserResponseMessageForOptionInput)messageDM;
                this.buildMetaForBotInfo(result, userResponseMessageForOptionInput.botInfo);
                this.buildMetaForIsResponseSkipped(result, userResponseMessageForOptionInput.skipped);
                this.buildMetaForReferredMessageId(result, userResponseMessageForOptionInput.getReferredMessageId());
                this.buildMetaForReferredMessageType(result, userResponseMessageForOptionInput.referredMessageType);
                this.buildMetaForSelectedOptionData(result, userResponseMessageForOptionInput.optionData);
                break;
            }
            case ADMIN_TEXT: {
                result = new JSONObject();
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case ADMIN_TEXT_WITH_TEXT_INPUT: {
                result = new JSONObject();
                AdminMessageWithTextInputDM adminMessageWithTextInputDM = (AdminMessageWithTextInputDM)messageDM;
                this.buildMetaForMessageSeenData(result, messageDM);
                this.buildMetaForInput(result, adminMessageWithTextInputDM.input);
                this.buildMetaForIsMessageEmpty(result, adminMessageWithTextInputDM.isMessageEmpty);
                break;
            }
            case ADMIN_TEXT_WITH_OPTION_INPUT: {
                result = new JSONObject();
                this.buildMetaForMessageSeenData(result, messageDM);
                this.buildMetaForInput(result, ((AdminMessageWithOptionInputDM)messageDM).input);
                break;
            }
            case FAQ_LIST: {
                result = new JSONObject();
                this.buildMetaForMessageSeenData(result, messageDM);
                this.buildMetaForFAQList(result, (FAQListMessageDM)messageDM);
                this.buildMetaForIsSuggestionsReadEvent(result, (FAQListMessageDM)messageDM);
                break;
            }
            case FAQ_LIST_WITH_OPTION_INPUT: {
                result = new JSONObject();
                this.buildMetaForMessageSeenData(result, messageDM);
                this.buildMetaForFAQList(result, (FAQListMessageDM)messageDM);
                this.buildMetaForInput(result, ((FAQListMessageWithOptionInputDM)messageDM).input);
                this.buildMetaForIsSuggestionsReadEvent(result, (FAQListMessageWithOptionInputDM)messageDM);
                break;
            }
            case ACCEPTED_APP_REVIEW: {
                result = new JSONObject();
                AcceptedAppReviewMessageDM acceptedReviewMessage = (AcceptedAppReviewMessageDM)messageDM;
                this.buildMetaForReferredMessageId(result, acceptedReviewMessage.referredMessageId);
                this.buildMetaForAutoRetriableMessage(result, acceptedReviewMessage);
                break;
            }
            case REQUESTED_SCREENSHOT: {
                result = new JSONObject();
                RequestScreenshotMessageDM requestScreenshotMessage = (RequestScreenshotMessageDM)messageDM;
                this.buildMetaForIsAnswered(result, requestScreenshotMessage.isAnswered);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case REQUEST_FOR_REOPEN: {
                result = new JSONObject();
                RequestForReopenMessageDM requestForReopenMessageDM = (RequestForReopenMessageDM)messageDM;
                this.buildMetaForIsAnswered(result, requestForReopenMessageDM.isAnswered());
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case FOLLOWUP_ACCEPTED: {
                result = new JSONObject();
                FollowupAcceptedMessageDM followupAcceptedMessage = (FollowupAcceptedMessageDM)messageDM;
                this.buildMetaForReferredMessageId(result, followupAcceptedMessage.referredMessageId);
                this.buildMetaForAutoRetriableMessage(result, followupAcceptedMessage);
                break;
            }
            case FOLLOWUP_REJECTED: {
                result = new JSONObject();
                FollowupRejectedMessageDM followupRejectedMessageDM = (FollowupRejectedMessageDM)messageDM;
                this.buildMetaForFollowUpRejected(result, followupRejectedMessageDM);
                this.buildMetaForAutoRetriableMessage(result, followupRejectedMessageDM);
                break;
            }
            case REQUESTED_APP_REVIEW: {
                result = new JSONObject();
                RequestAppReviewMessageDM requestAppReviewMessage = (RequestAppReviewMessageDM)messageDM;
                this.buildMetaForIsAnswered(result, requestAppReviewMessage.isAnswered);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case ADMIN_ATTACHMENT: {
                result = new JSONObject();
                AttachmentMessageDM adminAttachmentMessage = (AttachmentMessageDM)messageDM;
                this.buildJsonObjectForAttachmentMessage(result, adminAttachmentMessage);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case ADMIN_IMAGE_ATTACHMENT: {
                result = new JSONObject();
                this.buildMetaForImageAttachmentMessage(result, (ImageAttachmentMessageDM)messageDM);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case SCREENSHOT: {
                result = new JSONObject();
                this.buildMetaForScreenshotAttachmentMessage(result, (ScreenshotMessageDM)messageDM);
                break;
            }
            case ADMIN_BOT_CONTROL: {
                result = new JSONObject();
                this.buildMetaForAdminBotControlMessage(result, (AdminBotControlMessageDM)messageDM);
                break;
            }
            case USER_BOT_CONTROL: {
                result = new JSONObject();
                UserBotControlMessageDM userBotControlMessageDM = (UserBotControlMessageDM)messageDM;
                this.buildMetaForUserBotControlMessage(result, userBotControlMessageDM);
                this.buildMetaForAutoRetriableMessage(result, userBotControlMessageDM);
                break;
            }
            case CONFIRMATION_ACCEPTED: {
                result = new JSONObject();
                ConfirmationAcceptedMessageDM acceptedMessageDM = (ConfirmationAcceptedMessageDM)messageDM;
                this.buildMetaForAutoRetriableMessage(result, acceptedMessageDM);
                break;
            }
            case CONFIRMATION_REJECTED: {
                result = new JSONObject();
                ConfirmationRejectedMessageDM rejectedMessageDM = (ConfirmationRejectedMessageDM)messageDM;
                this.buildMetaForAutoRetriableMessage(result, rejectedMessageDM);
            }
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    private void buildMetaForIsSuggestionsReadEvent(JSONObject result, FAQListMessageDM messageDM) throws JSONException {
        result.put("is_suggestion_read_event_sent", messageDM.isSuggestionsReadEventSent);
        result.put("suggestion_read_faq_publish_id", (Object)messageDM.suggestionsReadFAQPublishId);
    }

    private void buildMetaForIsMessageEmpty(JSONObject result, boolean isMessageEmpty) throws JSONException {
        result.put("is_message_empty", isMessageEmpty);
    }

    private void buildMetaForAdminBotControlMessage(JSONObject result, AdminBotControlMessageDM messageDM) throws JSONException {
        result.put("bot_action_type", (Object)messageDM.actionType);
        result.put("has_next_bot", messageDM.hasNextBot);
    }

    private void buildMetaForUserBotControlMessage(JSONObject result, UserBotControlMessageDM messageDM) throws JSONException {
        result.put("bot_action_type", (Object)messageDM.actionType);
        result.put("chatbot_info", (Object)messageDM.botInfo);
        result.put("bot_ended_reason", (Object)messageDM.reason);
        result.put("referredMessageId", (Object)messageDM.refersMessageId);
    }

    private void buildMetaForFAQList(JSONObject result, FAQListMessageDM messageDM) throws JSONException {
        if (messageDM.faqs != null) {
            JSONArray faqArray = new JSONArray();
            for (FAQListMessageDM.FAQ faq : messageDM.faqs) {
                JSONObject faqObj = new JSONObject();
                faqObj.put("faq_title", (Object)faq.title);
                faqObj.put("faq_publish_id", (Object)faq.publishId);
                faqObj.put("faq_language", (Object)faq.language);
                faqArray.put((Object)faqObj);
            }
            result.put("faqs", (Object)faqArray);
        }
    }

    private void buildMetaForReferredMessageType(JSONObject result, MessageType referredMessageType) throws JSONException {
        result.put("referred_message_type", (Object)referredMessageType.getValue());
    }

    private void buildMetaForSelectedOptionData(JSONObject result, String optionData) throws JSONException {
        result.put("selected_option_data", (Object)optionData);
    }

    private void buildMetaForIsResponseSkipped(JSONObject result, boolean skipped) throws JSONException {
        result.put("is_response_skipped", skipped);
    }

    private void buildMetaForInputKeyboard(JSONObject result, int keyboard) throws JSONException {
        result.put("input_keyboard", keyboard);
    }

    private void buildMetaForDateTime(JSONObject result, UserResponseMessageForTextInputDM userResponseMessageForTextInputDM) throws JSONException {
        if (userResponseMessageForTextInputDM.keyboard == 4) {
            result.put("dt", userResponseMessageForTextInputDM.dateInMillis);
            result.put("timezone_id", (Object)userResponseMessageForTextInputDM.timeZoneId);
        }
    }

    private void buildMetaForBotInfo(JSONObject result, String botInfo) throws JSONException {
        result.put("chatbot_info", (Object)botInfo);
    }

    private void buildMetaForInput(JSONObject result, TextInput input) throws JSONException {
        this.buildMetaForBotInfo(result, input.botInfo);
        result.put("input_required", input.required);
        result.put("input_skip_label", (Object)input.skipLabel);
        result.put("input_label", (Object)input.inputLabel);
        result.put("input_placeholder", (Object)input.placeholder);
        this.buildMetaForInputKeyboard(result, input.keyboard);
    }

    private void buildMetaForInput(JSONObject result, OptionInput input) throws JSONException {
        this.buildMetaForBotInfo(result, input.botInfo);
        result.put("input_required", input.required);
        result.put("input_label", (Object)input.inputLabel);
        result.put("input_skip_label", (Object)input.skipLabel);
        if (input.options != null) {
            JSONArray optionsArray = new JSONArray();
            for (OptionInput.Option option : input.options) {
                JSONObject optionObj = new JSONObject();
                optionObj.put("option_title", (Object)option.title);
                optionObj.put("option_data", (Object)option.jsonData);
                optionsArray.put((Object)optionObj);
            }
            result.put("input_options", (Object)optionsArray);
        }
        result.put("option_type", (Object)input.type.toString());
    }

    private void buildMetaForMessageSeenData(JSONObject jsonObject, MessageDM messageDM) throws JSONException {
        jsonObject.put("seen_cursor", (Object)messageDM.seenAtMessageCursor);
        jsonObject.put("seen_sync_status", messageDM.isMessageSeenSynced);
        jsonObject.put("read_at", (Object)messageDM.readAt);
    }

    private void buildMetaForReferredMessageId(JSONObject jsonObject, String referredMessageId) throws JSONException {
        jsonObject.put("referredMessageId", (Object)referredMessageId);
    }

    private void buildMetaForFollowUpRejected(JSONObject jsonObject, FollowupRejectedMessageDM followupRejectedMessage) throws JSONException {
        jsonObject.put("referredMessageId", (Object)followupRejectedMessage.referredMessageId);
        jsonObject.put("rejected_reason", followupRejectedMessage.reason);
        jsonObject.put("rejected_conv_id", (Object)followupRejectedMessage.openConversationId);
    }

    private void buildMetaForIsAnswered(JSONObject jsonObject, boolean isAnswered) throws JSONException {
        jsonObject.put("is_answered", isAnswered);
    }

    private void buildJsonObjectForAttachmentMessage(JSONObject jsonObject, AttachmentMessageDM attachmentMessage) throws JSONException {
        jsonObject.put("content_type", (Object)attachmentMessage.contentType);
        jsonObject.put("file_name", (Object)attachmentMessage.fileName);
        jsonObject.put("filePath", (Object)attachmentMessage.filePath);
        jsonObject.put("url", (Object)attachmentMessage.attachmentUrl);
        jsonObject.put("size", attachmentMessage.size);
        jsonObject.put("is_secure", attachmentMessage.isSecureAttachment);
    }

    private void buildMetaForScreenshotAttachmentMessage(JSONObject jsonObject, ScreenshotMessageDM message) throws JSONException {
        this.buildJsonObjectForAttachmentMessage(jsonObject, message);
        jsonObject.put("thumbnail_url", (Object)message.thumbnailUrl);
        jsonObject.put("referredMessageId", (Object)message.refersMessageId);
        jsonObject.put("is_secure", message.isSecureAttachment);
    }

    private void buildMetaForImageAttachmentMessage(JSONObject jsonObject, ImageAttachmentMessageDM imageAttachmentMessage) throws JSONException {
        this.buildJsonObjectForAttachmentMessage(jsonObject, imageAttachmentMessage);
        jsonObject.put("thumbnail_url", (Object)imageAttachmentMessage.thumbnailUrl);
        jsonObject.put("thumbnailFilePath", (Object)imageAttachmentMessage.thumbnailFilePath);
        jsonObject.put("is_secure", imageAttachmentMessage.isSecureAttachment);
    }

    private void buildMetaForAutoRetriableMessage(JSONObject jsonObject, AutoRetriableMessageDM autoRetriableMessageDM) throws JSONException {
        jsonObject.put("message_sync_status", autoRetriableMessageDM.getSyncStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageDM readMessageWithServerId(String serverId) {
        MessageDM message = null;
        Cursor cursor = null;
        String selection = this.dbInfo.SERVER_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(serverId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_MESSAGES, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                message = this.cursorToMessageDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read message with serverId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageDM readMessageWithLocalId(Long localId) {
        MessageDM message = null;
        Cursor cursor = null;
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_MESSAGES, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                message = this.cursorToMessageDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read message with localId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return message;
    }

    public synchronized void dropAndCreateDatabase() {
        this.dbHelper.dropAndCreateDatabase(this.dbHelper.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Faq getAdminFAQSuggestion(String publishId, String language) {
        if (StringUtils.isEmpty(publishId) || StringUtils.isEmpty(language)) {
            return null;
        }
        Faq faq = null;
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query("faq_suggestions", null, "publish_id = ? AND language = ?", new String[]{publishId, language}, null, null, null);
            if (cursor.moveToFirst()) {
                faq = this.cursorToFaq(cursor);
            }
        }
        return faq;
    }

    public synchronized void insertOrUpdateAdminFAQSuggestion(Faq faq) {
        ContentValues values = ConversationDB.faqToContentValues(faq);
        String whereClause = "publish_id = ? AND language = ?";
        String[] whereArgs = new String[]{faq.publish_id, faq.language};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            if (!this.exists(database, "faq_suggestions", whereClause, whereArgs)) {
                database.insert("faq_suggestions", null, values);
            } else {
                database.update("faq_suggestions", values, whereClause, whereArgs);
            }
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error in insertOrUpdateAdminFAQSuggestion", e);
        }
    }

    private Faq cursorToFaq(Cursor cursor) {
        return new Faq(cursor.getLong(cursor.getColumnIndex("_id")), cursor.getString(cursor.getColumnIndex("question_id")), cursor.getString(cursor.getColumnIndex("publish_id")), cursor.getString(cursor.getColumnIndex("language")), cursor.getString(cursor.getColumnIndex("section_id")), cursor.getString(cursor.getColumnIndex("title")), cursor.getString(cursor.getColumnIndex("body")), cursor.getInt(cursor.getColumnIndex("helpful")), cursor.getInt(cursor.getColumnIndex("rtl")) == 1, HSJSONUtils.jsonToStringArrayList(cursor.getString(cursor.getColumnIndex("tags"))), HSJSONUtils.jsonToStringArrayList(cursor.getString(cursor.getColumnIndex("c_tags"))));
    }

    public synchronized void removeAdminFAQSuggestion(String publishId, String language) {
        if (!TextUtils.isEmpty((CharSequence)publishId) && !TextUtils.isEmpty((CharSequence)language)) {
            try {
                String whereClause = "publish_id = ? AND language = ?";
                String[] whereArgs = new String[]{publishId, language};
                SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                database.delete("faq_suggestions", whereClause, whereArgs);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in removeAdminFAQSuggestion", e);
            }
        }
    }

    public synchronized void deleteConversationInboxData(long userLocalId) {
        String deleteConversationInbox = "delete from " + this.dbInfo.TABLE_CONVERSATION_INBOX + " where " + this.dbInfo.USER_LOCAL_ID + " = ?";
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.execSQL(deleteConversationInbox, (Object[])new String[]{String.valueOf(userLocalId)});
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in delete conversationInboxData with UserLocalId", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteConversations(long userLocalId) {
        String conversationTable = this.dbInfo.TABLE_CONVERSATIONS;
        String messagesTable = this.dbInfo.TABLE_MESSAGES;
        String conversationsPrimaryKey = conversationTable + "." + this.dbInfo.ID;
        String conversationsForeignKey = conversationTable + "." + this.dbInfo.USER_LOCAL_ID;
        String messagesForeignKey = messagesTable + "." + this.dbInfo.CONVERSATION_ID;
        String conversationIds = "select " + conversationsPrimaryKey + " from  " + this.dbInfo.TABLE_CONVERSATIONS + "  where " + conversationsForeignKey + " = ?";
        String deleteMessages = "delete from " + this.dbInfo.TABLE_MESSAGES + " where " + messagesForeignKey + " IN  ( " + conversationIds + " )";
        String deleteConversations = "delete from " + this.dbInfo.TABLE_CONVERSATIONS + " where " + this.dbInfo.USER_LOCAL_ID + " = ?";
        SQLiteDatabase database = null;
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            database.execSQL(deleteMessages, (Object[])new String[]{String.valueOf(userLocalId)});
            database.execSQL(deleteConversations, (Object[])new String[]{String.valueOf(userLocalId)});
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in delete conversations with UserLocalId", ex);
        }
        finally {
            if (database != null) {
                database.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getOldestMessageCursor(long userLocalId) {
        String resultColumnName = "message_create_at";
        String userIdColumn = this.dbInfo.TABLE_CONVERSATIONS + "." + this.dbInfo.USER_LOCAL_ID;
        String conversationPrimaryKeyColumn = this.dbInfo.TABLE_CONVERSATIONS + "." + this.dbInfo.ID;
        String messageForegeinKeyColumn = this.dbInfo.TABLE_MESSAGES + "." + this.dbInfo.CONVERSATION_ID;
        String messageCreateAtColumn = this.dbInfo.TABLE_MESSAGES + "." + this.dbInfo.CREATED_AT;
        String messageEpochTimeCreateAtColumn = this.dbInfo.TABLE_MESSAGES + "." + this.dbInfo.EPOCH_TIME_CREATE_AT;
        String sqlQuery = "SELECT " + messageCreateAtColumn + " AS " + resultColumnName + " FROM " + this.dbInfo.TABLE_CONVERSATIONS + " INNER JOIN " + this.dbInfo.TABLE_MESSAGES + " ON " + conversationPrimaryKeyColumn + " = " + messageForegeinKeyColumn + " WHERE " + userIdColumn + " = ? ORDER BY " + messageEpochTimeCreateAtColumn + "  ASC LIMIT 1";
        String result = null;
        String[] args = new String[]{String.valueOf(userLocalId)};
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.rawQuery(sqlQuery, args);
            if (cursor.moveToFirst()) {
                result = cursor.getString(cursor.getColumnIndex(resultColumnName));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Long getOldestConversationEpochCreatedAtTime(long userLocalId) {
        Long epochCreatedAt = null;
        Cursor cursor = null;
        String selection = this.dbInfo.USER_LOCAL_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(userLocalId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, new String[]{this.dbInfo.EPOCH_TIME_CREATE_AT}, selection, selectionArgs, null, null, this.dbInfo.EPOCH_TIME_CREATE_AT + " ASC", "1");
            if (cursor.moveToFirst()) {
                epochCreatedAt = com.helpshift.util.DatabaseUtils.parseColumnSafe(cursor, this.dbInfo.EPOCH_TIME_CREATE_AT, Long.class);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in getting latest conversation created_at time", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return epochCreatedAt;
    }

    private class AttachmentInfo {
        final String contentType;
        final String fileName;
        final String url;
        final String filePath;
        final int size;
        final boolean isSecure;

        AttachmentInfo(JSONObject jsonObject) {
            this.fileName = jsonObject.optString("file_name", null);
            this.contentType = jsonObject.optString("content_type", null);
            this.url = jsonObject.optString("url", null);
            this.size = jsonObject.optInt("size", 0);
            this.filePath = jsonObject.optString("filePath", null);
            this.isSecure = jsonObject.optBoolean("is_secure", false);
        }
    }

    private class ImageAttachmentInfo
    extends AttachmentInfo {
        final String thumbnailUrl;
        final String thumbnailFilePath;

        ImageAttachmentInfo(JSONObject jsonObject) {
            super(jsonObject);
            this.thumbnailUrl = jsonObject.optString("thumbnail_url", null);
            this.thumbnailFilePath = jsonObject.optString("thumbnailFilePath", null);
        }
    }
}

