/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.conversation;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConversationDBInfo {
    public static final String DATABASE_NAME = "__hs__db_issues";
    public static final Integer DATABASE_VERSION = 7;
    static final String TABLE_FAQ_LIST_SUGGESTIONS = "faq_suggestions";
    public final String ID = "_id";
    public final String CREATED_AT = "created_at";
    public final String EPOCH_TIME_CREATE_AT = "epoch_time_created_at";
    public final String TABLE_CONVERSATIONS = "issues";
    public final String TABLE_MESSAGES = "messages";
    final String TABLE_CONVERSATION_INBOX = "conversation_inbox";
    final String SERVER_ID = "server_id";
    final String PUBLISH_ID = "publish_id";
    final String LOCAL_UUID = "uuid";
    final String USER_LOCAL_ID = "user_local_id";
    final String TITLE = "title";
    final String UPDATED_AT = "updated_at";
    final String STATE = "state";
    final String SHOW_AGENT_NAME = "show_agent_name";
    final String MESSAGE_CURSOR = "message_cursor";
    final String IS_START_NEW_CONVERSATION_CLICKED = "start_new_conversation_action";
    final String IS_REDACTED_CONVERSATION = "is_redacted";
    final String CONVERSATION_META = "meta";
    final String PRE_CONVERSATION_SERVER_ID = "pre_conv_server_id";
    final String LAST_USER_ACTIVITY_TIME = "last_user_activity_time";
    final String ISSUE_TYPE = "issue_type";
    final String FULL_PRIVACY_ENABLED = "full_privacy_enabled";
    final String FORM_NAME = "form_name";
    final String FORM_EMAIL = "form_email";
    final String DESCRIPTION_DRAFT = "description_draft";
    final String DESCRIPTION_DRAFT_TIMESTAMP = "description_draft_timestamp";
    final String ATTACHMENT_DRAFT = "attachment_draft";
    final String DESCRIPTION_TYPE = "description_type";
    final String ARCHIVAL_TEXT = "archival_text";
    final String REPLY_TEXT = "reply_text";
    final String PERSIST_MESSAGE_BOX = "persist_message_box";
    final String LAST_SYNC_TIMESTAMP = "since";
    final String HAS_OLDER_MESSAGES = "has_older_messages";
    final String LAST_CONVERSATIONS_REDACTION_TIME = "last_conv_redaction_time";
    final String CONVERSATION_ID = "conversation_id";
    final String BODY = "body";
    final String AUTHOR_NAME = "author_name";
    final String TYPE = "type";
    final String MESSAGE_META = "meta";
    final String DELIVERY_STATE = "md_state";
    final String IS_REDACTED_MESSAGE = "is_redacted";
    private final String CREATE_SERVER_ID_INDEX_MESSAGES_TABLE = "CREATE INDEX SERVER_IDX ON messages(server_id)";
    private String CREATE_CONVERSATION_TABLE = "CREATE TABLE issues ( _id INTEGER PRIMARY KEY AUTOINCREMENT,server_id TEXT, pre_conv_server_id TEXT, publish_id TEXT, uuid TEXT NOT NULL, user_local_id TEXT NOT NULL, title TEXT NOT NULL,issue_type TEXT NOT NULL, state INTEGER NOT NULL, show_agent_name INTEGER,message_cursor TEXT,start_new_conversation_action INTEGER, is_redacted INTEGER, meta TEXT,last_user_activity_time INTEGER, full_privacy_enabled INTEGER, epoch_time_created_at INTEGER NOT NULL, created_at TEXT NOT NULL,updated_at TEXT NOT NULL  );";
    private String CREATE_CONVERSATION_INBOX_TABLE = "CREATE TABLE conversation_inbox ( user_local_id TEXT PRIMARY KEY NOT NULL, form_name TEXT,form_email TEXT,description_draft TEXT,description_draft_timestamp TEXT,attachment_draft TEXT,description_type TEXT,archival_text TEXT, reply_text TEXT, persist_message_box INT, since TEXT, has_older_messages INT, last_conv_redaction_time INT );";
    private String CREATE_MESSAGES_TABLE = "CREATE TABLE messages ( _id INTEGER PRIMARY KEY AUTOINCREMENT, server_id TEXT, conversation_id TEXT, body TEXT, author_name TEXT, type TEXT, meta TEXT, is_redacted INTEGER, created_at TEXT, epoch_time_created_at INTEGER NOT NULL, md_state INTEGER  );";
    private String CREATE_FAQ_LIST_SUGGESTIONS_CACHE_TABLE = "CREATE TABLE faq_suggestions ( _id INTEGER PRIMARY KEY AUTOINCREMENT,question_id TEXT NOT NULL,publish_id TEXT NOT NULL,language TEXT NOT NULL,section_id TEXT NOT NULL,title TEXT NOT NULL,body TEXT NOT NULL,helpful INTEGER,rtl INTEGER,tags TEXT,c_tags TEXT );";
    private String ADD_HAS_OLDER_MESSAGES_COLUMN_INTO_INBOX_TABLE = "ALTER TABLE conversation_inbox ADD COLUMN has_older_messages INT ;";
    private String ADD_LAST_CONVERSATIONS_REDACTED_TIME_COLUMN_INTO_INBOX_TABLE = "ALTER TABLE conversation_inbox ADD COLUMN last_conv_redaction_time INT ;";
    private String ADD_FULL_PRIVACY_ENABLED_COLUMN_INTO_CONVERSATIONS_TABLE = "ALTER TABLE issues ADD COLUMN full_privacy_enabled INTEGER ;";
    private String ADD_IS_REDACTED_COLUMN_INTO_CONVERSATIONS_TABLE = "ALTER TABLE issues ADD COLUMN is_redacted INTEGER ;";
    private String ADD_EPOCH_TIME_CREATE_AT_COLUMN_INTO_CONVERSATIONS_TABLE = "ALTER TABLE issues ADD COLUMN epoch_time_created_at INTEGER NOT NULL DEFAULT 0 ;";
    private String ADD_IS_REDACTED_COLUMN_INTO_MESSAGES_TABLE = "ALTER TABLE messages ADD COLUMN is_redacted INTEGER ;";
    private String ADD_EPOCH_TIME_CREATE_AT_COLUMN_INTO_MESSAGES_TABLE = "ALTER TABLE messages ADD COLUMN epoch_time_created_at INTEGER NOT NULL DEFAULT 0 ;";

    @NonNull
    public List<String> getQueriesForOnCreate() {
        return new ArrayList<String>(Arrays.asList(this.CREATE_CONVERSATION_TABLE, this.CREATE_CONVERSATION_INBOX_TABLE, this.CREATE_MESSAGES_TABLE, "CREATE INDEX SERVER_IDX ON messages(server_id)", this.CREATE_FAQ_LIST_SUGGESTIONS_CACHE_TABLE));
    }

    @NonNull
    public List<String> getQueriesForOnUpgrade(int oldVersion) {
        ArrayList<String> queries = new ArrayList<String>();
        if (oldVersion < 6) {
            queries.addAll(this.getQueriesForDropAndCreate());
        } else if (oldVersion == 6) {
            queries.add(this.ADD_HAS_OLDER_MESSAGES_COLUMN_INTO_INBOX_TABLE);
            queries.add(this.ADD_LAST_CONVERSATIONS_REDACTED_TIME_COLUMN_INTO_INBOX_TABLE);
            queries.add(this.ADD_FULL_PRIVACY_ENABLED_COLUMN_INTO_CONVERSATIONS_TABLE);
            queries.add(this.ADD_IS_REDACTED_COLUMN_INTO_CONVERSATIONS_TABLE);
            queries.add(this.ADD_EPOCH_TIME_CREATE_AT_COLUMN_INTO_MESSAGES_TABLE);
            queries.add(this.ADD_IS_REDACTED_COLUMN_INTO_MESSAGES_TABLE);
            queries.add(this.ADD_EPOCH_TIME_CREATE_AT_COLUMN_INTO_CONVERSATIONS_TABLE);
        }
        return queries;
    }

    @NonNull
    public List<String> getQueriesForDropAndCreate() {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("DROP TABLE IF EXISTS issues");
        queries.add("DROP TABLE IF EXISTS conversation_inbox");
        queries.add("DROP TABLE IF EXISTS messages");
        queries.add("DROP TABLE IF EXISTS faq_suggestions");
        queries.addAll(this.getQueriesForOnCreate());
        return queries;
    }
}

