/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.common.domain.F;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.util.HSLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

class BackgroundThreader
implements Threader {
    private static final String TAG = "Helpshift_CoreBgTh";
    final ExecutorService service;

    BackgroundThreader(ExecutorService service) {
        this.service = service;
    }

    @Override
    public F thread(final F f) {
        return new F(){

            @Override
            public void f() {
                f.cause = new Throwable();
                try {
                    BackgroundThreader.this.service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                f.f();
                            }
                            catch (RootAPIException rootAPIException) {
                                if (rootAPIException.shouldLog()) {
                                    String message;
                                    ILogExtrasModel logExtrasModel = null;
                                    String string = message = rootAPIException.message == null ? "" : rootAPIException.message;
                                    if (rootAPIException.exceptionType instanceof NetworkException) {
                                        String route = ((NetworkException)rootAPIException.exceptionType).route;
                                        logExtrasModel = LogExtrasModelProvider.fromString("route", route);
                                    }
                                    HSLogger.e(BackgroundThreader.TAG, message, new Throwable[]{rootAPIException.exception, f.cause}, logExtrasModel);
                                }
                            }
                            catch (Exception e) {
                                String message = "Caught unhandled exception inside BackgroundThreader";
                                HSLogger.f(BackgroundThreader.TAG, message, new Throwable[]{e, f.cause}, new ILogExtrasModel[0]);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    HSLogger.e(BackgroundThreader.TAG, "Rejected execution of task in BackgroundThreader", e);
                }
            }
        };
    }
}

