/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.account.AuthenticationFailureDM;
import com.helpshift.account.domainmodel.UserManagerDM;
import com.helpshift.analytics.domainmodel.AnalyticsEventDM;
import com.helpshift.auth.domainmodel.WebSocketAuthDM;
import com.helpshift.cif.CustomIssueFieldDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.domain.AttachmentFileManagerDM;
import com.helpshift.common.domain.BackgroundDelayedThreader;
import com.helpshift.common.domain.BackgroundThreader;
import com.helpshift.common.domain.DelayedThreader;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.HSThreadFactory;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.HttpBackoff;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.domainmodel.ConversationInboxManagerDM;
import com.helpshift.crypto.CryptoDM;
import com.helpshift.delegate.RootDelegate;
import com.helpshift.delegate.UIThreadDelegateDecorator;
import com.helpshift.faq.FaqsDM;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import com.helpshift.logger.ErrorReportsDM;
import com.helpshift.meta.MetaDataDM;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Domain {
    private final Platform platform;
    private Threader serialThreader;
    private Threader parallelThreader;
    private DelayedThreader delayedThreader;
    private SDKConfigurationDM sdkConfigurationDM;
    private AnalyticsEventDM analyticsEventDM;
    private MetaDataDM metaDataDM;
    private UIThreadDelegateDecorator uiThreadDelegateDecorator;
    private FaqsDM faqsDM;
    private CryptoDM cryptoDM;
    private WebSocketAuthDM webSocketAuthDM;
    private LocaleProviderDM localeProviderDM;
    private AutoRetryFailedEventDM autoRetryFailedEventDM;
    private AttachmentFileManagerDM attachmentFileManagerDM;
    private CustomIssueFieldDM customIssueFieldDM;
    private UserManagerDM userManagerDM;
    private ConversationInboxManagerDM conversationInboxManagerDM;
    private AuthenticationFailureDM authenticationFailureDM;
    private ErrorReportsDM errorReportsDM;

    public Domain(Platform platform) {
        this.platform = platform;
        this.uiThreadDelegateDecorator = new UIThreadDelegateDecorator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Threader getSerialThreader() {
        if (this.serialThreader == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.serialThreader == null) {
                    ExecutorService service = Executors.newSingleThreadExecutor(new HSThreadFactory("core-s"));
                    this.serialThreader = new BackgroundThreader(service);
                }
            }
        }
        return this.serialThreader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Threader getParallelThreader() {
        if (this.parallelThreader == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.parallelThreader == null) {
                    ExecutorService service = Executors.newCachedThreadPool(new HSThreadFactory("core-p"));
                    this.parallelThreader = new BackgroundThreader(service);
                }
            }
        }
        return this.parallelThreader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelayedThreader getDelayedThreader() {
        if (this.delayedThreader == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.delayedThreader == null) {
                    ScheduledExecutorService service = Executors.newScheduledThreadPool(1, new HSThreadFactory("core-d"));
                    this.delayedThreader = new BackgroundDelayedThreader(service);
                }
            }
        }
        return this.delayedThreader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserManagerDM getUserManagerDM() {
        if (this.userManagerDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.userManagerDM == null) {
                    UserManagerDM localUserManagerDM = new UserManagerDM(this.platform, this);
                    localUserManagerDM.init();
                    this.userManagerDM = localUserManagerDM;
                }
            }
        }
        return this.userManagerDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationInboxManagerDM getConversationInboxManagerDM() {
        if (this.conversationInboxManagerDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.conversationInboxManagerDM == null) {
                    this.conversationInboxManagerDM = new ConversationInboxManagerDM(this.platform, this, this.getUserManagerDM());
                }
            }
        }
        return this.conversationInboxManagerDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDKConfigurationDM getSDKConfigurationDM() {
        if (this.sdkConfigurationDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.sdkConfigurationDM == null) {
                    this.sdkConfigurationDM = new SDKConfigurationDM(this, this.platform);
                }
            }
        }
        return this.sdkConfigurationDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyticsEventDM getAnalyticsEventDM() {
        if (this.analyticsEventDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.analyticsEventDM == null) {
                    this.analyticsEventDM = new AnalyticsEventDM(this, this.platform);
                }
            }
        }
        return this.analyticsEventDM;
    }

    public UIThreadDelegateDecorator getDelegate() {
        return this.uiThreadDelegateDecorator;
    }

    public void setDelegate(RootDelegate rootDelegate) {
        if (rootDelegate != null) {
            this.uiThreadDelegateDecorator.setDelegate(rootDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataDM getMetaDataDM() {
        if (this.metaDataDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.metaDataDM == null) {
                    this.metaDataDM = new MetaDataDM(this, this.platform, this.getSDKConfigurationDM());
                }
            }
        }
        return this.metaDataDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomIssueFieldDM getCustomIssueFieldDM() {
        if (this.customIssueFieldDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.customIssueFieldDM == null) {
                    this.customIssueFieldDM = new CustomIssueFieldDM(this, this.platform);
                }
            }
        }
        return this.customIssueFieldDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoDM getCryptoDM() {
        if (this.cryptoDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.cryptoDM == null) {
                    this.cryptoDM = new CryptoDM();
                }
            }
        }
        return this.cryptoDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaqsDM getFaqsDM() {
        if (this.faqsDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.faqsDM == null) {
                    this.faqsDM = new FaqsDM(this, this.platform);
                }
            }
        }
        return this.faqsDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocketAuthDM getWebSocketAuthDM() {
        if (this.webSocketAuthDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.webSocketAuthDM == null) {
                    this.webSocketAuthDM = new WebSocketAuthDM(this, this.platform);
                }
            }
        }
        return this.webSocketAuthDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocaleProviderDM getLocaleProviderDM() {
        if (this.localeProviderDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.localeProviderDM == null) {
                    this.localeProviderDM = new LocaleProviderDM(this.getSDKConfigurationDM(), this.platform);
                }
            }
        }
        return this.localeProviderDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentFileManagerDM getAttachmentFileManagerDM() {
        if (this.attachmentFileManagerDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.attachmentFileManagerDM == null) {
                    this.attachmentFileManagerDM = new AttachmentFileManagerDM(this, this.platform);
                }
            }
        }
        return this.attachmentFileManagerDM;
    }

    public void runSerial(F f) {
        this.getSerialThreader().thread(f).f();
    }

    public void runParallel(F f) {
        this.getParallelThreader().thread(f).f();
    }

    public void runOnUI(F f) {
        if (this.platform.isCurrentThreadUIThread()) {
            f.f();
        } else {
            this.platform.getUIThreader().thread(f).f();
        }
    }

    public void runDelayed(F f, long nextDelay) {
        this.getDelayedThreader().thread(f, nextDelay).f();
    }

    public void runDelayedInParallel(final F f, long afterDelay) {
        this.runDelayed(new F(){

            @Override
            public void f() {
                Domain.this.runParallel(f);
            }
        }, afterDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoRetryFailedEventDM getAutoRetryFailedEventDM() {
        if (this.autoRetryFailedEventDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.autoRetryFailedEventDM == null) {
                    HttpBackoff retryBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(5L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(60L, TimeUnit.SECONDS)).setMaxAttempts(10).setRandomness(0.1f).setMultiplier(2.0f).setRetryPolicy(HttpBackoff.RetryPolicy.FAILURE).build();
                    this.autoRetryFailedEventDM = new AutoRetryFailedEventDM(this, this.platform, retryBackoff);
                }
            }
        }
        return this.autoRetryFailedEventDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationFailureDM getAuthenticationFailureDM() {
        if (this.authenticationFailureDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.authenticationFailureDM == null) {
                    this.authenticationFailureDM = new AuthenticationFailureDM(this);
                }
            }
        }
        return this.authenticationFailureDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorReportsDM getErrorReportsDM() {
        if (this.errorReportsDM == null) {
            Domain domain = this;
            synchronized (domain) {
                if (this.errorReportsDM == null) {
                    this.errorReportsDM = new ErrorReportsDM(this.platform, this);
                }
            }
        }
        return this.errorReportsDM;
    }
}

