/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.PollingInterval;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.poller.HttpBackoff;
import com.helpshift.util.HSLogger;

public class PollFunction
extends F {
    private static final String TAG = "Helpshift_PollFunc";
    private HttpBackoff backoff;
    private final F poll;
    private final Domain domain;
    private boolean shouldPoll;
    private final PollingInterval pollingInterval;
    private final PollFunctionListener listener;

    public PollFunction(Domain domain, HttpBackoff backoff, F poll, PollingInterval interval, PollFunctionListener listener) {
        this.backoff = backoff;
        this.poll = poll;
        this.domain = domain;
        this.pollingInterval = interval;
        this.listener = listener;
    }

    @Override
    public void f() {
        int responseCode;
        if (!this.shouldPoll) {
            return;
        }
        try {
            HSLogger.d(TAG, "Running:" + this.pollingInterval.name());
            this.poll.f();
            responseCode = NetworkErrorCodes.OK;
        }
        catch (RootAPIException e) {
            if (e.exceptionType instanceof NetworkException) {
                responseCode = e.getServerStatusCode();
            }
            throw e;
        }
        long nextDelay = this.backoff.nextIntervalMillis(responseCode);
        if (nextDelay == -100L) {
            if (this.listener != null) {
                this.listener.onPollingStoppedViaBackoffStrategy();
            }
        } else {
            this.schedulePoll(nextDelay);
        }
    }

    void schedulePoll(long afterDelay) {
        this.domain.runDelayedInParallel(this, afterDelay);
    }

    public void start(long afterDelay) {
        HSLogger.d(TAG, "Start: " + this.pollingInterval.name());
        if (!this.shouldPoll) {
            this.shouldPoll = true;
            this.schedulePoll(afterDelay);
        }
    }

    public void stop() {
        HSLogger.d(TAG, "Stop: " + this.pollingInterval.name());
        this.shouldPoll = false;
        this.backoff.reset();
    }

    public static interface PollFunctionListener {
        public void onPollingStoppedViaBackoffStrategy();
    }
}

