/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.PollFunction;
import com.helpshift.common.domain.PollingInterval;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.HttpBackoff;
import java.util.concurrent.TimeUnit;

public class Poller {
    private final Domain domain;
    private final F poll;
    private PollFunction activePollFunction;
    private HttpBackoff conservativeBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(5L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(1L, TimeUnit.MINUTES)).setRandomness(0.1f).setMultiplier(2.0f).setRetryPolicy(this.getPollerRetryPollicy()).build();
    private HttpBackoff aggressiveBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(3L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(3L, TimeUnit.SECONDS)).setRandomness(0.0f).setMultiplier(1.0f).setRetryPolicy(this.getPollerRetryPollicy()).build();
    private HttpBackoff passiveBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(30L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(5L, TimeUnit.MINUTES)).setRandomness(0.1f).setMultiplier(4.0f).setRetryPolicy(this.getPollerRetryPollicy()).build();

    public Poller(Domain domain, F fetchUpdates) {
        this.domain = domain;
        this.poll = fetchUpdates;
    }

    public synchronized void start(PollingInterval interval, long afterDelay, PollFunction.PollFunctionListener listener) {
        this.stop();
        if (interval == null) {
            return;
        }
        switch (interval) {
            case AGGRESSIVE: {
                this.activePollFunction = new PollFunction(this.domain, this.aggressiveBackoff, this.poll, PollingInterval.AGGRESSIVE, listener);
                break;
            }
            case PASSIVE: {
                this.activePollFunction = new PollFunction(this.domain, this.passiveBackoff, this.poll, PollingInterval.PASSIVE, listener);
                break;
            }
            case CONSERVATIVE: {
                this.activePollFunction = new PollFunction(this.domain, this.conservativeBackoff, this.poll, PollingInterval.CONSERVATIVE, listener);
            }
        }
        this.activePollFunction.start(afterDelay);
    }

    public synchronized void stop() {
        if (this.activePollFunction != null) {
            this.activePollFunction.stop();
            this.activePollFunction = null;
        }
    }

    private HttpBackoff.RetryPolicy getPollerRetryPollicy() {
        return new HttpBackoff.RetryPolicy(){

            @Override
            public boolean shouldRetry(int statusCode) {
                if (statusCode == NetworkErrorCodes.AUTH_TOKEN_NOT_PROVIDED || statusCode == NetworkErrorCodes.INVALID_AUTH_TOKEN) {
                    return false;
                }
                return !NetworkErrorCodes.NOT_RETRIABLE_STATUS_CODES.contains(statusCode);
            }
        };
    }
}

